/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.BlockRailBase;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemMinecart;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.CartVersion;
import vswe.stevescarts.Helpers.ColorHelper;
import vswe.stevescarts.Helpers.ModuleCountPair;
import vswe.stevescarts.ModuleData.ModuleData;
import vswe.stevescarts.StevesCarts;

public class ItemCarts
extends ItemMinecart {
    public ItemCarts() {
        super(0);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(null);
    }

    public String getName() {
        return "Modular cart";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.field_77791_bV = register.func_94245_a(StevesCarts.instance.textureHeader + ":" + "modular_cart" + "_icon");
    }

    public boolean func_77648_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, World par3World, int par4, int par5, int par6, int par7, float par8, float par9, float par10) {
        CartVersion.updateItemStack(par1ItemStack);
        if (BlockRailBase.func_150049_b_((World)par3World, (int)par4, (int)par5, (int)par6)) {
            if (!par3World.field_72995_K) {
                try {
                    NBTTagCompound info = par1ItemStack.func_77978_p();
                    if (info != null && !info.func_74764_b("maxTime")) {
                        MinecartModular cart = new MinecartModular(par3World, (float)par4 + 0.5f, (float)par5 + 0.5f, (float)par6 + 0.5f, info, par1ItemStack.func_82833_r());
                        par3World.func_72838_d((Entity)cart);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
            --par1ItemStack.field_77994_a;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack item, EntityPlayer player, List list, boolean useExtraInfo) {
        CartVersion.updateItemStack(item);
        NBTTagCompound info = item.func_77978_p();
        if (info != null) {
            NBTTagByteArray moduleIDTag = (NBTTagByteArray)info.func_74781_a("Modules");
            byte[] bytes = moduleIDTag.func_150292_c();
            ArrayList<ModuleCountPair> counts = new ArrayList<ModuleCountPair>();
            for (int i = 0; i < bytes.length; ++i) {
                byte id = bytes[i];
                ModuleData module = ModuleData.getList().get(id);
                if (module == null) continue;
                boolean found = false;
                if (!info.func_74764_b("Data" + i)) {
                    for (ModuleCountPair count : counts) {
                        if (!count.isContainingData(module)) continue;
                        count.increase();
                        found = true;
                        break;
                    }
                }
                if (found) continue;
                ModuleCountPair count = new ModuleCountPair(module);
                if (info.func_74764_b("Data" + i)) {
                    count.setExtraData(info.func_74771_c("Data" + i));
                }
                counts.add(count);
            }
            for (ModuleCountPair count : counts) {
                list.add(count.toString());
            }
            if (info.func_74764_b("Spares")) {
                byte[] spares = info.func_74770_j("Spares");
                for (int i = 0; i < spares.length; ++i) {
                    byte id = spares[i];
                    ModuleData module = ModuleData.getList().get(id);
                    if (module == null) continue;
                    String name = module.getName();
                    if (info.func_74764_b("Data" + (bytes.length + i))) {
                        name = module.getCartInfoText(name, info.func_74771_c("Data" + (bytes.length + i)));
                    }
                    list.add((Object)((Object)ColorHelper.ORANGE) + name);
                }
            }
            if (info.func_74764_b("maxTime")) {
                list.add((Object)((Object)ColorHelper.RED) + "Incomplete cart!");
                int maxTime = info.func_74762_e("maxTime");
                int currentTime = info.func_74762_e("currentTime");
                int timeLeft = maxTime - currentTime;
                list.add((Object)((Object)ColorHelper.RED) + "Time left: " + this.formatTime(timeLeft));
            }
        } else {
            list.add("No modules loaded");
        }
    }

    private String formatTime(int ticks) {
        int seconds = ticks / 20;
        ticks -= seconds * 20;
        int minutes = seconds / 60;
        seconds -= minutes * 60;
        int hours = minutes / 60;
        return String.format("%02d:%02d:%02d", hours, minutes -= hours * 60, seconds);
    }

    public boolean func_77651_p() {
        return true;
    }
}

