/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Addons;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Helpers.Localization;
import vswe.stevescarts.Helpers.ResourceHelper;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.Addons.ModuleAddon;
import vswe.stevescarts.Modules.IActivatorModule;

public class ModuleShield
extends ModuleAddon
implements IActivatorModule {
    private boolean shield = true;
    private float shieldDistance = 18.0f;
    private float shieldAngle;
    private int[] buttonRect = new int[]{20, 20, 24, 12};

    public ModuleShield(MinecartModular cart) {
        super(cart);
    }

    protected boolean shieldSetting() {
        return this.getShieldStatus();
    }

    public float getShieldDistance() {
        return this.shieldDistance;
    }

    public float getShieldAngle() {
        return this.shieldAngle;
    }

    public boolean hasShield() {
        return this.shield;
    }

    @Override
    public void update() {
        super.update();
        if (this.hasShield() && !this.getCart().hasFuelForModule() && !this.getCart().field_70170_p.field_72995_K) {
            this.setShieldStatus(false);
        }
        if (this.shield) {
            this.getCart().func_70066_B();
        }
        if (!this.getShieldStatus() && this.shieldDistance > 0.0f) {
            this.shieldDistance -= 0.25f;
            if (this.shieldDistance <= 0.0f) {
                this.shield = false;
            }
        } else if (this.getShieldStatus() && this.shieldDistance < 18.0f) {
            this.shieldDistance += 0.25f;
            this.shield = true;
        }
        if (this.shield) {
            this.shieldAngle = (float)((double)(this.shieldAngle + 0.125f) % 314.1592653589793);
        }
    }

    public boolean receiveDamage(DamageSource source, int val) {
        return !this.hasShield();
    }

    @Override
    public boolean hasSlots() {
        return false;
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 75;
    }

    @Override
    public int guiHeight() {
        return 35;
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    public void setShieldStatus(boolean val) {
        if (!this.isPlaceholder()) {
            this.updateDw(0, (byte)(val ? 1 : 0));
        }
    }

    private boolean getShieldStatus() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getShieldActive();
        }
        return this.getDw(0) != 0;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/shield.png");
        int imageID = this.getShieldStatus() ? 1 : 0;
        int borderID = 0;
        if (this.inRect(x, y, this.buttonRect)) {
            borderID = 1;
        }
        this.drawImage(gui, this.buttonRect, 0, this.buttonRect[3] * borderID);
        int srcY = this.buttonRect[3] * 2 + imageID * (this.buttonRect[3] - 2);
        this.drawImage(gui, this.buttonRect[0] + 1, this.buttonRect[1] + 1, 0, srcY, this.buttonRect[2] - 2, this.buttonRect[3] - 2);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, this.getStateName(), x, y, this.buttonRect);
    }

    private String getStateName() {
        return Localization.MODULES.ADDONS.SHIELD.translate(this.getShieldStatus() ? "1" : "0");
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.buttonRect)) {
            this.sendPacket(0);
        }
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.updateDw(0, this.getShieldStatus() ? 0 : 1);
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void initDw() {
        this.addDw(0, 0);
    }

    @Override
    public int getConsumption(boolean isMoving) {
        return this.hasShield() ? 20 : super.getConsumption(isMoving);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74757_a(this.generateNBTName("Shield", id), this.getShieldStatus());
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.setShieldStatus(tagCompound.func_74767_n(this.generateNBTName("Shield", id)));
    }

    @Override
    public void doActivate(int id) {
        this.setShieldStatus(true);
    }

    @Override
    public void doDeActivate(int id) {
        this.setShieldStatus(false);
    }

    @Override
    public boolean isActive(int id) {
        return this.getShieldStatus();
    }
}

