/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.Modules.Realtimers;

import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.init.Items;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Interfaces.GuiMinecart;
import vswe.stevescarts.Modules.ModuleBase;
import vswe.stevescarts.Slots.SlotBase;
import vswe.stevescarts.Slots.SlotFirework;

public class ModuleFirework
extends ModuleBase {
    private int fireCooldown;

    public ModuleFirework(MinecartModular cart) {
        super(cart);
    }

    @Override
    public void update() {
        if (this.fireCooldown > 0) {
            --this.fireCooldown;
        }
    }

    @Override
    public void activatedByRail(int x, int y, int z, boolean active) {
        if (active && this.fireCooldown == 0 && this.getCart().hasFuel()) {
            this.fire();
            this.fireCooldown = 20;
        }
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotFirework(this.getCart(), slotId, 8 + x * 18, 16 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public int guiWidth() {
        return 15 + this.getInventoryWidth() * 18;
    }

    @Override
    public int guiHeight() {
        return 20 + this.getInventoryHeight() * 18;
    }

    @Override
    protected int getInventoryWidth() {
        return 8;
    }

    @Override
    protected int getInventoryHeight() {
        return 3;
    }

    public void fire() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        ItemStack firework = this.getFirework();
        if (firework != null) {
            this.launchFirework(firework);
        }
    }

    private ItemStack getFirework() {
        boolean hasGunpowder = false;
        boolean hasPaper = false;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null) continue;
            if (item.func_77973_b() == Items.field_151152_bP) {
                ItemStack firework = item.func_77946_l();
                firework.field_77994_a = 1;
                this.removeItemStack(item, 1, i);
                return firework;
            }
            if (item.func_77973_b() == Items.field_151121_aF) {
                hasPaper = true;
                continue;
            }
            if (item.func_77973_b() != Items.field_151016_H) continue;
            hasGunpowder = true;
        }
        if (hasPaper && hasGunpowder) {
            ItemStack charge;
            int chargeCount;
            ItemStack firework = new ItemStack(Items.field_151152_bP);
            int maxGunpowder = this.getCart().field_70146_Z.nextInt(3) + 1;
            int countGunpowder = 0;
            boolean removedPaper = false;
            for (int i = 0; i < this.getInventorySize(); ++i) {
                ItemStack item = this.getStack(i);
                if (item == null) continue;
                if (item.func_77973_b() == Items.field_151121_aF && !removedPaper) {
                    this.removeItemStack(item, 1, i);
                    removedPaper = true;
                    continue;
                }
                if (item.func_77973_b() != Items.field_151016_H || countGunpowder >= maxGunpowder) continue;
                while (item.field_77994_a > 0 && countGunpowder < maxGunpowder) {
                    ++countGunpowder;
                    this.removeItemStack(item, 1, i);
                }
            }
            for (chargeCount = 1; chargeCount < 7 && this.getCart().field_70146_Z.nextInt(3 + chargeCount / 3) == 0; ++chargeCount) {
            }
            NBTTagCompound itemstackNBT = new NBTTagCompound();
            NBTTagCompound fireworksNBT = new NBTTagCompound();
            NBTTagList explosionsNBT = new NBTTagList();
            for (int i = 0; i < chargeCount && (charge = this.getCharge()) != null; ++i) {
                if (!charge.func_77942_o() || !charge.func_77978_p().func_74764_b("Explosion")) continue;
                explosionsNBT.func_74742_a((NBTBase)charge.func_77978_p().func_74775_l("Explosion"));
            }
            fireworksNBT.func_74782_a("Explosions", (NBTBase)explosionsNBT);
            fireworksNBT.func_74774_a("Flight", (byte)countGunpowder);
            itemstackNBT.func_74782_a("Fireworks", (NBTBase)fireworksNBT);
            firework.func_77982_d(itemstackNBT);
            return firework;
        }
        return null;
    }

    private ItemStack getCharge() {
        int[] fade;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || item.func_77973_b() != Items.field_151154_bQ) continue;
            ItemStack charge = item.func_77946_l();
            charge.field_77994_a = 1;
            this.removeItemStack(item, 1, i);
            return charge;
        }
        ItemStack charge = new ItemStack(Items.field_151154_bQ);
        NBTTagCompound itemNBT = new NBTTagCompound();
        NBTTagCompound explosionNBT = new NBTTagCompound();
        byte type = 0;
        boolean removedGunpowder = false;
        boolean canHasTrail = this.getCart().field_70146_Z.nextInt(16) == 0;
        boolean canHasFlicker = this.getCart().field_70146_Z.nextInt(8) == 0;
        boolean canHasModifier = this.getCart().field_70146_Z.nextInt(4) == 0;
        byte modifierType = (byte)(this.getCart().field_70146_Z.nextInt(4) + 1);
        boolean removedModifier = false;
        boolean removedDiamond = false;
        boolean removedGlow = false;
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null) continue;
            if (item.func_77973_b() == Items.field_151016_H && !removedGunpowder) {
                this.removeItemStack(item, 1, i);
                removedGunpowder = true;
                continue;
            }
            if (item.func_77973_b() == Items.field_151114_aO && canHasFlicker && !removedGlow) {
                this.removeItemStack(item, 1, i);
                removedGlow = true;
                explosionNBT.func_74757_a("Flicker", true);
                continue;
            }
            if (item.func_77973_b() == Items.field_151045_i && canHasTrail && !removedDiamond) {
                this.removeItemStack(item, 1, i);
                removedDiamond = true;
                explosionNBT.func_74757_a("Trail", true);
                continue;
            }
            if (!canHasModifier || removedModifier || !(item.func_77973_b() == Items.field_151059_bz && modifierType == 1 || item.func_77973_b() == Items.field_151074_bl && modifierType == 2 || item.func_77973_b() == Items.field_151144_bL && modifierType == 3) && (item.func_77973_b() != Items.field_151008_G || modifierType != 4)) continue;
            this.removeItemStack(item, 1, i);
            removedModifier = true;
            type = modifierType;
        }
        int[] colors = this.generateColors(type != 0 ? 7 : 8);
        if (colors == null) {
            return null;
        }
        explosionNBT.func_74783_a("Colors", colors);
        if (this.getCart().field_70146_Z.nextInt(4) == 0 && (fade = this.generateColors(8)) != null) {
            explosionNBT.func_74783_a("FadeColors", fade);
        }
        explosionNBT.func_74774_a("Type", type);
        itemNBT.func_74782_a("Explosion", (NBTBase)explosionNBT);
        charge.func_77982_d(itemNBT);
        return charge;
    }

    private int[] generateColors(int maxColorCount) {
        int i;
        int colorCount;
        int[] maxColors = new int[16];
        int[] currentColors = new int[16];
        for (int i2 = 0; i2 < this.getInventorySize(); ++i2) {
            ItemStack item = this.getStack(i2);
            if (item == null || item.func_77973_b() != Items.field_151100_aR) continue;
            int n = item.func_77960_j();
            maxColors[n] = maxColors[n] + item.field_77994_a;
        }
        for (colorCount = this.getCart().field_70146_Z.nextInt(2) + 1; colorCount <= maxColorCount - 2 && this.getCart().field_70146_Z.nextInt(2) == 0; colorCount += 2) {
        }
        ArrayList<Integer> colorPointers = new ArrayList<Integer>();
        for (int i3 = 0; i3 < 16; ++i3) {
            if (maxColors[i3] <= 0) continue;
            colorPointers.add(i3);
        }
        if (colorPointers.size() == 0) {
            return null;
        }
        ArrayList<Integer> usedColors = new ArrayList<Integer>();
        while (colorCount > 0 && colorPointers.size() > 0) {
            int colorId;
            int pointerId = this.getCart().field_70146_Z.nextInt(colorPointers.size());
            int n = colorId = ((Integer)colorPointers.get(pointerId)).intValue();
            currentColors[n] = currentColors[n] + 1;
            int n2 = colorId;
            maxColors[n2] = maxColors[n2] - 1;
            if (maxColors[n2] <= 0) {
                colorPointers.remove(pointerId);
            }
            usedColors.add(colorId);
            --colorCount;
        }
        int[] colors = new int[usedColors.size()];
        for (i = 0; i < colors.length; ++i) {
            colors[i] = ItemDye.field_150922_c[(Integer)usedColors.get(i)];
        }
        for (i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || item.func_77973_b() != Items.field_151100_aR || currentColors[item.func_77960_j()] <= 0) continue;
            int count = Math.min(currentColors[item.func_77960_j()], item.field_77994_a);
            int n = item.func_77960_j();
            currentColors[n] = currentColors[n] - count;
        }
        return colors;
    }

    private void removeItemStack(ItemStack item, int count, int id) {
        if (!this.getCart().hasCreativeSupplies()) {
            item.field_77994_a -= count;
            if (item.field_77994_a <= 0) {
                this.setStack(id, null);
            }
        }
    }

    private void launchFirework(ItemStack firework) {
        EntityFireworkRocket rocket = new EntityFireworkRocket(this.getCart().field_70170_p, this.getCart().field_70165_t, this.getCart().field_70163_u + 1.0, this.getCart().field_70161_v, firework);
        this.getCart().field_70170_p.func_72838_d((Entity)rocket);
    }
}

