/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.TileEntities;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import vswe.stevescarts.Carts.MinecartModular;
import vswe.stevescarts.Containers.ContainerManager;
import vswe.stevescarts.Helpers.ManagerTransfer;
import vswe.stevescarts.Helpers.NBTHelper;
import vswe.stevescarts.PacketHandler;
import vswe.stevescarts.TileEntities.TileEntityBase;

public abstract class TileEntityManager
extends TileEntityBase
implements IInventory {
    private ManagerTransfer standardTransferHandler;
    private ItemStack[] cargoItemStacks;
    public int layoutType;
    public int moveTime = 0;
    public boolean[] toCart = new boolean[]{true, true, true, true};
    public boolean[] doReturn = new boolean[]{false, false, false, false};
    public int[] amount = new int[]{0, 0, 0, 0};
    public int[] color = new int[]{1, 2, 3, 4};

    public TileEntityManager() {
        this.cargoItemStacks = new ItemStack[this.func_70302_i_()];
        this.standardTransferHandler = new ManagerTransfer();
    }

    public ItemStack func_70301_a(int i) {
        return this.cargoItemStacks[i];
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.cargoItemStacks[i] != null) {
            if (this.cargoItemStacks[i].field_77994_a <= j) {
                ItemStack itemstack = this.cargoItemStacks[i];
                this.cargoItemStacks[i] = null;
                this.func_70296_d();
                return itemstack;
            }
            ItemStack itemstack1 = this.cargoItemStacks[i].func_77979_a(j);
            if (this.cargoItemStacks[i].field_77994_a == 0) {
                this.cargoItemStacks[i] = null;
            }
            this.func_70296_d();
            return itemstack1;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.cargoItemStacks[i] = itemstack;
        if (itemstack != null && itemstack.field_77994_a > this.func_70297_j_()) {
            itemstack.field_77994_a = this.func_70297_j_();
        }
        this.func_70296_d();
    }

    public String func_145825_b() {
        return "container.cargomanager";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        this.cargoItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte byte0 = nbttagcompound1.func_74771_c("Slot");
            if (byte0 < 0 || byte0 >= this.cargoItemStacks.length) continue;
            this.cargoItemStacks[byte0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.moveTime = nbttagcompound.func_74771_c("movetime");
        this.setLowestSetting(nbttagcompound.func_74771_c("lowestNumber"));
        this.layoutType = nbttagcompound.func_74771_c("layout");
        byte temp = nbttagcompound.func_74771_c("tocart");
        byte temp2 = nbttagcompound.func_74771_c("doReturn");
        for (int i = 0; i < 4; ++i) {
            this.amount[i] = nbttagcompound.func_74771_c("amount" + i);
            this.color[i] = nbttagcompound.func_74771_c("color" + i);
            if (this.color[i] == 0) {
                this.color[i] = i + 1;
            }
            this.toCart[i] = (temp & 1 << i) != 0;
            this.doReturn[i] = (temp2 & 1 << i) != 0;
        }
    }

    public void func_145841_b(NBTTagCompound nbttagcompound) {
        super.func_145841_b(nbttagcompound);
        nbttagcompound.func_74774_a("movetime", (byte)this.moveTime);
        nbttagcompound.func_74774_a("lowestNumber", (byte)this.getLowestSetting());
        nbttagcompound.func_74774_a("layout", (byte)this.layoutType);
        byte temp = 0;
        byte temp2 = 0;
        for (int i = 0; i < 4; ++i) {
            nbttagcompound.func_74774_a("amount" + i, (byte)this.amount[i]);
            nbttagcompound.func_74774_a("color" + i, (byte)this.color[i]);
            if (this.toCart[i]) {
                temp = (byte)(temp | 1 << i);
            }
            if (!this.doReturn[i]) continue;
            temp2 = (byte)(temp2 | 1 << i);
        }
        nbttagcompound.func_74774_a("tocart", temp);
        nbttagcompound.func_74774_a("doReturn", temp2);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.cargoItemStacks.length; ++i) {
            if (this.cargoItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.cargoItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public int func_70297_j_() {
        return 64;
    }

    public MinecartModular getCart() {
        return this.standardTransferHandler.getCart();
    }

    public void setCart(MinecartModular cart) {
        this.standardTransferHandler.setCart(cart);
    }

    public int getSetting() {
        return this.standardTransferHandler.getSetting();
    }

    public void setSetting(int val) {
        this.standardTransferHandler.setSetting(val);
    }

    public int getSide() {
        return this.standardTransferHandler.getSide();
    }

    public void setSide(int val) {
        this.standardTransferHandler.setSide(val);
    }

    public int getLastSetting() {
        return this.standardTransferHandler.getLastSetting();
    }

    public void setLastSetting(int val) {
        this.standardTransferHandler.setLastSetting(val);
    }

    public int getLowestSetting() {
        return this.standardTransferHandler.getLowestSetting();
    }

    public void setLowestSetting(int val) {
        this.standardTransferHandler.setLowestSetting(val);
    }

    public int getWorkload() {
        return this.standardTransferHandler.getWorkload();
    }

    public void setWorkload(int val) {
        this.standardTransferHandler.setWorkload(val);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.updateLayout();
            return;
        }
        if (this.getCart() == null || this.getCart().field_70128_L || this.getSide() < 0 || this.getSide() > 3 || !this.getCart().isDisabled()) {
            this.standardTransferHandler.reset();
            return;
        }
        ++this.moveTime;
        if (this.moveTime >= 24) {
            this.moveTime = 0;
            if (!this.exchangeItems(this.standardTransferHandler)) {
                this.getCart().releaseCart();
                if (this.doReturn[this.getSide()]) {
                    this.getCart().turnback();
                }
                this.standardTransferHandler.reset();
            }
        }
    }

    public boolean exchangeItems(ManagerTransfer transfer) {
        transfer.setSetting(transfer.getLowestSetting());
        while (transfer.getSetting() < 4) {
            if (this.color[transfer.getSetting()] - 1 == transfer.getSide()) {
                transfer.setLowestSetting(transfer.getSetting());
                if (transfer.getLastSetting() != transfer.getSetting()) {
                    transfer.setWorkload(0);
                    transfer.setLastSetting(transfer.getSetting());
                    return true;
                }
                if (!(this.toCart[transfer.getSetting()] ? transfer.getToCartEnabled() : transfer.getFromCartEnabled()) || !this.isTargetValid(transfer)) {
                    transfer.setLowestSetting(transfer.getSetting() + 1);
                    return true;
                }
                if (this.doTransfer(transfer)) {
                    return true;
                }
            }
            transfer.setSetting(transfer.getSetting() + 1);
        }
        return false;
    }

    public void sendPacket(int id) {
        this.sendPacket(id, new byte[0]);
    }

    public void sendPacket(int id, byte data) {
        this.sendPacket(id, new byte[]{data});
    }

    public void sendPacket(int id, byte[] data) {
        PacketHandler.sendPacket(id, data);
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            byte railID = data[0];
            boolean bl = this.toCart[railID] = !this.toCart[railID];
            if (this.color[railID] - 1 == this.getSide()) {
                this.reset();
            }
        } else if (id == 4) {
            byte railID = data[0];
            if (this.color[railID] != 5) {
                this.doReturn[this.color[railID] - 1] = !this.doReturn[this.color[railID] - 1];
            }
        } else if (id == 5) {
            byte difference = data[0];
            this.layoutType += difference;
            if (this.layoutType > 2) {
                this.layoutType = 0;
            } else if (this.layoutType < 0) {
                this.layoutType = 2;
            }
            this.reset();
        } else {
            byte railsAndDifferenceCombined = data[0];
            int railID = railsAndDifferenceCombined & 3;
            int k = (railsAndDifferenceCombined & 4) >> 2;
            int difference = k == 0 ? 1 : -1;
            if (id == 2) {
                int n = railID;
                this.amount[n] = this.amount[n] + difference;
                if (this.amount[railID] >= this.getAmountCount()) {
                    this.amount[railID] = 0;
                } else if (this.amount[railID] < 0) {
                    this.amount[railID] = this.getAmountCount() - 1;
                }
                if (this.color[railID] - 1 == this.getSide()) {
                    this.reset();
                }
            } else if (id == 3) {
                if (this.color[railID] != 5) {
                    boolean willStillExist = false;
                    for (int side = 0; side < 4; ++side) {
                        if (side == railID || this.color[railID] != this.color[side]) continue;
                        willStillExist = true;
                        break;
                    }
                    if (!willStillExist) {
                        this.doReturn[this.color[railID] - 1] = false;
                    }
                }
                int n = railID;
                this.color[n] = this.color[n] + difference;
                if (this.color[railID] > 5) {
                    this.color[railID] = 1;
                } else if (this.color[railID] < 1) {
                    this.color[railID] = 5;
                }
                if (this.color[railID] - 1 == this.getSide()) {
                    this.reset();
                }
            } else {
                this.receiveClickData(id, railID, difference);
            }
        }
    }

    @Override
    public void initGuiData(Container con, ICrafting crafting) {
        this.checkGuiData((ContainerManager)con, crafting, true);
    }

    @Override
    public void checkGuiData(Container con, ICrafting crafting) {
        this.checkGuiData((ContainerManager)con, crafting, false);
    }

    public void checkGuiData(ContainerManager con, ICrafting crafting, boolean isNew) {
        int i;
        short header = (short)(this.moveTime & 0x1F);
        header = (short)(header | (this.layoutType & 3) << 5);
        for (i = 0; i < 4; ++i) {
            header = (short)(header | (this.toCart[i] ? 1 : 0) << 7 + i);
        }
        for (i = 0; i < 4; ++i) {
            header = (short)(header | (this.doReturn[i] ? 1 : 0) << 11 + i);
        }
        if (isNew || con.lastHeader != header) {
            this.updateGuiData(con, crafting, 0, header);
            con.lastHeader = header;
        }
        short colorShort = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            colorShort = (short)(colorShort | (this.color[i2] & 7) << i2 * 3);
        }
        colorShort = (short)(colorShort | (this.getLastSetting() & 7) << 12);
        if (isNew || con.lastColor != colorShort) {
            this.updateGuiData(con, crafting, 1, colorShort);
            con.lastColor = colorShort;
        }
        short amountShort = 0;
        for (int i3 = 0; i3 < 4; ++i3) {
            amountShort = (short)(amountShort | (this.amount[i3] & 0xF) << i3 * 4);
        }
        if (isNew || con.lastAmount != amountShort) {
            this.updateGuiData(con, crafting, 3, amountShort);
            con.lastAmount = amountShort;
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        block5: {
            block6: {
                block4: {
                    int i;
                    if (id != 0) break block4;
                    this.moveTime = data & 0x1F;
                    this.layoutType = (data & 0x60) >> 5;
                    this.updateLayout();
                    for (i = 0; i < 4; ++i) {
                        this.toCart[i] = (data & 1 << 7 + i) != 0;
                    }
                    for (i = 0; i < 4; ++i) {
                        this.doReturn[i] = (data & 1 << 11 + i) != 0;
                    }
                    break block5;
                }
                if (id != 1) break block6;
                for (int i = 0; i < 4; ++i) {
                    this.color[i] = (data & 7 << i * 3) >> i * 3;
                }
                this.setLastSetting((data & 0x7000) >> 12);
                break block5;
            }
            if (id != 3) break block5;
            for (int i = 0; i < 4; ++i) {
                this.amount[i] = (data & 15 << i * 4) >> i * 4;
            }
        }
    }

    public int moveProgressScaled(int i) {
        return this.moveTime * i / 24;
    }

    public void func_70305_f() {
    }

    public void func_70295_k_() {
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.cargoItemStacks[par1] != null) {
            ItemStack var2 = this.cargoItemStacks[par1];
            this.cargoItemStacks[par1] = null;
            return var2;
        }
        return null;
    }

    protected void updateLayout() {
    }

    protected void receiveClickData(int packetid, int id, int dif) {
    }

    protected abstract boolean isTargetValid(ManagerTransfer var1);

    protected abstract boolean doTransfer(ManagerTransfer var1);

    public abstract int getAmountCount();

    protected void reset() {
        this.moveTime = 0;
        this.setWorkload(0);
    }

    protected int getAmountId(int id) {
        return this.amount[id];
    }
}

