/*
 * Decompiled with CFR 0.152.
 */
package com.reaper.dynamicmaze;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.WeightedRandom;
import net.minecraft.world.World;

public abstract class WolfSpawnerBaseLogic {
    public int spawnDelay = 20;
    private String entityTypeName = "Wolf";
    private List potentialEntitySpawns;
    private WeightedRandomMinecart randomEntity;
    public double field_98287_c;
    public double field_98284_d;
    private int minSpawnDelay = 200;
    private int maxSpawnDelay = 600;
    private int spawnCount = 10;
    private Entity field_98291_j;
    private int maxNearbyEntities = 6;
    private int activatingRangeFromPlayer = 16;
    private int spawnRange = 1;

    public String getEntityNameToSpawn() {
        if (this.getRandomEntity() == null) {
            if (this.entityTypeName.equals("Minecart")) {
                this.entityTypeName = "MinecartRideable";
            }
            return this.entityTypeName;
        }
        return this.getRandomEntity().entityTypeName;
    }

    public void setEntityName(String par1Str) {
        this.entityTypeName = par1Str;
    }

    public boolean isActivated() {
        return this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer) != null;
    }

    public void updateSpawner() {
        if (this.isActivated()) {
            if (this.getSpawnerWorld().field_72995_K) {
                double d0 = (float)this.getSpawnerX() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d1 = (float)this.getSpawnerY() + this.getSpawnerWorld().field_73012_v.nextFloat();
                double d2 = (float)this.getSpawnerZ() + this.getSpawnerWorld().field_73012_v.nextFloat();
                this.getSpawnerWorld().func_72869_a("smoke", d0, d1, d2, 0.0, 0.0, 0.0);
                this.getSpawnerWorld().func_72869_a("flame", d0, d1, d2, 0.0, 0.0, 0.0);
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                }
                this.field_98284_d = this.field_98287_c;
                this.field_98287_c = (this.field_98287_c + (double)(1000.0f / ((float)this.spawnDelay + 200.0f))) % 360.0;
            } else {
                if (this.spawnDelay == -1) {
                    this.resetTimer();
                }
                if (this.spawnDelay > 0) {
                    --this.spawnDelay;
                    return;
                }
                boolean flag = false;
                for (int i = 0; i < this.spawnCount; ++i) {
                    Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)this.getSpawnerWorld());
                    if (entity instanceof EntityLiving) {
                        ((EntityLiving)entity).func_70624_b((EntityLivingBase)this.getSpawnerWorld().func_72977_a((double)this.getSpawnerX() + 0.5, (double)this.getSpawnerY() + 0.5, (double)this.getSpawnerZ() + 0.5, (double)this.activatingRangeFromPlayer));
                    }
                    if (entity == null) {
                        return;
                    }
                    int j = this.getSpawnerWorld().func_72872_a(entity.getClass(), AxisAlignedBB.func_72330_a((double)this.getSpawnerX(), (double)this.getSpawnerY(), (double)this.getSpawnerZ(), (double)(this.getSpawnerX() + 1), (double)(this.getSpawnerY() + 1), (double)(this.getSpawnerZ() + 1)).func_72314_b((double)(this.spawnRange * 2), 4.0, (double)(this.spawnRange * 2))).size();
                    if (j >= this.maxNearbyEntities) {
                        this.resetTimer();
                        return;
                    }
                    double d2 = (double)this.getSpawnerX() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                    double d3 = this.getSpawnerY();
                    double d4 = (double)this.getSpawnerZ() + (this.getSpawnerWorld().field_73012_v.nextDouble() - this.getSpawnerWorld().field_73012_v.nextDouble()) * (double)this.spawnRange;
                    EntityLiving entityliving = entity instanceof EntityLiving ? (EntityLiving)entity : null;
                    entity.func_70012_b(d2, d3, d4, this.getSpawnerWorld().field_73012_v.nextFloat() * 360.0f, 0.0f);
                    if (entityliving != null && !entityliving.func_70601_bi()) continue;
                    this.func_98265_a(entity);
                    this.getSpawnerWorld().func_72926_e(2004, this.getSpawnerX(), this.getSpawnerY(), this.getSpawnerZ(), 0);
                    if (entityliving != null) {
                        entityliving.func_70656_aK();
                    }
                    flag = true;
                }
                if (flag) {
                    this.resetTimer();
                }
            }
        }
    }

    public Entity func_98265_a(Entity par1Entity) {
        if (this.getRandomEntity() != null) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            par1Entity.func_70039_c(nbttagcompound);
            for (String s : this.getRandomEntity().field_98222_b.func_150296_c()) {
                NBTBase nbtbase = this.getRandomEntity().field_98222_b.func_74781_a(s);
                nbttagcompound.func_74782_a(s, nbtbase.func_74737_b());
            }
            par1Entity.func_70020_e(nbttagcompound);
            if (par1Entity.field_70170_p != null) {
                par1Entity.field_70170_p.func_72838_d(par1Entity);
            }
            Entity entity1 = par1Entity;
            while (nbttagcompound.func_150297_b("Riding", 10)) {
                NBTTagCompound nbttagcompound2 = nbttagcompound.func_74775_l("Riding");
                Entity entity2 = EntityList.func_75620_a((String)nbttagcompound2.func_74779_i("id"), (World)par1Entity.field_70170_p);
                if (entity2 != null) {
                    NBTTagCompound nbttagcompound1 = new NBTTagCompound();
                    entity2.func_70039_c(nbttagcompound1);
                    for (String s1 : nbttagcompound2.func_150296_c()) {
                        NBTBase nbtbase1 = nbttagcompound2.func_74781_a(s1);
                        nbttagcompound1.func_74782_a(s1, nbtbase1.func_74737_b());
                    }
                    entity2.func_70020_e(nbttagcompound1);
                    entity2.func_70012_b(entity1.field_70165_t, entity1.field_70163_u, entity1.field_70161_v, entity1.field_70177_z, entity1.field_70125_A);
                    if (par1Entity.field_70170_p != null) {
                        par1Entity.field_70170_p.func_72838_d(entity2);
                    }
                    entity1.func_70078_a(entity2);
                }
                entity1 = entity2;
                nbttagcompound = nbttagcompound2;
            }
        } else if (par1Entity instanceof EntityLivingBase && par1Entity.field_70170_p != null) {
            ((EntityLiving)par1Entity).func_110161_a((IEntityLivingData)null);
            this.getSpawnerWorld().func_72838_d(par1Entity);
        }
        return par1Entity;
    }

    private void resetTimer() {
        if (this.maxSpawnDelay <= this.minSpawnDelay) {
            this.spawnDelay = this.minSpawnDelay;
        } else {
            int i = this.maxSpawnDelay - this.minSpawnDelay;
            this.spawnDelay = this.minSpawnDelay + this.getSpawnerWorld().field_73012_v.nextInt(i);
        }
        if (this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
            this.setRandomEntity((WeightedRandomMinecart)WeightedRandom.func_76271_a((Random)this.getSpawnerWorld().field_73012_v, (Collection)this.potentialEntitySpawns));
        }
        this.func_98267_a(1);
    }

    public void readFromNBT(NBTTagCompound par1NBTTagCompound) {
        this.entityTypeName = par1NBTTagCompound.func_74779_i("EntityId");
        this.spawnDelay = par1NBTTagCompound.func_74765_d("Delay");
        if (par1NBTTagCompound.func_150297_b("SpawnPotentials", 9)) {
            this.potentialEntitySpawns = new ArrayList();
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("SpawnPotentials", 10);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.potentialEntitySpawns.add(new WeightedRandomMinecart(nbttaglist.func_150305_b(i)));
            }
        } else {
            this.potentialEntitySpawns = null;
        }
        if (par1NBTTagCompound.func_150297_b("SpawnData", 10)) {
            this.setRandomEntity(new WeightedRandomMinecart(par1NBTTagCompound.func_74775_l("SpawnData"), this.entityTypeName));
        } else {
            this.setRandomEntity(null);
        }
        if (par1NBTTagCompound.func_150297_b("MinSpawnDelay", 99)) {
            this.minSpawnDelay = par1NBTTagCompound.func_74765_d("MinSpawnDelay");
            this.maxSpawnDelay = par1NBTTagCompound.func_74765_d("MaxSpawnDelay");
            this.spawnCount = par1NBTTagCompound.func_74765_d("SpawnCount");
        }
        if (par1NBTTagCompound.func_150297_b("MaxNearbyEntities", 99)) {
            this.maxNearbyEntities = par1NBTTagCompound.func_74765_d("MaxNearbyEntities");
            this.activatingRangeFromPlayer = par1NBTTagCompound.func_74765_d("RequiredPlayerRange");
        }
        if (par1NBTTagCompound.func_150297_b("SpawnRange", 99)) {
            this.spawnRange = par1NBTTagCompound.func_74765_d("SpawnRange");
        }
        if (this.getSpawnerWorld() != null && this.getSpawnerWorld().field_72995_K) {
            this.field_98291_j = null;
        }
    }

    public void writeToNBT(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74778_a("EntityId", this.getEntityNameToSpawn());
        par1NBTTagCompound.func_74777_a("Delay", (short)this.spawnDelay);
        par1NBTTagCompound.func_74777_a("MinSpawnDelay", (short)this.minSpawnDelay);
        par1NBTTagCompound.func_74777_a("MaxSpawnDelay", (short)this.maxSpawnDelay);
        par1NBTTagCompound.func_74777_a("SpawnCount", (short)this.spawnCount);
        par1NBTTagCompound.func_74777_a("MaxNearbyEntities", (short)this.maxNearbyEntities);
        par1NBTTagCompound.func_74777_a("RequiredPlayerRange", (short)this.activatingRangeFromPlayer);
        par1NBTTagCompound.func_74777_a("SpawnRange", (short)this.spawnRange);
        if (this.getRandomEntity() != null) {
            par1NBTTagCompound.func_74782_a("SpawnData", this.getRandomEntity().field_98222_b.func_74737_b());
        }
        if (this.getRandomEntity() != null || this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
            NBTTagList nbttaglist = new NBTTagList();
            if (this.potentialEntitySpawns != null && this.potentialEntitySpawns.size() > 0) {
                for (WeightedRandomMinecart weightedrandomminecart : this.potentialEntitySpawns) {
                    nbttaglist.func_74742_a((NBTBase)weightedrandomminecart.func_98220_a());
                }
            } else {
                nbttaglist.func_74742_a((NBTBase)this.getRandomEntity().func_98220_a());
            }
            par1NBTTagCompound.func_74782_a("SpawnPotentials", (NBTBase)nbttaglist);
        }
    }

    public boolean setDelayToMin(int par1) {
        if (par1 == 1 && this.getSpawnerWorld().field_72995_K) {
            this.spawnDelay = this.minSpawnDelay;
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity func_98281_h() {
        if (this.field_98291_j == null) {
            Entity entity = EntityList.func_75620_a((String)this.getEntityNameToSpawn(), (World)null);
            this.field_98291_j = entity = this.func_98265_a(entity);
        }
        return this.field_98291_j;
    }

    public WeightedRandomMinecart getRandomEntity() {
        return this.randomEntity;
    }

    public void setRandomEntity(WeightedRandomMinecart weightedRandomMinecart) {
        this.randomEntity = weightedRandomMinecart;
    }

    public abstract void func_98267_a(int var1);

    public abstract World getSpawnerWorld();

    public abstract int getSpawnerX();

    public abstract int getSpawnerY();

    public abstract int getSpawnerZ();

    public class WeightedRandomMinecart
    extends WeightedRandom.Item {
        public final NBTTagCompound field_98222_b;
        public final String entityTypeName;

        public WeightedRandomMinecart(NBTTagCompound par2NBTTagCompound) {
            super(par2NBTTagCompound.func_74762_e("Weight"));
            NBTTagCompound nbttagcompound1 = par2NBTTagCompound.func_74775_l("Properties");
            String s = par2NBTTagCompound.func_74779_i("Type");
            if (s.equals("Minecart")) {
                if (nbttagcompound1 != null) {
                    switch (nbttagcompound1.func_74762_e("Type")) {
                        case 0: {
                            s = "MinecartRideable";
                            break;
                        }
                        case 1: {
                            s = "MinecartChest";
                            break;
                        }
                        case 2: {
                            s = "MinecartFurnace";
                        }
                    }
                } else {
                    s = "MinecartRideable";
                }
            }
            this.field_98222_b = nbttagcompound1;
            this.entityTypeName = s;
        }

        public WeightedRandomMinecart(NBTTagCompound par2NBTTagCompound, String par3Str) {
            super(1);
            if (par3Str.equals("Minecart")) {
                if (par2NBTTagCompound != null) {
                    switch (par2NBTTagCompound.func_74762_e("Type")) {
                        case 0: {
                            par3Str = "MinecartRideable";
                            break;
                        }
                        case 1: {
                            par3Str = "MinecartChest";
                            break;
                        }
                        case 2: {
                            par3Str = "MinecartFurnace";
                        }
                    }
                } else {
                    par3Str = "MinecartRideable";
                }
            }
            this.field_98222_b = par2NBTTagCompound;
            this.entityTypeName = par3Str;
        }

        public NBTTagCompound func_98220_a() {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Properties", (NBTBase)this.field_98222_b);
            nbttagcompound.func_74778_a("Type", this.entityTypeName);
            nbttagcompound.func_74768_a("Weight", this.field_76292_a);
            return nbttagcompound;
        }
    }
}

