/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie;

import com.github.lunatrius.core.version.VersionChecker;
import com.github.lunatrius.stackie.Ticker;
import com.github.lunatrius.stackie.command.StackieCommand;
import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.event.FMLServerStoppingEvent;
import cpw.mods.fml.common.registry.GameData;
import net.minecraft.command.ICommand;
import net.minecraft.item.Item;
import net.minecraft.util.MathHelper;
import org.apache.logging.log4j.Logger;

@Mod(modid="Stackie", name="Stackie", guiFactory="com.github.lunatrius.stackie.client.gui.GuiFactory")
public class Stackie {
    public static Logger logger = null;
    private Ticker ticker = null;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        VersionChecker.registerMod((ModMetadata)event.getModMetadata());
        logger = event.getModLog();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        this.ticker = new Ticker();
        FMLCommonHandler.instance().bus().register((Object)this.ticker);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        for (String info : ConfigurationHandler.stackSizes) {
            String[] parts = info.split("-");
            if (parts.length != 2) continue;
            try {
                String uniqueName = parts[0];
                int stackSize = MathHelper.func_76125_a((int)Integer.parseInt(parts[1], 10), (int)1, (int)64);
                Item item = (Item)GameData.getItemRegistry().func_82594_a(uniqueName);
                if (item == null) continue;
                item.func_77625_d(stackSize);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("Invalid format?", (Throwable)e);
            }
        }
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        this.ticker.setServer(event.getServer());
        event.registerServerCommand((ICommand)new StackieCommand());
    }

    @Mod.EventHandler
    public void serverStopping(FMLServerStoppingEvent event) {
        this.ticker.setServer(null);
    }
}

