/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie;

import com.github.lunatrius.stackie.handler.ConfigurationHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;

public class Ticker {
    public static final int MAXIMUM_STACKSIZE = 2048;
    public static final int MAXIMUM_EXPERIENCE = 1024;
    private MinecraftServer server = null;
    private int ticks = -1;

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            return;
        }
        if (--this.ticks < 0) {
            if (this.server != null && this.server.field_71305_c != null) {
                this.processWorlds(this.server.field_71305_c);
            }
            this.ticks = ConfigurationHandler.interval;
        }
    }

    public void setServer(MinecraftServer server) {
        this.server = server;
    }

    private void processWorlds(WorldServer[] worldServers) {
        for (WorldServer world : worldServers) {
            ArrayList<Entity> entityList = new ArrayList<Entity>();
            for (int i = 0; i < world.field_72996_f.size(); ++i) {
                if (this.getType((Entity)world.field_72996_f.get(i)) == EntityType.OTHER) continue;
                entityList.add((Entity)world.field_72996_f.get(i));
            }
            this.stackEntities(entityList);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void stackEntities(List<Entity> entityList) {
        EntityType mcType = EntityType.OTHER;
        Entity mcEntity = null;
        EntityItem mcEntityItem = null;
        ItemStack mcItemStack = null;
        EntityXPOrb mcEntityXPOrb = null;
        double mcWeight = -1.0;
        EntityType localType = EntityType.OTHER;
        Entity localEntity = null;
        EntityItem localEntityItem = null;
        ItemStack localItemStack = null;
        EntityXPOrb localEntityXPOrb = null;
        double localWeight = -1.0;
        boolean merged = false;
        double totalWeight = -1.0;
        try {
            block12: for (int i = 0; i < entityList.size() - 1; ++i) {
                mcEntity = entityList.get(i);
                if (mcEntity.field_70128_L) continue;
                mcType = this.getType(mcEntity);
                switch (mcType) {
                    case ITEM: {
                        mcEntityItem = (EntityItem)mcEntity;
                        mcItemStack = mcEntityItem.func_92059_d();
                        if (mcItemStack != null && mcItemStack.func_77985_e() && mcItemStack.field_77994_a > 0) break;
                        continue block12;
                    }
                    case EXPERIENCEORB: {
                        mcEntityXPOrb = (EntityXPOrb)mcEntity;
                    }
                }
                block13: for (int j = i + 1; j < entityList.size(); ++j) {
                    localEntity = entityList.get(j);
                    if (localEntity.field_70128_L || mcType != (localType = this.getType(localEntity)) || !this.isEqualPosition(mcEntity, localEntity)) continue;
                    merged = false;
                    switch (mcType) {
                        case ITEM: {
                            localEntityItem = (EntityItem)localEntity;
                            localItemStack = localEntityItem.func_92059_d();
                            if (localItemStack == null || mcItemStack.func_77973_b() != localItemStack.func_77973_b() || mcItemStack.field_77990_d != null || localItemStack.field_77990_d != null || mcItemStack.func_77960_j() != localItemStack.func_77960_j()) continue block13;
                            mcWeight = mcItemStack.field_77994_a;
                            localWeight = localItemStack.field_77994_a;
                            int itemsIn = Math.min(2048 - mcItemStack.field_77994_a, localItemStack.field_77994_a);
                            mcItemStack.field_77994_a += itemsIn;
                            localItemStack.field_77994_a -= itemsIn;
                            mcEntityItem.func_92058_a(mcItemStack);
                            localEntityItem.func_92058_a(localItemStack);
                            mcEntityItem.field_70292_b = Math.min(mcEntityItem.field_70292_b, localEntityItem.field_70292_b);
                            if (localItemStack.field_77994_a > 0) break;
                            merged = true;
                            break;
                        }
                        case EXPERIENCEORB: {
                            localEntityXPOrb = (EntityXPOrb)localEntity;
                            try {
                                mcWeight = mcEntityXPOrb.func_70526_d();
                                localWeight = localEntityXPOrb.func_70526_d();
                                if (mcWeight + localWeight > 1024.0) continue block13;
                                mcEntityXPOrb.field_70530_e += localEntityXPOrb.field_70530_e;
                                localEntityXPOrb.field_70530_e = 0;
                                mcEntityXPOrb.field_70531_b = Math.min(mcEntityXPOrb.field_70531_b, localEntityXPOrb.field_70531_b);
                                merged = true;
                                break;
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                    }
                    if (!merged) continue;
                    localEntity.func_70106_y();
                    totalWeight = mcWeight + localWeight;
                    mcEntity.func_70107_b(mcEntity.field_70165_t * (mcWeight /= totalWeight) + localEntity.field_70165_t * (localWeight /= totalWeight), mcEntity.field_70163_u * mcWeight + localEntity.field_70163_u * localWeight, mcEntity.field_70161_v * mcWeight + localEntity.field_70161_v * localWeight);
                    mcEntity.field_70159_w = mcEntity.field_70159_w * mcWeight + localEntity.field_70159_w * localWeight;
                    mcEntity.field_70181_x = mcEntity.field_70181_x * mcWeight + localEntity.field_70181_x * localWeight;
                    mcEntity.field_70179_y = mcEntity.field_70179_y * mcWeight + localEntity.field_70179_y * localWeight;
                }
            }
            return;
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private EntityType getType(Entity entity) {
        if (ConfigurationHandler.stackItems && entity instanceof EntityItem) {
            return EntityType.ITEM;
        }
        if (ConfigurationHandler.stackExperience && entity instanceof EntityXPOrb) {
            return EntityType.EXPERIENCEORB;
        }
        return EntityType.OTHER;
    }

    private boolean isEqualPosition(Entity a, Entity b) {
        return this.isEqual(a.field_70165_t, b.field_70165_t) && this.isEqual(a.field_70163_u, b.field_70163_u) && this.isEqual(a.field_70161_v, b.field_70161_v);
    }

    private boolean isEqual(double a, double b) {
        return this.isEqual(a, b, ConfigurationHandler.distance);
    }

    private boolean isEqual(double a, double b, double epsilon) {
        return Math.abs(a - b) < epsilon;
    }

    private static enum EntityType {
        ITEM,
        EXPERIENCEORB,
        OTHER;

    }
}

