/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.stackie.handler;

import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.registry.GameData;
import java.io.File;
import java.util.regex.Pattern;
import net.minecraft.init.Items;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigurationHandler {
    public static final String CATEGORY = "general";
    public static final String INTERVAL = "interval";
    public static final String INTERVAL_DESC = "Amount of ticks (20 ticks => 1 second) that will pass between each stacking attempt.";
    public static final String DISTANCE = "distance";
    public static final String DISTANCE_DESC = "Maximum distance between items/experience orbs that can be still stacked (relative to block size).";
    public static final String STACKITEMS = "stackItems";
    public static final String STACKITEMS_DESC = "Should it stack items?";
    public static final String STACKEXPERIENCE = "stackExperience";
    public static final String STACKEXPERIENCE_DESC = "Should it stack experience orbs?";
    public static final String STACKSIZE_DELIMITER = "-";
    public static final String STACKSIZES = "stackSizes";
    public static final String STACKSIZES_DESC = "A list of uniqueName-stackSize mappings. These values will override the default stack sizes.";
    public static final String LANG_PREFIX = "Stackie".toLowerCase();
    public static final int INTERVAL_MIN = 5;
    public static final int INTERVAL_MAX = 1200;
    public static final double DISTANCE_MIN = 0.01;
    public static final double DISTANCE_MAX = 10.0;
    public static Configuration configuration;
    public static int interval;
    public static double distance;
    public static boolean stackItems;
    public static boolean stackExperience;
    public static String[] stackSizes;
    private static Property propInterval;
    private static Property propDistance;
    private static Property propStackItems;
    private static Property propStackExperience;
    private static Property propStackSizes;

    public static void init(File configFile) {
        if (configuration == null) {
            configuration = new Configuration(configFile);
            ConfigurationHandler.loadConfiguration();
        }
    }

    private static void loadConfiguration() {
        propInterval = configuration.get(CATEGORY, INTERVAL, interval, INTERVAL_DESC, 5, 1200);
        propInterval.setLanguageKey(String.format("%s.%s", LANG_PREFIX, INTERVAL));
        interval = propInterval.getInt(interval);
        propDistance = configuration.get(CATEGORY, DISTANCE, distance, DISTANCE_DESC, 0.01, 10.0);
        propDistance.setLanguageKey(String.format("%s.%s", LANG_PREFIX, DISTANCE));
        distance = propDistance.getDouble(distance);
        propStackItems = configuration.get(CATEGORY, STACKITEMS, stackItems, STACKITEMS_DESC);
        propStackItems.setLanguageKey(String.format("%s.%s", LANG_PREFIX, STACKITEMS));
        stackItems = propStackItems.getBoolean(stackItems);
        propStackExperience = configuration.get(CATEGORY, STACKEXPERIENCE, stackExperience, STACKEXPERIENCE_DESC);
        propStackExperience.setLanguageKey(String.format("%s.%s", LANG_PREFIX, STACKEXPERIENCE));
        stackExperience = propStackExperience.getBoolean(stackExperience);
        propStackSizes = configuration.get(CATEGORY, STACKSIZES, stackSizes, STACKSIZES_DESC);
        propStackSizes.setLanguageKey(String.format("%s.%s", LANG_PREFIX, STACKSIZES));
        propStackSizes.setValidationPattern(Pattern.compile("[A-Za-z0-9_:]+-\\d+"));
        stackSizes = propStackSizes.getStringList();
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setInterval(int num) {
        propInterval.set(num < 5 ? 5 : (num > 1200 ? 1200 : num));
        interval = propInterval.getInt(num);
    }

    public static void setDistance(double num) {
        propDistance.set(num < 0.01 ? 0.01 : (num > 10.0 ? 10.0 : num));
        distance = propDistance.getDouble(num);
    }

    public static void setStackItems(boolean stack) {
        propStackItems.set(stack);
        stackItems = propStackItems.getBoolean(stack);
    }

    public static void setStackExperience(boolean stack) {
        propStackExperience.set(stack);
        stackExperience = propStackExperience.getBoolean(stack);
    }

    public static void save() {
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    @SubscribeEvent
    public void onConfigurationChangedEvent(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equalsIgnoreCase("Stackie")) {
            ConfigurationHandler.loadConfiguration();
        }
    }

    static {
        interval = 20;
        distance = 0.75;
        stackItems = true;
        stackExperience = true;
        stackSizes = new String[]{GameData.getItemRegistry().func_148750_c((Object)Items.field_151135_aq) + STACKSIZE_DELIMITER + 64, GameData.getItemRegistry().func_148750_c((Object)Items.field_151143_au) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151141_av) + STACKSIZE_DELIMITER + 8, GameData.getItemRegistry().func_148750_c((Object)Items.field_151139_aw) + STACKSIZE_DELIMITER + 64, GameData.getItemRegistry().func_148750_c((Object)Items.field_151124_az) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151108_aI) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151109_aJ) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151142_bV) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151140_bW) + STACKSIZE_DELIMITER + 4, GameData.getItemRegistry().func_148750_c((Object)Items.field_151095_cc) + STACKSIZE_DELIMITER + 4};
        propInterval = null;
        propDistance = null;
        propStackItems = null;
        propStackExperience = null;
        propStackSizes = null;
    }
}

