/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dmillerw.remoteio.block.core.BlockIOCore;
import dmillerw.remoteio.core.helper.RotationHelper;
import dmillerw.remoteio.lib.DimensionalCoords;
import dmillerw.remoteio.lib.VisualState;
import dmillerw.remoteio.tile.TileRemoteInterface;
import dmillerw.remoteio.tile.core.TileIOCore;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockRemoteInterface
extends BlockIOCore {
    public static int renderID;

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float fx, float fy, float fz) {
        boolean result = super.func_149727_a(world, x, y, z, player, side, fx, fy, fz);
        if (result) {
            return result;
        }
        if (!world.field_72995_K) {
            TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
            if (tile.remotePosition != null && !player.func_70093_af() && tile.hasUpgradeChip(1)) {
                int adjustedSide = RotationHelper.getRotatedSide(0, tile.rotationY, 0, side);
                DimensionalCoords there = tile.remotePosition;
                Block remote = there.getBlock();
                remote.func_149727_a(there.getWorld(), there.x, there.y, there.z, player, adjustedSide, fx, fy, fz);
                return true;
            }
        }
        return result;
    }

    @Override
    public int getGuiID() {
        return 0;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            Vec3 offsetEnd;
            int offsetZ;
            int offsetY;
            int offsetX;
            Vec3 offsetStart;
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock((IBlockAccess)world);
            MovingObjectPosition mob = remote.func_149731_a(world, there.x, there.y, there.z, offsetStart = Vec3.func_72443_a((double)(start.field_72450_a + (double)(offsetX = there.x - x)), (double)(start.field_72448_b + (double)(offsetY = there.y - y)), (double)(start.field_72449_c + (double)(offsetZ = there.z - z))), offsetEnd = Vec3.func_72443_a((double)(end.field_72450_a + (double)offsetX), (double)(end.field_72448_b + (double)offsetY), (double)(end.field_72449_c + (double)offsetZ)));
            if (mob != null) {
                mob.field_72311_b -= offsetX;
                mob.field_72312_c -= offsetY;
                mob.field_72309_d -= offsetZ;
                mob.field_72307_f.field_72450_a -= (double)offsetX;
                mob.field_72307_f.field_72448_b -= (double)offsetY;
                mob.field_72307_f.field_72449_c -= (double)offsetZ;
            }
            return mob;
        }
        return super.func_149731_a(world, x, y, z, start, end);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock((IBlockAccess)world);
            int offsetX = there.x - x;
            int offsetY = there.y - y;
            int offsetZ = there.z - z;
            EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
            player.field_70169_q += (double)offsetX;
            player.field_70167_r += (double)offsetY;
            player.field_70166_s += (double)offsetZ;
            player.field_70165_t += (double)offsetX;
            player.field_70163_u += (double)offsetY;
            player.field_70161_v += (double)offsetZ;
            AxisAlignedBB aabb = remote.func_149633_g(world, there.x, there.y, there.z);
            player.field_70169_q -= (double)offsetX;
            player.field_70167_r -= (double)offsetY;
            player.field_70166_s -= (double)offsetZ;
            player.field_70165_t -= (double)offsetX;
            player.field_70163_u -= (double)offsetY;
            player.field_70161_v -= (double)offsetZ;
            if (aabb != null) {
                aabb.func_72317_d((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
            }
            return aabb;
        }
        return super.func_149633_g(world, x, y, z);
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        TileRemoteInterface tile = (TileRemoteInterface)world.func_147438_o(x, y, z);
        if (tile != null && tile.visualState == VisualState.CAMOUFLAGE_REMOTE && tile.remotePosition != null) {
            DimensionalCoords there = tile.remotePosition;
            Block remote = there.getBlock((IBlockAccess)world);
            int offsetX = there.x - x;
            int offsetY = there.y - y;
            int offsetZ = there.z - z;
            AxisAlignedBB newAABB = AxisAlignedBB.func_72330_a((double)aabb.field_72340_a, (double)aabb.field_72338_b, (double)aabb.field_72339_c, (double)aabb.field_72336_d, (double)aabb.field_72337_e, (double)aabb.field_72334_f).func_72317_d((double)offsetX, (double)offsetY, (double)offsetZ);
            ArrayList newList = new ArrayList();
            remote.func_149743_a(world, there.x, there.y, there.z, newAABB, newList, entity);
            for (Object o : newList) {
                AxisAlignedBB aabb1 = (AxisAlignedBB)o;
                aabb1.func_72317_d((double)(-offsetX), (double)(-offsetY), (double)(-offsetZ));
                if (!aabb.func_72326_a(aabb1)) continue;
                list.add(aabb1);
            }
            return;
        }
        super.func_149743_a(world, x, y, z, aabb, list, entity);
    }

    public int func_149645_b() {
        return renderID;
    }

    @Override
    public TileIOCore getTileEntity() {
        return new TileRemoteInterface();
    }
}

