/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.core;

import cofh.api.energy.IEnergyHandler;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import ic2.api.tile.IEnergyStorage;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraftforge.fluids.IFluidHandler;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.api.aspects.IAspectSource;
import thaumcraft.api.aspects.IEssentiaTransport;

public class TransferType {
    private static BiMap<Integer, Class[]> typeToInterfaceMap = HashBiMap.create();
    public static final int MATTER_ITEM = 0;
    public static final int MATTER_FLUID = 1;
    public static final int MATTER_ESSENTIA = 2;
    public static final int ENERGY_IC2 = 10;
    public static final int ENERGY_BC = 11;
    public static final int ENERGY_RF = 12;
    public static final int NETWORK_AE = 20;

    public static void registerType(int type, Class ... classes) {
        typeToInterfaceMap.put((Object)type, (Object)classes);
    }

    public static int getTypeForInterface(Class cls) {
        for (Map.Entry entry : typeToInterfaceMap.inverse().entrySet()) {
            for (Class clz : (Class[])entry.getKey()) {
                if (cls != clz) continue;
                return (Integer)entry.getValue();
            }
        }
        return -1;
    }

    static {
        TransferType.registerType(0, IInventory.class, ISidedInventory.class);
        TransferType.registerType(1, IFluidHandler.class);
        TransferType.registerType(2, IAspectContainer.class, IAspectSource.class, IEssentiaTransport.class);
        TransferType.registerType(10, IEnergyTile.class, IEnergySource.class, IEnergySink.class, IEnergyStorage.class);
        TransferType.registerType(12, IEnergyHandler.class);
    }
}

