/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.core.helper.transfer;

import java.util.ArrayList;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;

public class FluidTransferHelper {
    public static int fill(IInventory inventory, FluidStack resource, boolean doFill) {
        int filled = 0;
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            FluidStack copied;
            ItemStack filledStack;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)stack.func_77973_b()).fill(stack, resource, doFill);
            }
            if (!FluidContainerRegistry.isEmptyContainer((ItemStack)stack) || (filledStack = FluidContainerRegistry.fillFluidContainer((FluidStack)(copied = resource.copy()), (ItemStack)stack)) == null) continue;
            resource.amount -= copied.amount;
            filled += copied.amount;
            if (!doFill) continue;
            inventory.func_70299_a(i, filledStack);
        }
        return filled;
    }

    public static FluidStack drain(IInventory inventory, FluidStack resource, boolean doDrain) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            FluidStack fluidStack;
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)stack.func_77973_b()).drain(stack, resource.amount, doDrain);
            }
            if (!FluidContainerRegistry.isFilledContainer((ItemStack)stack) || !(fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack)).isFluidEqual(resource) || fluidStack.amount > resource.amount) continue;
            if (doDrain) {
                if (stack.field_77994_a == 1) {
                    if (stack.func_77973_b().hasContainerItem(stack)) {
                        inventory.func_70299_a(i, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        inventory.func_70299_a(i, null);
                    }
                } else {
                    stack.func_77979_a(1);
                }
            }
            return fluidStack;
        }
        return null;
    }

    public static FluidStack drain(IInventory inventory, int maxDrain, boolean doDrain) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null) continue;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                return ((IFluidContainerItem)stack.func_77973_b()).drain(stack, maxDrain, doDrain);
            }
            if (!FluidContainerRegistry.isFilledContainer((ItemStack)stack)) continue;
            FluidStack fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
            if (fluidStack.amount > maxDrain) continue;
            if (doDrain) {
                if (stack.field_77994_a == 1) {
                    if (stack.func_77973_b().hasContainerItem(stack)) {
                        inventory.func_70299_a(i, stack.func_77973_b().getContainerItem(stack));
                    } else {
                        inventory.func_70299_a(i, null);
                    }
                } else {
                    stack.func_77979_a(1);
                }
            }
            return fluidStack;
        }
        return null;
    }

    public static boolean canFill(IInventory inventory, Fluid fluid) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !FluidContainerRegistry.isEmptyContainer((ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean canDrain(IInventory inventory, Fluid fluid) {
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !FluidContainerRegistry.isFilledContainer((ItemStack)stack)) continue;
            return true;
        }
        return false;
    }

    public static FluidTankInfo[] getTankInfo(IInventory inventory) {
        ArrayList<FluidTankInfo> fluids = new ArrayList<FluidTankInfo>();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack stack = inventory.func_70301_a(i);
            if (stack == null || !FluidContainerRegistry.isContainer((ItemStack)stack)) continue;
            if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                fluids.add(new FluidTankInfo(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack), 1000));
                continue;
            }
            fluids.add(new FluidTankInfo(null, 1000));
        }
        return fluids.toArray(new FluidTankInfo[fluids.size()]);
    }
}

