/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.core.tracker;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import dmillerw.remoteio.lib.DimensionalCoords;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;

public class BlockTracker {
    public static final BlockTracker INSTANCE = new BlockTracker();
    private Set<TrackedBlock> trackedBlockSet = new HashSet<TrackedBlock>();

    public void startTracking(DimensionalCoords coords, ITrackerCallback callback) {
        if (coords == null || callback == null) {
            return;
        }
        this.trackedBlockSet.add(new TrackedBlock(coords, callback));
    }

    public void stopTracking(DimensionalCoords coords) {
        if (coords == null) {
            return;
        }
        for (TrackedBlock trackedBlock : this.trackedBlockSet) {
            if (!trackedBlock.coordinates.equals(coords)) continue;
            trackedBlock.setDead();
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent event) {
        if (event.side == Side.SERVER && event.type == TickEvent.Type.WORLD && event.phase == TickEvent.Phase.END) {
            Iterator<TrackedBlock> iterator = this.trackedBlockSet.iterator();
            while (iterator.hasNext()) {
                TrackedBlock trackedBlock = iterator.next();
                if (trackedBlock.isDead) {
                    iterator.remove();
                    continue;
                }
                if (trackedBlock.coordinates.getBlock() == trackedBlock.lastBlock && trackedBlock.coordinates.getMeta() == trackedBlock.lastMeta) continue;
                trackedBlock.callback();
                trackedBlock.lastBlock = trackedBlock.coordinates.getBlock();
                trackedBlock.lastMeta = trackedBlock.coordinates.getMeta();
            }
        }
    }

    public static interface ITrackerCallback {
        public void callback(IBlockAccess var1, int var2, int var3, int var4);
    }

    public static class TrackedBlock {
        public final DimensionalCoords coordinates;
        public Block lastBlock;
        public int lastMeta;
        public final ITrackerCallback callback;
        public boolean isDead = false;

        public TrackedBlock(DimensionalCoords coordinates, ITrackerCallback callback) {
            this.coordinates = coordinates;
            this.callback = callback;
        }

        public void callback() {
            this.callback.callback((IBlockAccess)this.coordinates.getWorld(), this.coordinates.x, this.coordinates.y, this.coordinates.z);
        }

        public void setDead() {
            this.isDead = true;
        }

        public int hashCode() {
            return this.coordinates.hashCode();
        }
    }
}

