/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.item;

import dmillerw.remoteio.core.TabRemoteIO;
import dmillerw.remoteio.item.HandlerItem;
import dmillerw.remoteio.item.ItemLocationChip;
import dmillerw.remoteio.lib.DimensionalCoords;
import dmillerw.remoteio.lib.ModInfo;
import dmillerw.remoteio.tile.TileRemoteInterface;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;

public class ItemWirelessTransmitter
extends Item {
    private IIcon icon;

    public static boolean hasValidRemote(EntityPlayer player) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (stack == null || stack.func_77973_b() != HandlerItem.wirelessTransmitter || !player.func_70005_c_().equalsIgnoreCase(ItemWirelessTransmitter.getPlayerName(stack))) continue;
            return true;
        }
        return false;
    }

    public static void setHitSide(ItemStack stack, int side) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74768_a("side", side);
        stack.func_77982_d(nbt);
    }

    public static void setHitCoordinates(ItemStack stack, float fx, float fy, float fz) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("x", fx);
        tag.func_74776_a("y", fy);
        tag.func_74776_a("z", fz);
        nbt.func_74782_a("hit", (NBTBase)tag);
        stack.func_77982_d(nbt);
    }

    public static void setPlayer(ItemStack stack, EntityPlayer player) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74778_a("player", player.func_70005_c_());
        stack.func_77982_d(nbt);
    }

    public static int getHitSide(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return -1;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("side")) {
            return -1;
        }
        return nbt.func_74762_e("side");
    }

    public static float[] getHitCoordinates(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("hit")) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        NBTTagCompound hit = nbt.func_74775_l("hit");
        return new float[]{hit.func_74760_g("x"), hit.func_74760_g("y"), hit.func_74760_g("z")};
    }

    public static String getPlayerName(ItemStack stack) {
        if (!stack.func_77942_o()) {
            return null;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (!nbt.func_74764_b("player")) {
            return null;
        }
        return nbt.func_74779_i("player");
    }

    public static EntityPlayer getPlayer(ItemStack stack) {
        String player = ItemWirelessTransmitter.getPlayerName(stack);
        if (player != null && !player.isEmpty()) {
            return MinecraftServer.func_71276_C().func_71203_ab().func_152612_a(player);
        }
        return null;
    }

    public ItemWirelessTransmitter() {
        this.func_77656_e(0);
        this.func_77625_d(1);
        this.func_77637_a(TabRemoteIO.TAB);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean debug) {
        DimensionalCoords coords = ItemLocationChip.getCoordinates(stack);
        EntityPlayer bound = ItemWirelessTransmitter.getPlayer(stack);
        if (coords != null) {
            list.add("Dimension: " + DimensionManager.getProvider((int)coords.dimensionID).func_80007_l());
            list.add("X: " + coords.x + " Y: " + coords.y + " Z: " + coords.z);
            list.add(" --- ");
        }
        if (bound != null) {
            list.add("Bound to: " + bound.getDisplayName());
        }
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileRemoteInterface) {
            ItemLocationChip.setCoordinates(stack, DimensionalCoords.create(tile));
            ItemWirelessTransmitter.setHitSide(stack, side);
            ItemWirelessTransmitter.setHitCoordinates(stack, hitX, hitY, hitZ);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                ItemWirelessTransmitter.setPlayer(stack, player);
                player.func_146105_b((IChatComponent)new ChatComponentTranslation("chat.target.save", new Object[0]));
            } else if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("position")) {
                DimensionalCoords coord = ItemLocationChip.getCoordinates(stack);
                int side = ItemWirelessTransmitter.getHitSide(stack);
                float[] hit = ItemWirelessTransmitter.getHitCoordinates(stack);
                coord.getBlock().func_149727_a(coord.getWorld(), coord.x, coord.y, coord.z, player, side, hit[0], hit[1], hit[2]);
            }
        }
        return stack;
    }

    public IIcon func_77617_a(int damage) {
        return this.icon;
    }

    public void func_94581_a(IIconRegister register) {
        this.icon = register.func_94245_a(ModInfo.RESOURCE_PREFIX + "transmitter");
    }
}

