/*
 * Decompiled with CFR 0.152.
 */
package dmillerw.remoteio.tile;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import dmillerw.remoteio.core.helper.transfer.FluidTransferHelper;
import dmillerw.remoteio.core.helper.transfer.IC2TransferHelper;
import dmillerw.remoteio.inventory.wrapper.InventoryArmor;
import dmillerw.remoteio.inventory.wrapper.InventoryArray;
import dmillerw.remoteio.item.ItemWirelessTransmitter;
import dmillerw.remoteio.lib.VisualState;
import dmillerw.remoteio.tile.core.TileIOCore;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.energy.tile.IEnergyTile;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

@Optional.InterfaceList(value={@Optional.Interface(iface="ic2.api.energy.tile.IEnergyTile", modid="IC2API"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySink", modid="IC2API"), @Optional.Interface(iface="ic2.api.energy.tile.IEnergySource", modid="IC2API")})
public class TileRemoteInventory
extends TileIOCore
implements IInventory,
IFluidHandler,
IEnergySink,
IEnergySource {
    public static final byte ACCESS_INVENTORY = 0;
    public static final byte ACCESS_ARMOR = 1;
    public String target;
    public byte accessType = 0;
    private boolean registeredWithIC2 = false;
    private boolean missingUpgrade = false;

    @Override
    public void callback(IInventory inventory) {
        if (!this.func_145830_o() || this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.registeredWithIC2 = false;
        }
        if (!this.registeredWithIC2 && this.hasTransferChip(10) && this.getPlayer() != null) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.registeredWithIC2 = true;
        }
        this.missingUpgrade = false;
        this.updateVisualState();
        this.updateNeighbors();
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt) {
        if (this.target != null && !this.target.isEmpty()) {
            nbt.func_74778_a("target", this.target);
        }
        nbt.func_74774_a("access", this.accessType);
    }

    @Override
    public void onClientUpdate(NBTTagCompound nbt) {
        super.onClientUpdate(nbt);
        if (nbt.func_74764_b("access")) {
            this.accessType = nbt.func_74771_c("access");
        }
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt) {
        this.target = nbt.func_74764_b("target") ? nbt.func_74779_i("target") : "";
        this.accessType = nbt.func_74771_c("access");
    }

    public void onChunkUnload() {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.registeredWithIC2 = false;
        }
    }

    public void func_145843_s() {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.registeredWithIC2 = false;
        }
    }

    public EntityPlayer getPlayer() {
        if (this.target == null || this.target.isEmpty()) {
            return null;
        }
        ServerConfigurationManager configurationManager = MinecraftServer.func_71276_C().func_71203_ab();
        EntityPlayerMP player = configurationManager.func_152612_a(this.target);
        if (player != null && !ItemWirelessTransmitter.hasValidRemote((EntityPlayer)player)) {
            return null;
        }
        return player;
    }

    public IInventory getPlayerInventory(int transferType) {
        EntityPlayer player = this.getPlayer();
        if (player != null && this.hasTransferChip(transferType)) {
            if (this.accessType == 0) {
                return new InventoryArray(player.field_71071_by.field_70462_a);
            }
            if (this.accessType == 1) {
                return new InventoryArmor(player);
            }
        }
        return null;
    }

    public void sendAccessType() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("access", this.accessType);
        this.sendClientUpdate(nbt);
    }

    public void setPlayer(EntityPlayer player) {
        if (this.registeredWithIC2) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent((IEnergyTile)this));
            this.registeredWithIC2 = false;
        }
        this.target = player.func_70005_c_();
        if (!this.registeredWithIC2 && this.hasTransferChip(10)) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent((IEnergyTile)this));
            this.registeredWithIC2 = true;
        }
        this.updateVisualState();
        this.updateNeighbors();
        this.markForUpdate();
    }

    @Override
    public VisualState calculateVisualState() {
        if (this.target == null || this.target.isEmpty()) {
            return VisualState.INACTIVE;
        }
        EntityPlayer player = this.getPlayer();
        if (player == null) {
            return VisualState.INACTIVE_BLINK;
        }
        boolean simple = this.hasUpgradeChip(2);
        if (simple) {
            return VisualState.CAMOUFLAGE_SIMPLE;
        }
        return this.missingUpgrade ? VisualState.ACTIVE_BLINK : VisualState.ACTIVE;
    }

    public int func_70302_i_() {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70302_i_() : 0;
    }

    public ItemStack func_70301_a(int slot) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70301_a(slot) : null;
    }

    public ItemStack func_70298_a(int slot, int amount) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70298_a(slot, amount) : null;
    }

    public ItemStack func_70304_b(int slot) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70304_b(slot) : null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        if (inventoryPlayer != null) {
            inventoryPlayer.func_70299_a(slot, stack);
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_70297_j_() : 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        IInventory inventoryPlayer = this.getPlayerInventory(0);
        return inventoryPlayer != null ? inventoryPlayer.func_94041_b(slot, stack) : false;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.fill(IInventory2, resource, doFill) : 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.drain(IInventory2, resource, doDrain) : null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.drain(IInventory2, maxDrain, doDrain) : null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.canFill(IInventory2, fluid) : false;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.canDrain(IInventory2, fluid) : false;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        IInventory IInventory2 = this.getPlayerInventory(1);
        return IInventory2 != null ? FluidTransferHelper.getTankInfo(IInventory2) : new FluidTankInfo[]{};
    }

    @Optional.Method(modid="IC2API")
    public double demandedEnergyUnits() {
        IInventory IInventory2 = this.getPlayerInventory(10);
        return IInventory2 != null ? (IC2TransferHelper.requiresCharge(IInventory2) ? 32.0 : 0.0) : 0.0;
    }

    @Optional.Method(modid="IC2API")
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        IInventory IInventory2 = this.getPlayerInventory(10);
        return IInventory2 != null ? (double)IC2TransferHelper.fill(IInventory2, (int)Math.floor(amount)) : 0.0;
    }

    @Optional.Method(modid="IC2API")
    public int getMaxSafeInput() {
        return Integer.MAX_VALUE;
    }

    @Optional.Method(modid="IC2API")
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return this.getPlayerInventory(10) != null;
    }

    @Optional.Method(modid="IC2API")
    public double getOfferedEnergy() {
        IInventory inventory = this.getPlayerInventory(10);
        return inventory != null ? (double)IC2TransferHelper.getCharge(inventory) : 0.0;
    }

    @Optional.Method(modid="IC2API")
    public void drawEnergy(double amount) {
        IInventory inventory = this.getPlayerInventory(10);
        if (inventory != null) {
            IC2TransferHelper.drain(inventory, (int)amount);
        }
    }

    @Optional.Method(modid="IC2API")
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }
}

