/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import mods.helpfulvillagers.entity.AbstractVillager;
import mods.helpfulvillagers.entity.EntityArcher;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;

public class EntityAIFollowLeader
extends EntityAIBase {
    AbstractVillager villager;
    EntityLivingBase leader;
    EntityLivingBase threatTarget;
    int count;
    float speed;
    private int previousTime;
    private int currentTime;

    public EntityAIFollowLeader(AbstractVillager abstractEntity) {
        this.villager = abstractEntity;
        this.speed = 0.8f;
        this.func_75248_a(1);
    }

    public boolean func_75250_a() {
        this.leader = this.villager.getLeader();
        return this.leader != null;
    }

    public void func_75249_e() {
        this.count = 0;
    }

    public void func_75246_d() {
        if (AIHelper.findDistance((int)this.villager.field_70165_t, (int)this.leader.field_70165_t) <= 1 && AIHelper.findDistance((int)this.villager.field_70163_u, (int)this.leader.field_70163_u) <= 1 && AIHelper.findDistance((int)this.villager.field_70161_v, (int)this.leader.field_70161_v) <= 1) {
            this.villager.func_70661_as().func_75499_g();
        } else if (--this.count <= 0) {
            this.count = 10;
            this.villager.func_70661_as().func_75497_a((Entity)this.leader, (double)this.speed);
        }
        if (this.villager.profession == 9 || this.villager.profession == 10 && this.villager.inventory.containsItem(new ItemStack(Items.field_151032_g)) < 0) {
            this.protectLeaderMelee();
        } else if (this.villager.profession == 10) {
            this.protectLeaderRanged();
        }
    }

    public boolean func_75253_b() {
        this.leader = this.villager.getLeader();
        return this.leader != null && (this.leader == null || this.leader.func_70089_S());
    }

    public void func_75251_c() {
        this.villager.func_70661_as().func_75492_a(this.villager.field_70165_t, this.villager.field_70163_u, this.villager.field_70161_v, (double)0.3f);
        this.villager.setLeader(null);
        this.villager.currentActivity = EnumActivity.IDLE;
    }

    private void protectLeaderMelee() {
        this.threatTarget = this.villager.func_70643_av() != null && this.villager.func_70643_av().func_70089_S() && this.villager.func_70643_av() instanceof EntityMob ? this.villager.func_70643_av() : (this.leader.func_70643_av() != null && this.leader.func_70643_av().func_70089_S() && this.leader.func_70643_av() instanceof EntityMob ? this.leader.func_70643_av() : null);
        if (this.threatTarget != null) {
            boolean canMove = this.villager.func_70661_as().func_75497_a((Entity)this.threatTarget, (double)this.speed);
            if (!canMove) {
                this.villager.func_70661_as().func_75497_a((Entity)this.leader, (double)this.speed);
            }
            if (this.villager.func_70068_e((Entity)this.threatTarget) <= 5.0) {
                this.villager.func_70661_as().func_75499_g();
                this.villager.func_71038_i();
                boolean attackSuccess = this.threatTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.villager), (float)this.villager.getAttackDamage());
                if (attackSuccess) {
                    this.villager.damageItem();
                }
            }
        }
    }

    private void protectLeaderRanged() {
        this.threatTarget = this.villager.func_70643_av() != null && this.villager.func_70643_av().func_70089_S() && this.villager.func_70643_av() instanceof EntityMob ? this.villager.func_70643_av() : (this.leader.func_70643_av() != null && this.leader.func_70643_av().func_70089_S() && this.leader.func_70643_av() instanceof EntityMob ? this.leader.func_70643_av() : null);
        EntityArcher archer = (EntityArcher)this.villager;
        if (this.threatTarget != null) {
            boolean canMove = this.villager.func_70661_as().func_75497_a((Entity)this.threatTarget, (double)this.speed);
            if (!canMove) {
                this.villager.func_70661_as().func_75497_a((Entity)this.leader, (double)this.speed);
            }
            if (archer.func_70685_l((Entity)this.threatTarget)) {
                archer.func_70661_as().func_75499_g();
                archer.func_70671_ap().func_75651_a((Entity)this.threatTarget, 30.0f, 30.0f);
                if (this.previousTime < 0) {
                    this.previousTime = archer.field_70173_aa;
                } else if (this.currentTime - this.previousTime >= archer.ARROW_TIME) {
                    if (!archer.field_70170_p.field_72995_K) {
                        EntityArrow arrow = new EntityArrow(archer.field_70170_p, (EntityLivingBase)archer, this.threatTarget, 1.6f, 2.0f);
                        arrow.field_70251_a = 1;
                        archer.field_70170_p.func_72838_d((Entity)arrow);
                    }
                    archer.field_70170_p.func_72956_a((Entity)archer, "random.bow", 1.0f, 1.0f / (archer.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    archer.damageItem();
                    archer.inventory.decrementSlot(archer.inventory.containsItem(new ItemStack(Items.field_151032_g)));
                    this.previousTime = -1;
                } else {
                    this.currentTime = archer.field_70173_aa;
                }
            }
        }
    }
}

