/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.ai;

import java.util.ArrayList;
import mods.helpfulvillagers.entity.EntityArcher;
import mods.helpfulvillagers.enums.EnumActivity;
import mods.helpfulvillagers.util.AIHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAITarget;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.ChunkCoordinates;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Vec3;

public class EntityAIGuardVillageArcher
extends EntityAITarget {
    EntityArcher archer;
    EntityLivingBase villageAgressorTarget;
    private float speed;
    private int previousTime;
    private int currentTime;

    public EntityAIGuardVillageArcher(EntityArcher archer) {
        super((EntityCreature)archer, false, false);
        this.archer = archer;
        this.speed = 0.75f;
        this.previousTime = -1;
        this.currentTime = 0;
        this.func_75248_a(2);
    }

    public boolean func_75250_a() {
        if (this.archer.currentActivity == EnumActivity.RETURN || this.archer.currentActivity == EnumActivity.FOLLOW) {
            return false;
        }
        if (this.archer.func_110143_aJ() < this.archer.func_110143_aJ() / 2.0f) {
            this.archer.currentActivity = EnumActivity.STORE;
            return true;
        }
        if (this.archer.func_70643_av() != null && this.archer.func_70643_av().func_70089_S() && this.archer.func_70643_av() instanceof EntityMob) {
            this.villageAgressorTarget = this.archer.func_70643_av();
            return true;
        }
        if (!this.archer.field_70170_p.field_72995_K && this.archer.homeVillage != null) {
            this.villageAgressorTarget = this.archer.homeVillage.findNearestVillageAggressor((EntityLivingBase)this.archer);
            if (this.villageAgressorTarget != null) {
                return true;
            }
        }
        if (!this.archer.hasTool || this.archer.inventory.containsItem(new ItemStack(Items.field_151032_g)) < 0) {
            this.archer.currentActivity = EnumActivity.STORE;
            return true;
        }
        return false;
    }

    public void func_75249_e() {
        this.archer.func_70624_b(this.villageAgressorTarget);
        super.func_75249_e();
    }

    public boolean func_75253_b() {
        if (this.archer.currentActivity == EnumActivity.RETURN || this.archer.currentActivity == EnumActivity.FOLLOW) {
            return false;
        }
        if (this.archer.currentActivity == EnumActivity.STORE) {
            return this.archer.func_110143_aJ() < this.archer.func_110143_aJ() / 2.0f || !this.archer.hasTool;
        }
        return this.villageAgressorTarget != null && this.villageAgressorTarget.func_70089_S();
    }

    public void func_75246_d() {
        if (this.archer.currentActivity == EnumActivity.STORE) {
            this.resupply();
        } else {
            this.attack();
        }
    }

    private void resupply() {
        if (this.archer.homeGuildHall == null) {
            this.archer.currentActivity = EnumActivity.IDLE;
            return;
        }
        if (!this.archer.insideHall()) {
            this.archer.currentActivity = EnumActivity.RETURN;
            return;
        }
        this.villageAgressorTarget = this.archer.homeVillage.findNearestVillageAggressor((EntityLivingBase)this.archer);
        if (this.archer.func_110143_aJ() >= this.archer.func_110143_aJ() / 2.0f && this.villageAgressorTarget != null) {
            this.archer.currentActivity = EnumActivity.IDLE;
        }
        int arrowIndex = this.archer.inventory.containsItem(new ItemStack(Items.field_151032_g));
        this.archer.homeGuildHall.checkChests();
        TileEntityChest chest2 = this.archer.homeGuildHall.getAvailableChest();
        if (!this.archer.inventory.isEmpty() || !this.archer.hasTool || arrowIndex < 0) {
            if (chest2 != null) {
                this.archer.func_70661_as().func_75492_a((double)chest2.field_145851_c, (double)chest2.field_145848_d, (double)chest2.field_145849_e, (double)this.speed);
            }
            if (chest2 != null && AIHelper.findDistance((int)this.archer.field_70165_t, chest2.field_145851_c) <= 2 && AIHelper.findDistance((int)this.archer.field_70163_u, chest2.field_145848_d) <= 2 && AIHelper.findDistance((int)this.archer.field_70161_v, chest2.field_145849_e) <= 2) {
                ArrayList<ItemStack> arrows = new ArrayList<ItemStack>();
                for (int i = 0; i < this.archer.inventory.func_70302_i_(); ++i) {
                    if (this.archer.inventory.func_70301_a(i) == null || !this.archer.inventory.func_70301_a(i).equals(new ItemStack(Items.field_151032_g))) continue;
                    arrows.add(this.archer.inventory.func_70301_a(i));
                    this.archer.inventory.setMainContents(i, null);
                }
                try {
                    this.archer.inventory.dumpInventory(chest2);
                }
                catch (NullPointerException e) {
                    chest2.func_70305_f();
                }
                for (int i = 0; i < arrows.size(); ++i) {
                    this.archer.inventory.addItem((ItemStack)arrows.get(i));
                }
                arrows.clear();
                if (!this.archer.hasTool) {
                    block4: for (TileEntityChest chest2 : this.archer.homeGuildHall.guildChests) {
                        for (ItemStack i : this.archer.getValidTools()) {
                            if (AIHelper.chestContains(chest2, i) < 0) continue;
                            int index = AIHelper.chestContains(chest2, i);
                            this.archer.inventory.swapEquipment(chest2, index, 0);
                            this.archer.currentActivity = EnumActivity.IDLE;
                            continue block4;
                        }
                    }
                }
                if (arrowIndex < 0) {
                    for (TileEntityChest chest2 : this.archer.homeGuildHall.guildChests) {
                        if (AIHelper.chestContains(chest2, new ItemStack(Items.field_151032_g)) < 0) continue;
                        int index = AIHelper.chestContains(chest2, new ItemStack(Items.field_151032_g));
                        this.archer.inventory.swapEquipment(chest2, index, 0);
                        this.archer.inventory.addItem(chest2.func_70301_a(index));
                        chest2.func_70299_a(index, null);
                        this.archer.currentActivity = EnumActivity.IDLE;
                        break;
                    }
                }
            }
        }
    }

    private void attack() {
        boolean canMove;
        if (this.archer.func_70643_av() != null && this.archer.func_70643_av().func_70089_S() && this.archer.func_70643_av() instanceof EntityMob && this.villageAgressorTarget != this.archer.func_70643_av()) {
            this.villageAgressorTarget = this.archer.func_70643_av();
        }
        if (!(canMove = this.archer.func_70661_as().func_75497_a((Entity)this.villageAgressorTarget, (double)this.speed))) {
            ChunkCoordinates target = new ChunkCoordinates((int)this.villageAgressorTarget.field_70165_t, (int)this.villageAgressorTarget.field_70163_u, (int)this.villageAgressorTarget.field_70161_v);
            Vec3 vector = Vec3.func_72443_a((double)target.field_71574_a, (double)target.field_71572_b, (double)target.field_71573_c);
            Vec3 tempVec = RandomPositionGenerator.func_75464_a((EntityCreature)this.archer, (int)10, (int)3, (Vec3)vector);
            this.archer.func_110171_b((int)this.archer.field_70165_t, (int)this.archer.field_70163_u, (int)this.archer.field_70161_v, 20);
            if (tempVec != null) {
                this.archer.func_70661_as().func_75492_a(tempVec.field_72450_a, tempVec.field_72448_b, tempVec.field_72449_c, (double)this.speed);
            }
        }
        if (this.archer.inventory.containsItem(new ItemStack(Items.field_151032_g)) >= 0) {
            if (this.archer.func_70685_l((Entity)this.villageAgressorTarget)) {
                this.archer.func_70661_as().func_75499_g();
                this.archer.func_70671_ap().func_75651_a((Entity)this.villageAgressorTarget, 30.0f, 30.0f);
                if (this.previousTime < 0) {
                    this.previousTime = this.archer.field_70173_aa;
                } else if (this.currentTime - this.previousTime >= this.archer.ARROW_TIME) {
                    if (!this.archer.field_70170_p.field_72995_K) {
                        EntityArrow arrow = new EntityArrow(this.archer.field_70170_p, (EntityLivingBase)this.archer, this.villageAgressorTarget, 1.6f, 2.0f);
                        arrow.field_70251_a = 1;
                        this.archer.field_70170_p.func_72838_d((Entity)arrow);
                    }
                    this.archer.field_70170_p.func_72956_a((Entity)this.archer, "random.bow", 1.0f, 1.0f / (this.archer.func_70681_au().nextFloat() * 0.4f + 0.8f));
                    this.archer.damageItem();
                    this.archer.inventory.decrementSlot(this.archer.inventory.containsItem(new ItemStack(Items.field_151032_g)));
                    this.previousTime = -1;
                } else {
                    this.currentTime = this.archer.field_70173_aa;
                }
            }
        } else if (this.archer.func_70068_e((Entity)this.villageAgressorTarget) <= 5.0) {
            this.archer.func_70661_as().func_75499_g();
            this.archer.func_71038_i();
            boolean attackSuccess = this.villageAgressorTarget.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this.archer), (float)this.archer.getAttackDamage());
            if (attackSuccess) {
                this.archer.damageItem();
            }
        }
    }
}

