/*
 * Decompiled with CFR 0.152.
 */
package mods.helpfulvillagers.network;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import mods.helpfulvillagers.entity.AbstractVillager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.item.ItemStack;

public class InventoryPacket
implements IMessage {
    private int id;
    private ItemStack[] main = new ItemStack[27];
    private ItemStack[] equipment = new ItemStack[5];

    public InventoryPacket() {
    }

    public InventoryPacket(int id, ItemStack[] main, ItemStack[] equipment) {
        this.id = id;
        System.arraycopy(main, 0, this.main, 0, main.length);
        System.arraycopy(equipment, 0, this.equipment, 0, equipment.length);
    }

    public void toBytes(ByteBuf buffer) {
        int i;
        buffer.writeInt(this.id);
        for (i = 0; i < this.main.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.main[i]);
        }
        for (i = 0; i < this.equipment.length; ++i) {
            ByteBufUtils.writeItemStack((ByteBuf)buffer, (ItemStack)this.equipment[i]);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        int i;
        this.id = buffer.readInt();
        for (i = 0; i < this.main.length; ++i) {
            this.main[i] = ByteBufUtils.readItemStack((ByteBuf)buffer);
        }
        for (i = 0; i < this.equipment.length; ++i) {
            this.equipment[i] = ByteBufUtils.readItemStack((ByteBuf)buffer);
        }
    }

    public static class Handler
    implements IMessageHandler<InventoryPacket, IMessage> {
        public IMessage onMessage(InventoryPacket message, MessageContext ctx) {
            try {
                if (ctx.side == Side.CLIENT) {
                    int i;
                    Minecraft mc = Minecraft.func_71410_x();
                    WorldClient world = mc.field_71441_e;
                    AbstractVillager entity = (AbstractVillager)world.func_73045_a(message.id);
                    for (i = 0; i < message.main.length; ++i) {
                        entity.inventory.setMainContents(i, message.main[i]);
                    }
                    for (i = 0; i < message.equipment.length; ++i) {
                        entity.inventory.setEquipmentContents(i, message.equipment[i]);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            return null;
        }
    }
}

