/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.interfaces;

import com.pvp.BetterPvP;
import com.pvp.interfaces.DynamicTexture;
import com.pvp.interfaces.Interface;
import com.pvp.interfaces.MinimapChunk;
import java.awt.Color;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;

public class Minimap {
    public Interface screen;
    public static final int frame = 9;
    public Minecraft mc = Minecraft.func_71410_x();
    private boolean caving = false;
    public static final Color radarMobs = new Color(255, 237, 36);
    public static final Color radarPlayers = new Color(255, 255, 255);
    public static final Color radarItems = new Color(255, 0, 0);
    public static final Color radarOther = new Color(174, 0, 255);
    public static final ResourceLocation mapTextures = new ResourceLocation("xaeromaptexture");
    public static DynamicTexture mapTexture = new DynamicTexture(mapTextures);
    public static HashMap<Integer, HashMap<Integer, MinimapChunk>> mapBlocks0 = new HashMap();
    public static HashMap<Integer, HashMap<Integer, MinimapChunk>> mapBlocks1 = new HashMap();
    public static int blocksLoaded = 0;
    public MapLoader loader = new MapLoader();
    public HashMap<Integer, HashMap<Integer, MinimapChunk>> currentBlocks = mapBlocks1;
    public HashMap<Integer, HashMap<Integer, MinimapChunk>> loadingBlocks = mapBlocks0;
    private byte[] bytes = new byte[786432];
    private byte drawYState = 0;

    public Minimap(Interface i) {
        this.screen = i;
        new Thread(this.loader).start();
    }

    public int loadBlockColor(int par1, int par2) {
        MinimapChunk chunk;
        boolean isglowing;
        int k = (int)this.mc.field_71439_g.field_70163_u;
        Block toReturn = null;
        boolean underwater = false;
        boolean underair = false;
        int lowPoint = this.caving ? k - 30 : 0;
        int highPoint = k + (this.caving ? 1 : 30);
        if (lowPoint < 0) {
            lowPoint = 0;
        }
        for (int i = highPoint; i >= lowPoint; --i) {
            Block got = this.mc.field_71439_g.field_70170_p.func_147439_a(par1, i, par2);
            if (!(got instanceof BlockAir) && underair) {
                if (got == Blocks.field_150355_j || got == Blocks.field_150358_i) {
                    underwater = true;
                    continue;
                }
                k = i;
                toReturn = got;
                break;
            }
            if (!(got instanceof BlockAir)) continue;
            underair = true;
        }
        double brightness = (double)(k * 3) / 256.0;
        int color = 1;
        if (toReturn != null) {
            color = toReturn.func_149688_o().func_151565_r().field_76291_p;
        }
        int l = color >> 16 & 0xFF;
        int i1 = color >> 8 & 0xFF;
        int j1 = color & 0xFF;
        if (underwater) {
            l = (l + 0) / 2;
            i1 = (i1 + 100) / 2;
            j1 = (j1 + 255) / 2;
        }
        if ((l = (int)((double)l * ((isglowing = toReturn == Blocks.field_150353_l || toReturn == Blocks.field_150356_k || toReturn == Blocks.field_150426_aN) ? 1.0 : brightness))) > 255) {
            l = 255;
        }
        if ((i1 = (int)((double)i1 * (isglowing ? 1.0 : brightness))) > 255) {
            i1 = 255;
        }
        if ((j1 = (int)((double)j1 * (isglowing ? 1.0 : brightness))) > 255) {
            j1 = 255;
        }
        color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        int chunkX = par1 >> 4;
        int chunkZ = par2 >> 4;
        HashMap<Integer, MinimapChunk> chunkmap = this.loadingBlocks.get(chunkX);
        if (chunkmap == null) {
            chunkmap = new HashMap();
            this.loadingBlocks.put(chunkX, chunkmap);
        }
        if ((chunk = chunkmap.get(chunkZ)) == null) {
            chunk = new MinimapChunk();
            chunkmap.put(chunkZ, chunk);
        }
        chunk.colors[par1 & 0xF][par2 & 0xF] = color;
        return color;
    }

    public int getBlockColor(int par1, int par2) {
        try {
            return this.loadingBlocks.get((Object)Integer.valueOf((int)(par1 >> 4))).get((Object)Integer.valueOf((int)(par2 >> 4))).colors[par1 & 0xF][par2 & 0xF];
        }
        catch (Exception e) {
            return 1;
        }
    }

    public int getLoadedBlockColor(int par1, int par2) {
        try {
            return this.currentBlocks.get((Object)Integer.valueOf((int)(par1 >> 4))).get((Object)Integer.valueOf((int)(par2 >> 4))).colors[par1 & 0xF][par2 & 0xF];
        }
        catch (Exception e) {
            return 1;
        }
    }

    public double getAngle() {
        double angle;
        double rotation = this.mc.field_71439_g.field_70177_z;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0) {
            angle += 360.0;
        }
        angle /= 180.0;
        return angle *= Math.PI;
    }

    public double getZoom() {
        return 1 + BetterPvP.settings.zoom;
    }

    public void updateMapFrame() {
        double offy;
        double offx;
        int mapW = (this.screen.w - 18) * 2;
        int mapH = (this.screen.h - 18) * 2;
        long before = System.currentTimeMillis();
        double angle = this.getAngle();
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        int currentState = this.drawYState;
        EntityClientPlayerMP p = this.mc.field_71439_g;
        int halfW = mapW / 2;
        int halfH = mapH / 2;
        for (int currentX = 0; currentX < mapW; ++currentX) {
            for (int currentY = currentState; currentY < mapH; currentY += 2) {
                double Y;
                int blockZ;
                offx = (double)(currentX - halfW) / this.getZoom();
                double X = ps * offx + pc * (offy = (double)(currentY - halfH) / this.getZoom());
                int blockX = (int)(this.mc.field_71439_g.field_70165_t + X);
                int j = this.getLoadedBlockColor(blockX, blockZ = (int)(this.mc.field_71439_g.field_70161_v + (Y = ps * offy - pc * offx)));
                if (j == 0) continue;
                this.putColor(this.bytes, currentX + 8, currentY + 8, j);
            }
            currentState = (byte)(currentState != 1 ? 1 : 0);
        }
        this.drawYState = (byte)(this.drawYState != 1 ? 1 : 0);
        for (int i = 0; i < p.field_70170_p.field_72996_f.size(); ++i) {
            try {
                double brightness;
                Entity e = (Entity)p.field_70170_p.field_72996_f.get(i);
                if ((!(e instanceof EntityPlayer) ? (!(e instanceof EntityLiving) ? (!(e instanceof EntityItem) ? !BetterPvP.settings.showOther : !BetterPvP.settings.showItems) : !BetterPvP.settings.showMobs) : e != p && (!BetterPvP.settings.showPlayers || !BetterPvP.settings.showPlayersLocked)) || e.func_70093_af()) continue;
                offx = e.field_70165_t - p.field_70165_t;
                offy = e.field_70161_v - p.field_70161_v;
                double offh = p.field_70163_u - e.field_70163_u;
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 31250.0 / (this.getZoom() * this.getZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > 400.0) continue;
                double Y = pc * offx + ps * offy;
                double X = ps * offx - pc * offy;
                int drawX = mapW / 2 + (int)(X * this.getZoom());
                int drawY = mapH / 2 + (int)(Y * this.getZoom());
                if (drawX + 3 > mapW || drawY + 3 > mapH || drawX - 2 < 0 || drawY - 2 < 0) continue;
                int color = radarOther.hashCode();
                if (e instanceof EntityPlayer) {
                    color = radarPlayers.hashCode();
                } else if (e instanceof EntityLiving) {
                    color = radarMobs.hashCode();
                } else if (e instanceof EntityItem) {
                    color = radarItems.hashCode();
                }
                int l = color >> 16 & 0xFF;
                int i1 = color >> 8 & 0xFF;
                int j1 = color & 0xFF;
                double level = 20.0 - offh;
                if (level < 0.0) {
                    level = 0.0;
                }
                if ((l = (int)((double)l * (brightness = level / 20.0))) > 255) {
                    l = 255;
                }
                if ((i1 = (int)((double)i1 * brightness)) > 255) {
                    i1 = 255;
                }
                if ((j1 = (int)((double)j1 * brightness)) > 255) {
                    j1 = 255;
                }
                color = 0xFF000000 | l << 16 | i1 << 8 | j1;
                for (int a = drawX - 2; a < drawX + 4; ++a) {
                    for (int b = drawY - 2; b < drawY + 4; ++b) {
                        if ((a == drawX - 2 || a == drawX + 3) && (b == drawY - 2 || b == drawY + 3) || a == drawX + 2 && b == drawY - 2 || a == drawX + 3 && b == drawY - 1 || a == drawX - 2 && b == drawY + 2 || a == drawX - 1 && b == drawY + 3) continue;
                        if (a == drawX + 3 || b == drawY + 3 || a == drawX + 2 && b == drawY + 2) {
                            this.putColor(this.bytes, 8 + a, 8 + b, 0);
                            continue;
                        }
                        this.putColor(this.bytes, 8 + a, 8 + b, color);
                    }
                }
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        Minimap.mapTexture.buffer.put(this.bytes);
        Minimap.mapTexture.buffer.flip();
    }

    private boolean isCaving() {
        int x = (int)this.mc.field_71439_g.field_70165_t;
        int y = (int)this.mc.field_71439_g.field_70163_u;
        int z = (int)this.mc.field_71439_g.field_70161_v;
        for (int i = y; i < y + 30; ++i) {
            Block got = this.mc.field_71439_g.field_70170_p.func_147439_a(x, i, z);
            if (!got.func_149688_o().func_76218_k()) continue;
            return true;
        }
        return false;
    }

    private void putColor(byte[] bytes, int x, int y, int color) {
        int pixel = (y * 512 + x) * 3;
        bytes[pixel] = (byte)(color >> 16 & 0xFF);
        bytes[pixel + 1] = (byte)(color >> 8 & 0xFF);
        bytes[pixel + 2] = (byte)(color & 0xFF);
    }

    public class MapLoader
    implements Runnable {
        @Override
        public void run() {
            int updateState = 0;
            int x = 0;
            int z = 0;
            while (true) {
                long before = System.currentTimeMillis();
                try {
                    if (BetterPvP.settings != null && BetterPvP.settings.minimap && Minimap.this.mc.field_71439_g != null) {
                        if (updateState == 0) {
                            Minimap.this.caving = Minimap.this.isCaving();
                            x = (int)Minimap.this.mc.field_71439_g.field_70165_t;
                            z = (int)Minimap.this.mc.field_71439_g.field_70161_v;
                        }
                        this.updateBlocks(updateState, x, z);
                        updateState = (updateState + 1) % 4;
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
                int passed = (int)(System.currentTimeMillis() - before);
                try {
                    if (passed <= 300) {
                        Thread.sleep(300 - passed);
                        continue;
                    }
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }

        public void updateBlocks(int state, int x, int z) {
            int shortR = (int)(125.0 / Minimap.this.getZoom());
            int radius = (int)Math.sqrt(2 * shortR * shortR) + 15;
            int x1 = x - radius + radius * ((state & 1) != 0 ? 1 : 0);
            int y1 = z - radius + radius * (state > 1 ? 1 : 0);
            for (int blockX = x1; blockX < x1 + radius; ++blockX) {
                for (int blockY = y1; blockY < y1 + radius; ++blockY) {
                    Minimap.this.loadBlockColor(blockX, blockY);
                }
            }
            if (state == 3) {
                HashMap<Integer, HashMap<Integer, MinimapChunk>> bu = Minimap.this.currentBlocks;
                Minimap.this.currentBlocks = Minimap.this.loadingBlocks;
                Minimap.this.loadingBlocks = bu;
                Minimap.this.loadingBlocks.clear();
            }
        }
    }
}

