/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.common.blocks.BlockCrystallizer;
import com.shinoow.abyssalcraft.common.items.ItemCrystal;
import com.shinoow.abyssalcraft.core.util.CoreRegistry;
import com.shinoow.abyssalcraft.core.util.recipes.CrystallizerRecipes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityCrystallizer
extends TileEntity
implements ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] crystallizerItemStacks = new ItemStack[4];
    public int crystallizerShapeTime;
    public int currentItemShapingTime;
    public int crystallizerFormTime;
    private String containerName;

    public int func_70302_i_() {
        return this.crystallizerItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.crystallizerItemStacks[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.crystallizerItemStacks[par1] != null) {
            if (this.crystallizerItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.crystallizerItemStacks[par1];
                this.crystallizerItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.crystallizerItemStacks[par1].func_77979_a(par2);
            if (this.crystallizerItemStacks[par1].field_77994_a == 0) {
                this.crystallizerItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.crystallizerItemStacks[par1] != null) {
            ItemStack itemstack = this.crystallizerItemStacks[par1];
            this.crystallizerItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.crystallizerItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.containerName : "container.abyssalcraft.crystallizer";
    }

    public boolean func_145818_k_() {
        return this.containerName != null && this.containerName.length() > 0;
    }

    public void func_145951_a(String par1) {
        this.containerName = par1;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        NBTTagList nbttaglist = par1.func_150295_c("Items", 10);
        this.crystallizerItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.crystallizerItemStacks.length) continue;
            this.crystallizerItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.crystallizerShapeTime = par1.func_74765_d("ShapeTime");
        this.crystallizerFormTime = par1.func_74765_d("FormTime");
        this.currentItemShapingTime = TileEntityCrystallizer.getCrystallizationTime(this.crystallizerItemStacks[1]);
        if (par1.func_150297_b("CustomName", 8)) {
            this.containerName = par1.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74777_a("ShapeTime", (short)this.crystallizerShapeTime);
        par1.func_74777_a("FormTime", (short)this.crystallizerFormTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.crystallizerItemStacks.length; ++i) {
            if (this.crystallizerItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.crystallizerItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            par1.func_74778_a("CustomName", this.containerName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getFormProgressScaled(int par1) {
        return this.crystallizerFormTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getShapeTimeRemainingScaled(int par1) {
        if (this.currentItemShapingTime == 0) {
            this.currentItemShapingTime = 200;
        }
        return this.crystallizerShapeTime * par1 / this.currentItemShapingTime;
    }

    public boolean isCrystallizing() {
        return this.crystallizerShapeTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.crystallizerShapeTime > 0;
        boolean flag1 = false;
        if (this.crystallizerShapeTime > 0) {
            --this.crystallizerShapeTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.crystallizerShapeTime == 0 && this.canCrystallize()) {
                this.currentItemShapingTime = this.crystallizerShapeTime = TileEntityCrystallizer.getCrystallizationTime(this.crystallizerItemStacks[1]);
                if (this.crystallizerShapeTime > 0) {
                    flag1 = true;
                    if (this.crystallizerItemStacks[1] != null) {
                        --this.crystallizerItemStacks[1].field_77994_a;
                        if (this.crystallizerItemStacks[1].field_77994_a == 0) {
                            this.crystallizerItemStacks[1] = this.crystallizerItemStacks[1].func_77973_b().getContainerItem(this.crystallizerItemStacks[1]);
                        }
                    }
                }
            }
            if (this.isCrystallizing() && this.canCrystallize()) {
                ++this.crystallizerFormTime;
                if (this.crystallizerFormTime == 200) {
                    this.crystallizerFormTime = 0;
                    this.crystalizeItem();
                    flag1 = true;
                }
            } else {
                this.crystallizerFormTime = 0;
            }
            if (flag != this.crystallizerShapeTime > 0) {
                flag1 = true;
                BlockCrystallizer.updateCrystallizerBlockState(this.crystallizerShapeTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canCrystallize() {
        if (this.crystallizerItemStacks[0] == null) {
            return false;
        }
        if (CrystallizerRecipes.crystallization().getCrystallizationResult(this.crystallizerItemStacks[0]) == null) {
            return false;
        }
        ItemStack[] itemstack = CrystallizerRecipes.crystallization().getCrystallizationResult(this.crystallizerItemStacks[0]);
        if (itemstack[0] == null && itemstack[1] == null) {
            return false;
        }
        if (this.crystallizerItemStacks[2] == null && this.crystallizerItemStacks[3] == null) {
            return true;
        }
        if (!this.crystallizerItemStacks[2].func_77969_a(itemstack[0]) && !this.crystallizerItemStacks[3].func_77969_a(itemstack[1])) {
            return false;
        }
        int result = this.crystallizerItemStacks[2].field_77994_a + itemstack[0].field_77994_a;
        int result2 = this.crystallizerItemStacks[3].field_77994_a + itemstack[1].field_77994_a;
        return result <= this.func_70297_j_() && result2 <= this.func_70297_j_() && result <= this.crystallizerItemStacks[2].func_77976_d() && result2 <= this.crystallizerItemStacks[3].func_77976_d();
    }

    public void crystalizeItem() {
        if (this.canCrystallize()) {
            ItemStack[] itemstack = CrystallizerRecipes.crystallization().getCrystallizationResult(this.crystallizerItemStacks[0]);
            HashMap<ItemStack, ItemStack> testList = new HashMap<ItemStack, ItemStack>();
            testList.put(itemstack[0], itemstack[1]);
            Iterator iterator = testList.entrySet().iterator();
            if (this.crystallizerItemStacks[2] == null) {
                this.crystallizerItemStacks[2] = itemstack[0].func_77946_l();
            } else if (this.crystallizerItemStacks[2].func_77973_b() == itemstack[0].func_77973_b()) {
                this.crystallizerItemStacks[2].field_77994_a += itemstack[0].field_77994_a;
            }
            if (iterator.hasNext() && itemstack[1] != null) {
                if (this.crystallizerItemStacks[3] == null) {
                    this.crystallizerItemStacks[3] = itemstack[1].func_77946_l();
                } else if (this.crystallizerItemStacks[3].func_77973_b() == itemstack[1].func_77973_b()) {
                    this.crystallizerItemStacks[3].field_77994_a += itemstack[1].field_77994_a;
                }
            }
            --this.crystallizerItemStacks[0].field_77994_a;
            if (this.crystallizerItemStacks[0].field_77994_a <= 0) {
                this.crystallizerItemStacks[0] = null;
            }
        }
    }

    public static int getCrystallizationTime(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        Item item = par1ItemStack.func_77973_b();
        if (item == AbyssalCraft.dreadfragment) {
            return 100;
        }
        if (item == AbyssalCraft.Dreadshard) {
            return 1000;
        }
        if (item == AbyssalCraft.dreadchunk) {
            return 1600;
        }
        if (item instanceof ItemCrystal) {
            return 1200;
        }
        if (item == Items.field_151065_br) {
            return 1200;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return CoreRegistry.getFuelValue(par1ItemStack, CoreRegistry.FuelType.CRYSTALLIZER);
    }

    public static boolean isItemFuel(ItemStack par1ItemStack) {
        return TileEntityCrystallizer.getCrystallizationTime(par1ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityCrystallizer.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1 || par2ItemStack.func_77973_b() == Items.field_151133_ar;
    }
}

