/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.blocks.tile;

import com.shinoow.abyssalcraft.AbyssalCraft;
import com.shinoow.abyssalcraft.common.blocks.BlockTransmutator;
import com.shinoow.abyssalcraft.common.items.ItemCrystal;
import com.shinoow.abyssalcraft.core.util.CoreRegistry;
import com.shinoow.abyssalcraft.core.util.recipes.TransmutatorRecipes;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityTransmutator
extends TileEntity
implements ISidedInventory {
    private static final int[] slotsTop = new int[]{0};
    private static final int[] slotsBottom = new int[]{2, 1};
    private static final int[] slotsSides = new int[]{1};
    private ItemStack[] transmutatorItemStacks = new ItemStack[3];
    public int transmutatorBurnTime;
    public int currentItemBurnTime;
    public int transmutatorProcessTime;
    private String containerName;

    public int func_70302_i_() {
        return this.transmutatorItemStacks.length;
    }

    public ItemStack func_70301_a(int par1) {
        return this.transmutatorItemStacks[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (this.transmutatorItemStacks[par1] != null) {
            if (this.transmutatorItemStacks[par1].field_77994_a <= par2) {
                ItemStack itemstack = this.transmutatorItemStacks[par1];
                this.transmutatorItemStacks[par1] = null;
                return itemstack;
            }
            ItemStack itemstack = this.transmutatorItemStacks[par1].func_77979_a(par2);
            if (this.transmutatorItemStacks[par1].field_77994_a == 0) {
                this.transmutatorItemStacks[par1] = null;
            }
            return itemstack;
        }
        return null;
    }

    public ItemStack func_70304_b(int par1) {
        if (this.transmutatorItemStacks[par1] != null) {
            ItemStack itemstack = this.transmutatorItemStacks[par1];
            this.transmutatorItemStacks[par1] = null;
            return itemstack;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        this.transmutatorItemStacks[par1] = par2ItemStack;
        if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
            par2ItemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.containerName : "container.abyssalcraft.transmutator";
    }

    public boolean func_145818_k_() {
        return this.containerName != null && this.containerName.length() > 0;
    }

    public void func_145951_a(String par1) {
        this.containerName = par1;
    }

    public void func_145839_a(NBTTagCompound par1) {
        super.func_145839_a(par1);
        NBTTagList nbttaglist = par1.func_150295_c("Items", 10);
        this.transmutatorItemStacks = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.transmutatorItemStacks.length) continue;
            this.transmutatorItemStacks[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
        this.transmutatorBurnTime = par1.func_74765_d("BurnTime");
        this.transmutatorProcessTime = par1.func_74765_d("ProcessTime");
        this.currentItemBurnTime = TileEntityTransmutator.getItemBurnTime(this.transmutatorItemStacks[1]);
        if (par1.func_150297_b("CustomName", 8)) {
            this.containerName = par1.func_74779_i("CustomName");
        }
    }

    public void func_145841_b(NBTTagCompound par1) {
        super.func_145841_b(par1);
        par1.func_74777_a("BurnTime", (short)this.transmutatorBurnTime);
        par1.func_74777_a("ProcessTime", (short)this.transmutatorProcessTime);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.transmutatorItemStacks.length; ++i) {
            if (this.transmutatorItemStacks[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.transmutatorItemStacks[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        par1.func_74782_a("Items", (NBTBase)nbttaglist);
        if (this.func_145818_k_()) {
            par1.func_74778_a("CustomName", this.containerName);
        }
    }

    public int func_70297_j_() {
        return 64;
    }

    @SideOnly(value=Side.CLIENT)
    public int getProcessProgressScaled(int par1) {
        return this.transmutatorProcessTime * par1 / 200;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBurnTimeRemainingScaled(int par1) {
        if (this.currentItemBurnTime == 0) {
            this.currentItemBurnTime = 200;
        }
        return this.transmutatorBurnTime * par1 / this.currentItemBurnTime;
    }

    public boolean isTransmutating() {
        return this.transmutatorBurnTime > 0;
    }

    public void func_145845_h() {
        boolean flag = this.transmutatorBurnTime > 0;
        boolean flag1 = false;
        if (this.transmutatorBurnTime > 0) {
            --this.transmutatorBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.transmutatorBurnTime == 0 && this.canProcess()) {
                this.currentItemBurnTime = this.transmutatorBurnTime = TileEntityTransmutator.getItemBurnTime(this.transmutatorItemStacks[1]);
                if (this.transmutatorBurnTime > 0) {
                    flag1 = true;
                    if (this.transmutatorItemStacks[1] != null) {
                        --this.transmutatorItemStacks[1].field_77994_a;
                        if (this.transmutatorItemStacks[1].field_77994_a == 0) {
                            this.transmutatorItemStacks[1] = this.transmutatorItemStacks[1].func_77973_b().getContainerItem(this.transmutatorItemStacks[1]);
                        }
                    }
                }
            }
            if (this.isTransmutating() && this.canProcess()) {
                ++this.transmutatorProcessTime;
                if (this.transmutatorProcessTime == 200) {
                    this.transmutatorProcessTime = 0;
                    this.processItem();
                    flag1 = true;
                }
            } else {
                this.transmutatorProcessTime = 0;
            }
            if (flag != this.transmutatorBurnTime > 0) {
                flag1 = true;
                BlockTransmutator.updateTransmutatorBlockState(this.transmutatorBurnTime > 0, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    private boolean canProcess() {
        if (this.transmutatorItemStacks[0] == null) {
            return false;
        }
        ItemStack itemstack = TransmutatorRecipes.transmutation().getTransmutationResult(this.transmutatorItemStacks[0]);
        if (itemstack == null) {
            return false;
        }
        if (this.transmutatorItemStacks[2] == null) {
            return true;
        }
        if (!this.transmutatorItemStacks[2].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.transmutatorItemStacks[2].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= this.transmutatorItemStacks[2].func_77976_d();
    }

    public void processItem() {
        if (this.canProcess()) {
            ItemStack itemstack = TransmutatorRecipes.transmutation().getTransmutationResult(this.transmutatorItemStacks[0]);
            if (this.transmutatorItemStacks[2] == null) {
                this.transmutatorItemStacks[2] = itemstack.func_77946_l();
            } else if (this.transmutatorItemStacks[2].func_77973_b() == itemstack.func_77973_b()) {
                this.transmutatorItemStacks[2].field_77994_a += itemstack.field_77994_a;
            }
            --this.transmutatorItemStacks[0].field_77994_a;
            if (this.transmutatorItemStacks[0].field_77994_a <= 0) {
                this.transmutatorItemStacks[0] = null;
            }
        }
    }

    public static int getItemBurnTime(ItemStack par1ItemStack) {
        if (par1ItemStack == null) {
            return 0;
        }
        Item item = par1ItemStack.func_77973_b();
        if (item == AbyssalCraft.Corflesh) {
            return 100;
        }
        if (item == AbyssalCraft.Corbone) {
            return 100;
        }
        if (item == AbyssalCraft.cbrick) {
            return 200;
        }
        if (item == AbyssalCraft.Coralium) {
            return 200;
        }
        if (item == AbyssalCraft.Coraliumcluster2) {
            return 400;
        }
        if (item == AbyssalCraft.Coraliumcluster3) {
            return 600;
        }
        if (item == AbyssalCraft.Coraliumcluster4) {
            return 800;
        }
        if (item == AbyssalCraft.Coraliumcluster5) {
            return 1000;
        }
        if (item == AbyssalCraft.Coraliumcluster6) {
            return 1200;
        }
        if (item == AbyssalCraft.Coraliumcluster7) {
            return 1400;
        }
        if (item == AbyssalCraft.Coraliumcluster8) {
            return 1600;
        }
        if (item == AbyssalCraft.Coraliumcluster9) {
            return 1800;
        }
        if (item == AbyssalCraft.Cpearl) {
            return 2000;
        }
        if (item == AbyssalCraft.Corb) {
            return 10000;
        }
        if (item == AbyssalCraft.Cchunk) {
            return 16200;
        }
        if (item == AbyssalCraft.Cbucket) {
            return 20000;
        }
        if (item == Item.func_150898_a((Block)AbyssalCraft.Cwater)) {
            return 22000;
        }
        if (item instanceof ItemCrystal) {
            return 1200;
        }
        if (item == Items.field_151065_br) {
            return 1200;
        }
        if (item == Items.field_151072_bj) {
            return 2400;
        }
        return CoreRegistry.getFuelValue(par1ItemStack, CoreRegistry.FuelType.TRANSMUTATOR);
    }

    public static boolean isItemFuel(ItemStack par1ItemStack) {
        return TileEntityTransmutator.getItemBurnTime(par1ItemStack) > 0;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int par1, ItemStack par2ItemStack) {
        return par1 == 2 ? false : (par1 == 1 ? TileEntityTransmutator.isItemFuel(par2ItemStack) : true);
    }

    public int[] func_94128_d(int par1) {
        return par1 == 0 ? slotsBottom : (par1 == 1 ? slotsTop : slotsSides);
    }

    public boolean func_102007_a(int par1, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(par1, par2ItemStack);
    }

    public boolean func_102008_b(int par1, ItemStack par2ItemStack, int par3) {
        return par3 != 0 || par1 != 1 || par2ItemStack.func_77973_b() == Items.field_151133_ar;
    }
}

