/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.abyss.stronghold;

import com.shinoow.abyssalcraft.AbyssalCraft;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ChestGenHooks;

public class StructureAbyStrongholdPieces {
    private static final PieceWeight[] pieceWeightArray = new PieceWeight[]{new PieceWeight(Straight.class, 40, 0), new PieceWeight(Prison.class, 5, 5), new PieceWeight(LeftTurn.class, 20, 0), new PieceWeight(RightTurn.class, 20, 0), new PieceWeight(RoomCrossing.class, 10, 6), new PieceWeight(StairsStraight.class, 5, 5), new PieceWeight(Stairs.class, 5, 5), new PieceWeight(Crossing.class, 5, 4), new PieceWeight((Class)ChestCorridor.class, 5, 4){

        @Override
        public boolean canSpawnMoreStructuresOfType(int par1) {
            return super.canSpawnMoreStructuresOfType(par1) && par1 > 4;
        }
    }, new PieceWeight((Class)PortalRoom.class, 20, 1){

        @Override
        public boolean canSpawnMoreStructuresOfType(int par1) {
            return super.canSpawnMoreStructuresOfType(par1) && par1 > 5;
        }
    }};
    private static List<PieceWeight> structurePieceList;
    private static Class<?> strongComponentType;
    static int totalWeight;
    private static final Stones strongholdStones;

    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(ChestCorridor.class, (String)"SHACC");
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"SHAFC");
        MapGenStructureIO.func_143031_a(Crossing.class, (String)"SHA5C");
        MapGenStructureIO.func_143031_a(LeftTurn.class, (String)"SHALT");
        MapGenStructureIO.func_143031_a(PortalRoom.class, (String)"SHAPR");
        MapGenStructureIO.func_143031_a(Prison.class, (String)"SHAPH");
        MapGenStructureIO.func_143031_a(RightTurn.class, (String)"SHART");
        MapGenStructureIO.func_143031_a(RoomCrossing.class, (String)"SHARC");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"SHASD");
        MapGenStructureIO.func_143031_a(Stairs2.class, (String)"SHAStart");
        MapGenStructureIO.func_143031_a(Straight.class, (String)"SHAS");
        MapGenStructureIO.func_143031_a(StairsStraight.class, (String)"SHASSD");
    }

    public static void prepareStructurePieces() {
        structurePieceList = new ArrayList<PieceWeight>();
        for (PieceWeight pieceweight : pieceWeightArray) {
            pieceweight.instancesSpawned = 0;
            structurePieceList.add(pieceweight);
        }
        strongComponentType = null;
    }

    private static boolean canAddStructurePieces() {
        boolean flag = false;
        totalWeight = 0;
        for (PieceWeight pieceweight : structurePieceList) {
            if (pieceweight.instancesLimit > 0 && pieceweight.instancesSpawned < pieceweight.instancesLimit) {
                flag = true;
            }
            totalWeight += pieceweight.pieceWeight;
        }
        return flag;
    }

    private static Stronghold getStrongholdComponentFromWeightedPiece(Class<?> par0Class, List<Stronghold> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        Stronghold object = null;
        if (par0Class == Straight.class) {
            object = Straight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Prison.class) {
            object = Prison.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == LeftTurn.class) {
            object = LeftTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == RightTurn.class) {
            object = LeftTurn.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == RoomCrossing.class) {
            object = RoomCrossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == StairsStraight.class) {
            object = StairsStraight.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Stairs.class) {
            object = Stairs.getStrongholdStairsComponent(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == Crossing.class) {
            object = Crossing.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == ChestCorridor.class) {
            object = ChestCorridor.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        } else if (par0Class == PortalRoom.class) {
            object = PortalRoom.findValidPlacement(par1List, par2Random, par3, par4, par5, par6, par7);
        }
        return object;
    }

    private static Stronghold getNextComponent(Stairs2 par0ComponentStrongholdStairs2, List<Stronghold> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (!StructureAbyStrongholdPieces.canAddStructurePieces()) {
            return null;
        }
        if (strongComponentType != null) {
            Stronghold stronghold = StructureAbyStrongholdPieces.getStrongholdComponentFromWeightedPiece(strongComponentType, par1List, par2Random, par3, par4, par5, par6, par7);
            strongComponentType = null;
            if (stronghold != null) {
                return stronghold;
            }
        }
        int k1 = 0;
        block0: while (k1 < 5) {
            ++k1;
            int j1 = par2Random.nextInt(totalWeight);
            for (PieceWeight pieceweight : structurePieceList) {
                if ((j1 -= pieceweight.pieceWeight) >= 0) continue;
                if (!pieceweight.canSpawnMoreStructuresOfType(par7) || pieceweight == par0ComponentStrongholdStairs2.strongholdPieceWeight) continue block0;
                Stronghold stronghold1 = StructureAbyStrongholdPieces.getStrongholdComponentFromWeightedPiece(pieceweight.pieceClass, par1List, par2Random, par3, par4, par5, par6, par7);
                if (stronghold1 == null) continue;
                ++pieceweight.instancesSpawned;
                par0ComponentStrongholdStairs2.strongholdPieceWeight = pieceweight;
                if (!pieceweight.canSpawnMoreStructures()) {
                    structurePieceList.remove(pieceweight);
                }
                return stronghold1;
            }
        }
        StructureBoundingBox structureboundingbox = Corridor.func_74992_a(par1List, par2Random, par3, par4, par5, par6);
        if (structureboundingbox != null && structureboundingbox.field_78895_b > 1) {
            return new Corridor(par7, par2Random, structureboundingbox, par6);
        }
        return null;
    }

    private static StructureComponent getNextValidComponent(Stairs2 par0ComponentStrongholdStairs2, List<Stronghold> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 50) {
            return null;
        }
        if (Math.abs(par3 - par0ComponentStrongholdStairs2.func_74874_b().field_78897_a) <= 112 && Math.abs(par5 - par0ComponentStrongholdStairs2.func_74874_b().field_78896_c) <= 112) {
            Stronghold stronghold = StructureAbyStrongholdPieces.getNextComponent(par0ComponentStrongholdStairs2, par1List, par2Random, par3, par4, par5, par6, par7 + 1);
            if (stronghold != null) {
                par1List.add(stronghold);
                par0ComponentStrongholdStairs2.field_75026_c.add(stronghold);
            }
            return stronghold;
        }
        return null;
    }

    static {
        strongholdStones = new Stones(null);
    }

    static class PieceWeight {
        public Class<?> pieceClass;
        public final int pieceWeight;
        public int instancesSpawned;
        public int instancesLimit;

        public PieceWeight(Class<?> par1Class, int par2, int par3) {
            this.pieceClass = par1Class;
            this.pieceWeight = par2;
            this.instancesLimit = par3;
        }

        public boolean canSpawnMoreStructuresOfType(int par1) {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }

        public boolean canSpawnMoreStructures() {
            return this.instancesLimit == 0 || this.instancesSpawned < this.instancesLimit;
        }
    }

    static final class SwitchDoor {
        static final int[] doorEnum = new int[Stronghold.Door.values().length];

        SwitchDoor() {
        }

        static {
            try {
                SwitchDoor.doorEnum[Stronghold.Door.OPENING.ordinal()] = 1;
            }
            catch (NoSuchFieldError var4) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[Stronghold.Door.WOOD_DOOR.ordinal()] = 2;
            }
            catch (NoSuchFieldError var3) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[Stronghold.Door.GRATES.ordinal()] = 3;
            }
            catch (NoSuchFieldError var2) {
                // empty catch block
            }
            try {
                SwitchDoor.doorEnum[Stronghold.Door.IRON_DOOR.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static class Corridor
    extends Stronghold {
        private int field_74993_a;

        public Corridor() {
        }

        public Corridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
            this.field_74993_a = par4 != 2 && par4 != 0 ? par3StructureBoundingBox.func_78883_b() : par3StructureBoundingBox.func_78880_d();
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("Steps", this.field_74993_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_74993_a = par1NBTTagCompound.func_74762_e("Steps");
        }

        public static StructureBoundingBox func_74992_a(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)4, (int)par5);
            StructureComponent structurecomponent = StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox);
            if (structurecomponent == null) {
                return null;
            }
            if (structurecomponent.func_74874_b().field_78895_b == structureboundingbox.field_78895_b) {
                for (int i1 = 3; i1 >= 1; --i1) {
                    structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)(i1 - 1), (int)par5);
                    if (structurecomponent.func_74874_b().func_78884_a(structureboundingbox)) continue;
                    return StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)i1, (int)par5);
                }
            }
            return null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            for (int i = 0; i < this.field_74993_a; ++i) {
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 0, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 0, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 4, 0, i, par3StructureBoundingBox);
                for (int j = 1; j <= 3; ++j) {
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 0, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 1, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 2, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, 3, j, i, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 4, j, i, par3StructureBoundingBox);
                }
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 0, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 4, i, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 4, 4, i, par3StructureBoundingBox);
            }
            return true;
        }
    }

    public static class Crossing
    extends Stronghold {
        private boolean field_74996_b;
        private boolean field_74997_c;
        private boolean field_74995_d;
        private boolean field_74999_h;

        public Crossing() {
        }

        public Crossing(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.field_74996_b = par2Random.nextBoolean();
            this.field_74997_c = par2Random.nextBoolean();
            this.field_74995_d = par2Random.nextBoolean();
            this.field_74999_h = par2Random.nextInt(3) > 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("leftLow", this.field_74996_b);
            par1NBTTagCompound.func_74757_a("leftHigh", this.field_74997_c);
            par1NBTTagCompound.func_74757_a("rightLow", this.field_74995_d);
            par1NBTTagCompound.func_74757_a("rightHigh", this.field_74999_h);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_74996_b = par1NBTTagCompound.func_74767_n("leftLow");
            this.field_74997_c = par1NBTTagCompound.func_74767_n("leftHigh");
            this.field_74995_d = par1NBTTagCompound.func_74767_n("rightLow");
            this.field_74999_h = par1NBTTagCompound.func_74767_n("rightHigh");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = 3;
            int j = 5;
            if (this.field_74885_f == 1 || this.field_74885_f == 2) {
                i = 8 - i;
                j = 8 - j;
            }
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 5, 1);
            if (this.field_74996_b) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, i, 1);
            }
            if (this.field_74997_c) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, j, 7);
            }
            if (this.field_74995_d) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, i, 1);
            }
            if (this.field_74999_h) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, j, 7);
            }
        }

        public static Crossing findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-3, (int)0, (int)10, (int)9, (int)11, (int)par5);
            return Crossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Crossing(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 9, 8, 10, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 4, 3, 0);
            if (this.field_74996_b) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 3, 1, 0, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74995_d) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 9, 3, 1, 9, 5, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74997_c) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 7, 0, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.field_74999_h) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 9, 5, 7, 9, 7, 9, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 10, 7, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 2, 1, 8, 2, 6, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 5, 4, 4, 9, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 8, 1, 5, 8, 4, 9, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 4, 7, 3, 4, 9, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 3, 5, 3, 3, 6, false, par2Random, strongholdStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 3, 4, 3, 3, 4, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 4, 6, 3, 4, 6, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 5, 1, 7, 7, 1, 8, false, par2Random, strongholdStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 9, 7, 1, 9, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 2, 7, 7, 2, 7, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 5, 7, 4, 5, 9, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 8, 5, 7, 8, 5, 9, AbyssalCraft.abyslab1, AbyssalCraft.abyslab1, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 5, 7, 7, 5, 9, AbyssalCraft.abyslab2, AbyssalCraft.abyslab2, false);
            this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 6, 5, 6, par3StructureBoundingBox);
            return true;
        }
    }

    public static abstract class Stronghold
    extends StructureComponent {
        protected Door field_143013_d = Door.OPENING;

        public Stronghold() {
        }

        protected Stronghold(int par1) {
            super(par1);
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74778_a("EntryDoor", this.field_143013_d.name());
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            this.field_143013_d = Door.valueOf(par1NBTTagCompound.func_74779_i("EntryDoor"));
        }

        protected void placeDoor(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox, Door par4EnumDoor, int par5, int par6, int par7) {
            switch (SwitchDoor.doorEnum[par4EnumDoor.ordinal()]) {
                default: {
                    this.func_151549_a(par1World, par3StructureBoundingBox, par5, par6, par7, par5 + 3 - 1, par6 + 3 - 1, par7, Blocks.field_150350_a, Blocks.field_150350_a, false);
                    break;
                }
                case 2: {
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150466_ao, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150466_ao, 8, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    break;
                }
                case 3: {
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150350_a, 0, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    break;
                }
                case 4: {
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 1, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6 + 2, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, par5 + 2, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150454_av, 0, par5 + 1, par6, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150454_av, 8, par5 + 1, par6 + 1, par7, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Abybutton, this.func_151555_a(AbyssalCraft.Abybutton, 4), par5 + 2, par6 + 1, par7 + 1, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Abybutton, this.func_151555_a(AbyssalCraft.Abybutton, 3), par5 + 2, par6 + 1, par7 - 1, par3StructureBoundingBox);
                }
            }
        }

        protected Door getRandomDoor(Random par1Random) {
            int i = par1Random.nextInt(5);
            switch (i) {
                default: {
                    return Door.OPENING;
                }
                case 2: {
                    return Door.WOOD_DOOR;
                }
                case 3: {
                    return Door.GRATES;
                }
                case 4: 
            }
            return Door.IRON_DOOR;
        }

        protected StructureComponent getNextComponentNormal(Stairs2 par1ComponentStrongholdStairs2, List<Stronghold> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78892_f + 1, this.field_74885_f, this.func_74877_c());
                }
                case 1: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
                case 2: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par4, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c - 1, this.field_74885_f, this.func_74877_c());
                }
                case 3: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par5, this.field_74887_e.field_78896_c + par4, this.field_74885_f, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentX(Stairs2 par1ComponentStrongholdStairs2, List<Stronghold> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 1: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
                case 2: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 1, this.func_74877_c());
                }
                case 3: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c - 1, 2, this.func_74877_c());
                }
            }
            return null;
        }

        protected StructureComponent getNextComponentZ(Stairs2 par1ComponentStrongholdStairs2, List<Stronghold> par2List, Random par3Random, int par4, int par5) {
            switch (this.field_74885_f) {
                case 0: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 1: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
                case 2: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78896_c + par5, 3, this.func_74877_c());
                }
                case 3: {
                    return StructureAbyStrongholdPieces.getNextValidComponent(par1ComponentStrongholdStairs2, par2List, par3Random, this.field_74887_e.field_78897_a + par5, this.field_74887_e.field_78895_b + par4, this.field_74887_e.field_78892_f + 1, 0, this.func_74877_c());
                }
            }
            return null;
        }

        protected static boolean canStrongholdGoDeeper(StructureBoundingBox par0StructureBoundingBox) {
            return par0StructureBoundingBox != null && par0StructureBoundingBox.field_78895_b > 10;
        }

        public static enum Door {
            OPENING,
            WOOD_DOOR,
            GRATES,
            IRON_DOOR;

        }
    }

    static class Stones
    extends StructureComponent.BlockSelector {
        private Stones() {
        }

        public void func_75062_a(Random par1Random, int par2, int par3, int par4, boolean par5) {
            if (par5) {
                this.field_151562_a = AbyssalCraft.abybrick;
                float f = par1Random.nextFloat();
                if (f < 0.2f) {
                    this.field_75065_b = 0;
                } else if (f < 0.5f) {
                    this.field_75065_b = 0;
                } else if (f < 0.55f) {
                    this.field_151562_a = AbyssalCraft.abybrick;
                    this.field_75065_b = 0;
                } else {
                    this.field_75065_b = 0;
                }
            } else {
                this.field_151562_a = Blocks.field_150350_a;
                this.field_75065_b = 0;
            }
        }

        Stones(Object par1StructureStrongholdPieceWeight2) {
            this();
        }
    }

    public static class RightTurn
    extends LeftTurn {
        @Override
        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            } else {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            }
        }

        @Override
        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 4, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class LeftTurn
    extends Stronghold {
        public LeftTurn() {
        }

        public LeftTurn(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            } else {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            }
        }

        public static LeftTurn findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)5, (int)par5);
            return LeftTurn.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new LeftTurn(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 4, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            if (this.field_74885_f != 2 && this.field_74885_f != 3) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 1, 0, 3, 3, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Prison
    extends Stronghold {
        public Prison() {
        }

        public Prison(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static Prison findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)9, (int)5, (int)11, (int)par5);
            return Prison.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Prison(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 8, 4, 10, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 10, 3, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 1, 4, 3, 1, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 3, 4, 3, 3, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 7, 4, 3, 7, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 9, 4, 3, 9, false, par2Random, strongholdStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 4, 4, 3, 6, AbyssalCraft.abyfence, AbyssalCraft.abyfence, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 5, 1, 5, 7, 3, 5, AbyssalCraft.abyfence, AbyssalCraft.abyfence, false);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, 4, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, 0, 4, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3), 4, 1, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3) + 8, 4, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3), 4, 1, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, Blocks.field_150454_av, this.func_151555_a(Blocks.field_150454_av, 3) + 8, 4, 2, 8, par3StructureBoundingBox);
            return true;
        }
    }

    public static class Stairs2
    extends Stairs {
        public PieceWeight strongholdPieceWeight;
        public PortalRoom strongholdPortalRoom;
        public List<Stronghold> field_75026_c = new ArrayList<Stronghold>();

        public Stairs2() {
        }

        public Stairs2(int par1, Random par2Random, int par3, int par4) {
            super(0, par2Random, par3, par4);
        }

        public ChunkPosition func_151553_a() {
            return this.strongholdPortalRoom != null ? this.strongholdPortalRoom.func_151553_a() : super.func_151553_a();
        }
    }

    public static class StairsStraight
    extends Stronghold {
        public StairsStraight() {
        }

        public StairsStraight(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static StairsStraight findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)8, (int)par5);
            return StairsStraight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new StairsStraight(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 10, 7, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 7, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, Stronghold.Door.OPENING, 1, 1, 7);
            int i = this.func_151555_a(AbyssalCraft.DCstairs, 2);
            for (int j = 0; j < 6; ++j) {
                this.func_151550_a(par1World, AbyssalCraft.DCstairs, i, 1, 6 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.DCstairs, i, 2, 6 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.DCstairs, i, 3, 6 - j, 1 + j, par3StructureBoundingBox);
                if (j >= 5) continue;
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 5 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 5 - j, 1 + j, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 5 - j, 1 + j, par3StructureBoundingBox);
            }
            return true;
        }
    }

    public static class RoomCrossing
    extends Stronghold {
        public static final WeightedRandomChestContent[] strongholdRoomCrossingChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(AbyssalCraft.abyingot, 0, 1, 5, 10), new WeightedRandomChestContent(AbyssalCraft.Cingot, 0, 1, 5, 5), new WeightedRandomChestContent(AbyssalCraft.Cpearl, 0, 1, 3, 5), new WeightedRandomChestContent(AbyssalCraft.Coralium, 0, 3, 8, 10), new WeightedRandomChestContent(Items.field_151153_ao, 0, 1, 3, 15), new WeightedRandomChestContent(AbyssalCraft.MRE, 0, 1, 1, 10), new WeightedRandomChestContent(AbyssalCraft.pickaxeA, 0, 1, 1, 1)};
        protected int roomType;

        public RoomCrossing() {
        }

        public RoomCrossing(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.roomType = par2Random.nextInt(5);
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74768_a("Type", this.roomType);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.roomType = par1NBTTagCompound.func_74762_e("Type");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 4, 1);
            this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 4);
            this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 4);
        }

        public static RoomCrossing findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)11, (int)7, (int)11, (int)par5);
            return RoomCrossing.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new RoomCrossing(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 10, 6, 10, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 4, 1, 0);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 10, 6, 3, 10, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 4, 0, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 10, 1, 4, 10, 3, 6, Blocks.field_150350_a, Blocks.field_150350_a, false);
            switch (this.roomType) {
                case 0: {
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 2, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 3, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 4, 3, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 6, 3, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 5, 3, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 5, 3, 6, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 4, 1, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 4, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 4, 1, 6, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 6, 1, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 6, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 6, 1, 6, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 5, 1, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 5, 1, 6, par3StructureBoundingBox);
                    break;
                }
                case 1: {
                    for (int i = 0; i < 5; ++i) {
                        this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 1, 3 + i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 7, 1, 3 + i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3 + i, 1, 3, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3 + i, 1, 7, par3StructureBoundingBox);
                    }
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 2, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 5, 3, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, (Block)Blocks.field_150358_i, 0, 5, 4, 5, par3StructureBoundingBox);
                    break;
                }
                case 2: {
                    int i;
                    for (i = 1; i <= 9; ++i) {
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 1, 3, i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 9, 3, i, par3StructureBoundingBox);
                    }
                    for (i = 1; i <= 9; ++i) {
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, i, 3, 1, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, i, 3, 9, par3StructureBoundingBox);
                    }
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 5, 1, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 5, 1, 6, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 5, 3, 4, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 5, 3, 6, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 4, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 6, 1, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 4, 3, 5, par3StructureBoundingBox);
                    this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 6, 3, 5, par3StructureBoundingBox);
                    for (i = 1; i <= 3; ++i) {
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 4, i, 4, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 6, i, 4, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 4, i, 6, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.Darkstone_cobble, 0, 6, i, 6, par3StructureBoundingBox);
                    }
                    this.func_151550_a(par1World, Blocks.field_150478_aa, 0, 5, 3, 5, par3StructureBoundingBox);
                    for (i = 2; i <= 8; ++i) {
                        this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 2, 3, i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 3, 3, i, par3StructureBoundingBox);
                        if (i <= 3 || i >= 7) {
                            this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 4, 3, i, par3StructureBoundingBox);
                            this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 5, 3, i, par3StructureBoundingBox);
                            this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 6, 3, i, par3StructureBoundingBox);
                        }
                        this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 7, 3, i, par3StructureBoundingBox);
                        this.func_151550_a(par1World, AbyssalCraft.DLTplank, 0, 8, 3, i, par3StructureBoundingBox);
                    }
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 1, 3, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 2, 3, par3StructureBoundingBox);
                    this.func_151550_a(par1World, Blocks.field_150468_ap, this.func_151555_a(Blocks.field_150468_ap, 4), 9, 3, 3, par3StructureBoundingBox);
                    this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 3, 4, 8, strongholdRoomCrossingChestContents, ChestGenHooks.getCount((String)"strongholdCrossing", (Random)par2Random));
                }
            }
            return true;
        }
    }

    public static class ChestCorridor
    extends Stronghold {
        public static final WeightedRandomChestContent[] strongholdChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(Items.field_151079_bi, 0, 1, 4, 10), new WeightedRandomChestContent(AbyssalCraft.Corb, 0, 1, 3, 3), new WeightedRandomChestContent(AbyssalCraft.abyingot, 0, 1, 5, 10), new WeightedRandomChestContent(AbyssalCraft.Cingot, 0, 1, 3, 5), new WeightedRandomChestContent(AbyssalCraft.Cpearl, 0, 1, 3, 5), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(Items.field_151153_ao, 0, 1, 3, 15), new WeightedRandomChestContent(AbyssalCraft.pickaxeA, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.pickaxeA, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.plate, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.helmet, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.legs, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.boots, 0, 1, 1, 5), new WeightedRandomChestContent(AbyssalCraft.OC, 0, 1, 1, 1)};
        private boolean hasMadeChest;

        public ChestCorridor() {
        }

        public ChestCorridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Chest", this.hasMadeChest);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.hasMadeChest = par1NBTTagCompound.func_74767_n("Chest");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static ChestCorridor findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)par5);
            return ChestCorridor.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new ChestCorridor(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 6, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_151549_a(par1World, par3StructureBoundingBox, 3, 1, 2, 3, 1, 4, AbyssalCraft.abybrick, AbyssalCraft.abybrick, false);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 5, 3, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 5, 3, 1, 5, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 5, 3, 2, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 5, 3, 2, 4, par3StructureBoundingBox);
            for (i = 2; i <= 4; ++i) {
                this.func_151550_a(par1World, AbyssalCraft.abyslab1, 5, 2, 1, i, par3StructureBoundingBox);
            }
            if (!this.hasMadeChest) {
                int k;
                i = this.func_74862_a(2);
                int j = this.func_74865_a(3, 3);
                if (par3StructureBoundingBox.func_78890_b(j, i, k = this.func_74873_b(3, 3))) {
                    this.hasMadeChest = true;
                    this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 3, 2, 3, strongholdChestContents, ChestGenHooks.getCount((String)"strongholdCorridor", (Random)par2Random));
                }
            }
            return true;
        }
    }

    public static class PortalRoom
    extends Stronghold {
        private boolean hasSpawner;

        public PortalRoom() {
        }

        public PortalRoom(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Mob", this.hasSpawner);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.hasSpawner = par1NBTTagCompound.func_74767_n("Mob");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (par1StructureComponent != null) {
                ((Stairs2)par1StructureComponent).strongholdPortalRoom = this;
            }
        }

        public static PortalRoom findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-4, (int)-1, (int)0, (int)11, (int)8, (int)16, (int)par5);
            return PortalRoom.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new PortalRoom(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int i;
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 10, 7, 15, false, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, Stronghold.Door.GRATES, 4, 1, 0);
            int b0 = 6;
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, b0, 1, 1, b0, 14, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 9, b0, 1, 9, b0, 14, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 2, b0, 1, 8, b0, 2, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 2, b0, 14, 8, b0, 14, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 1, 1, 1, 2, 1, 4, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 8, 1, 1, 9, 1, 4, false, par2Random, strongholdStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 1, 1, 1, 1, 1, 3, AbyssalCraft.Cwater, AbyssalCraft.Cwater, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 9, 1, 1, 9, 1, 3, AbyssalCraft.Cwater, AbyssalCraft.Cwater, false);
            this.func_74882_a(par1World, par3StructureBoundingBox, 3, 1, 8, 7, 1, 12, false, par2Random, strongholdStones);
            this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 9, 6, 1, 11, AbyssalCraft.Cwater, AbyssalCraft.Cwater, false);
            for (i = 3; i < 14; i += 2) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 3, i, 0, 4, i, AbyssalCraft.abyfence, AbyssalCraft.abyfence, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 10, 3, i, 10, 4, i, AbyssalCraft.abyfence, AbyssalCraft.abyfence, false);
            }
            for (i = 2; i < 9; i += 2) {
                this.func_151549_a(par1World, par3StructureBoundingBox, i, 3, 15, i, 4, 15, AbyssalCraft.abyfence, AbyssalCraft.abyfence, false);
            }
            i = this.func_151555_a(AbyssalCraft.abystairs, 3);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 1, 5, 6, 1, 7, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 2, 6, 6, 2, 7, false, par2Random, strongholdStones);
            this.func_74882_a(par1World, par3StructureBoundingBox, 4, 3, 7, 6, 3, 7, false, par2Random, strongholdStones);
            for (int j = 4; j <= 6; ++j) {
                this.func_151550_a(par1World, AbyssalCraft.abystairs, i, j, 1, 4, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abystairs, i, j, 2, 5, par3StructureBoundingBox);
                this.func_151550_a(par1World, AbyssalCraft.abystairs, i, j, 3, 6, par3StructureBoundingBox);
            }
            int b4 = 2;
            int b1 = 0;
            int b2 = 3;
            int b3 = 1;
            switch (this.field_74885_f) {
                case 0: {
                    b4 = 0;
                    b1 = 2;
                    break;
                }
                case 1: {
                    b4 = 1;
                    b1 = 3;
                    b2 = 0;
                    b3 = 2;
                }
                default: {
                    break;
                }
                case 3: {
                    b4 = 3;
                    b1 = 1;
                    b2 = 0;
                    b3 = 2;
                }
            }
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b4 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b4 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b4 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 3, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 3, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 3, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 4, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 4, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 4, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.PSDL, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 3, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 3, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 3, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 3, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 3, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 3, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 5, 3, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 4, 3, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 6, 3, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 3, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 3, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 3, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 4, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b2 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 4, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 3, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 3, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 3, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 4, 9, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 4, 10, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b3 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 4, 11, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 3, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 4, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 3, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 4, 12, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 7, 4, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 3, 8, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyfence, b1 + (par2Random.nextFloat() > 0.9f ? 4 : 0), 3, 4, 8, par3StructureBoundingBox);
            if (!this.hasSpawner) {
                int l;
                int i1 = this.func_74862_a(3);
                int k = this.func_74865_a(5, 6);
                if (par3StructureBoundingBox.func_78890_b(k, i1, l = this.func_74873_b(5, 6))) {
                    this.hasSpawner = true;
                    par1World.func_147465_d(k, i1, l, Blocks.field_150474_ac, 0, 2);
                    TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)par1World.func_147438_o(k, i1, l);
                    if (tileentitymobspawner != null) {
                        tileentitymobspawner.func_145881_a().func_98272_a("Zombie");
                    }
                }
            }
            return true;
        }
    }

    public static class Straight
    extends Stronghold {
        private boolean expandsX;
        private boolean expandsZ;

        public Straight() {
        }

        public Straight(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
            this.expandsX = par2Random.nextInt(2) == 0;
            this.expandsZ = par2Random.nextInt(2) == 0;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Left", this.expandsX);
            par1NBTTagCompound.func_74757_a("Right", this.expandsZ);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.expandsX = par1NBTTagCompound.func_74767_n("Left");
            this.expandsZ = par1NBTTagCompound.func_74767_n("Right");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
            if (this.expandsX) {
                this.getNextComponentX((Stairs2)par1StructureComponent, par2List, par3Random, 1, 2);
            }
            if (this.expandsZ) {
                this.getNextComponentZ((Stairs2)par1StructureComponent, par2List, par3Random, 1, 2);
            }
        }

        public static Straight findValidPlacement(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-1, (int)0, (int)5, (int)5, (int)7, (int)par5);
            return Straight.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Straight(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 4, 6, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 1, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, Stronghold.Door.OPENING, 1, 1, 6);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 1, 2, 1, Blocks.field_150478_aa, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 3, 2, 1, Blocks.field_150478_aa, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 1, 2, 5, Blocks.field_150478_aa, 0);
            this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.1f, 3, 2, 5, Blocks.field_150478_aa, 0);
            if (this.expandsX) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 1, 2, 0, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            if (this.expandsZ) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 4, 1, 2, 4, 3, 4, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Stairs
    extends Stronghold {
        private boolean field_75024_a;

        public Stairs() {
        }

        public Stairs(int par1, Random par2Random, int par3, int par4) {
            super(par1);
            this.field_75024_a = true;
            this.field_74885_f = par2Random.nextInt(4);
            this.field_143013_d = Stronghold.Door.OPENING;
            switch (this.field_74885_f) {
                case 0: 
                case 2: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                    break;
                }
                default: {
                    this.field_74887_e = new StructureBoundingBox(par3, 64, par4, par3 + 5 - 1, 74, par4 + 5 - 1);
                }
            }
        }

        public Stairs(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_75024_a = false;
            this.field_74885_f = par4;
            this.field_143013_d = this.getRandomDoor(par2Random);
            this.field_74887_e = par3StructureBoundingBox;
        }

        @Override
        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            super.func_143012_a(par1NBTTagCompound);
            par1NBTTagCompound.func_74757_a("Source", this.field_75024_a);
        }

        @Override
        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            super.func_143011_b(par1NBTTagCompound);
            this.field_75024_a = par1NBTTagCompound.func_74767_n("Source");
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            if (this.field_75024_a) {
                strongComponentType = Crossing.class;
            }
            this.getNextComponentNormal((Stairs2)par1StructureComponent, par2List, par3Random, 1, 1);
        }

        public static Stairs getStrongholdStairsComponent(List<Stronghold> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
            StructureBoundingBox structureboundingbox = StructureBoundingBox.func_78889_a((int)par2, (int)par3, (int)par4, (int)-1, (int)-7, (int)0, (int)5, (int)11, (int)5, (int)par5);
            return Stairs.canStrongholdGoDeeper(structureboundingbox) && StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null ? new Stairs(par6, par1Random, structureboundingbox, par5) : null;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_74882_a(par1World, par3StructureBoundingBox, 0, 0, 0, 4, 10, 4, true, par2Random, strongholdStones);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, this.field_143013_d, 1, 7, 0);
            this.placeDoor(par1World, par2Random, par3StructureBoundingBox, Stronghold.Door.OPENING, 1, 1, 4);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 6, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 5, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 1, 6, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 5, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 1, 5, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 3, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 3, 4, 3, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 3, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 3, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 3, 3, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 2, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 1, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 1, 2, 1, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abybrick, 0, 1, 1, 2, par3StructureBoundingBox);
            this.func_151550_a(par1World, AbyssalCraft.abyslab1, 0, 1, 1, 3, par3StructureBoundingBox);
            return true;
        }
    }
}

