/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.dreadlands.mineshaft;

import com.shinoow.abyssalcraft.AbyssalCraft;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraftforge.common.ChestGenHooks;

public class StructureDreadlandsMinePieces {
    public static final WeightedRandomChestContent[] mineshaftChestContents = new WeightedRandomChestContent[]{new WeightedRandomChestContent(AbyssalCraft.abyingot, 0, 1, 5, 10), new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 3, 5), new WeightedRandomChestContent(AbyssalCraft.Coralium, 0, 4, 9, 5), new WeightedRandomChestContent(AbyssalCraft.shadowshard, 0, 4, 9, 5), new WeightedRandomChestContent(Items.field_151045_i, 0, 1, 2, 3), new WeightedRandomChestContent(AbyssalCraft.Dreadshard, 0, 3, 8, 10), new WeightedRandomChestContent(Items.field_151025_P, 0, 1, 3, 15), new WeightedRandomChestContent(AbyssalCraft.Corpickaxe, 0, 1, 1, 1), new WeightedRandomChestContent(Item.func_150898_a((Block)Blocks.field_150448_aq), 0, 4, 8, 1), new WeightedRandomChestContent(AbyssalCraft.abychunk, 0, 2, 4, 10), new WeightedRandomChestContent(AbyssalCraft.dreadchunk, 0, 2, 4, 10), new WeightedRandomChestContent(AbyssalCraft.Corb, 0, 1, 1, 3), new WeightedRandomChestContent(AbyssalCraft.OC, 0, 1, 1, 1)};

    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"DLMSCorridor");
        MapGenStructureIO.func_143031_a(Cross.class, (String)"DLMSCrossing");
        MapGenStructureIO.func_143031_a(Room.class, (String)"DLMSRoom");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"DLMSStairs");
    }

    private static StructureComponent getRandomComponent(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, int par5, int par6) {
        int j1 = par1Random.nextInt(100);
        if (j1 >= 80) {
            StructureBoundingBox structureboundingbox = Cross.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Cross(par6, par1Random, structureboundingbox, par5);
            }
        } else if (j1 >= 70) {
            StructureBoundingBox structureboundingbox = Stairs.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Stairs(par6, par1Random, structureboundingbox, par5);
            }
        } else {
            StructureBoundingBox structureboundingbox = Corridor.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Corridor(par6, par1Random, structureboundingbox, par5);
            }
        }
        return null;
    }

    private static StructureComponent getNextMineShaftComponent(StructureComponent par0StructureComponent, List<StructureComponent> par1List, Random par2Random, int par3, int par4, int par5, int par6, int par7) {
        if (par7 > 8) {
            return null;
        }
        if (Math.abs(par3 - par0StructureComponent.func_74874_b().field_78897_a) <= 80 && Math.abs(par5 - par0StructureComponent.func_74874_b().field_78896_c) <= 80) {
            StructureComponent structurecomponent1 = StructureDreadlandsMinePieces.getRandomComponent(par1List, par2Random, par3, par4, par5, par6, par7 + 1);
            if (structurecomponent1 != null) {
                par1List.add(structurecomponent1);
                structurecomponent1.func_74861_a(par0StructureComponent, par1List, par2Random);
            }
            return structurecomponent1;
        }
        return null;
    }

    public static class Stairs
    extends StructureComponent {
        public Stairs() {
        }

        public Stairs(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, int par5) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3 - 5, par4, par2, par3 + 2, par4);
            switch (par5) {
                case 0: {
                    structureboundingbox.field_78893_d = par2 + 2;
                    structureboundingbox.field_78892_f = par4 + 8;
                    break;
                }
                case 1: {
                    structureboundingbox.field_78897_a = par2 - 8;
                    structureboundingbox.field_78892_f = par4 + 2;
                    break;
                }
                case 2: {
                    structureboundingbox.field_78893_d = par2 + 2;
                    structureboundingbox.field_78896_c = par4 - 8;
                    break;
                }
                case 3: {
                    structureboundingbox.field_78893_d = par2 + 8;
                    structureboundingbox.field_78892_f = par4 + 2;
                }
            }
            return StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = this.func_74877_c();
            switch (this.field_74885_f) {
                case 0: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    break;
                }
                case 1: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 1, i);
                    break;
                }
                case 2: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    break;
                }
                case 3: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, 3, i);
                }
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (int i = 0; i < 5; ++i) {
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            return true;
        }
    }

    public static class Room
    extends StructureComponent {
        private List<StructureBoundingBox> roomsLinkedToTheRoom = new LinkedList<StructureBoundingBox>();

        public Room() {
        }

        public Room(int par1, Random par2Random, int par3, int par4) {
            super(par1);
            this.field_74887_e = new StructureBoundingBox(par3, 50, par4, par3 + 7 + par2Random.nextInt(6), 54 + par2Random.nextInt(6), par4 + 7 + par2Random.nextInt(6));
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            StructureBoundingBox structureboundingbox;
            StructureComponent structurecomponent1;
            int j;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += par3Random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, 2, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += par3Random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, 0, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78892_f - 1, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += par3Random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, 1, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78897_a + 1, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += par3Random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, 3, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78893_d, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, AbyssalCraft.dreadgrass, Blocks.field_150350_a, true);
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (StructureBoundingBox structureboundingbox1 : this.roomsLinkedToTheRoom) {
                this.func_151549_a(par1World, par3StructureBoundingBox, structureboundingbox1.field_78897_a, structureboundingbox1.field_78894_e - 2, structureboundingbox1.field_78896_c, structureboundingbox1.field_78893_d, structureboundingbox1.field_78894_e, structureboundingbox1.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151547_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, false);
            return true;
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                nbttaglist.func_74742_a((NBTBase)structureboundingbox.func_151535_h());
            }
            par1NBTTagCompound.func_74782_a("Entrances", (NBTBase)nbttaglist);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Entrances", 11);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(nbttaglist.func_150306_c(i)));
            }
        }
    }

    public static class Cross
    extends StructureComponent {
        private int corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74757_a("tf", this.isMultipleFloors);
            par1NBTTagCompound.func_74768_a("D", this.corridorDirection);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            this.isMultipleFloors = par1NBTTagCompound.func_74767_n("tf");
            this.corridorDirection = par1NBTTagCompound.func_74762_e("D");
        }

        public Cross(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.corridorDirection = par4;
            this.field_74887_e = par3StructureBoundingBox;
            this.isMultipleFloors = par3StructureBoundingBox.func_78882_c() > 3;
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, int par5) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3, par4, par2, par3 + 2, par4);
            if (par1Random.nextInt(4) == 0) {
                structureboundingbox.field_78894_e += 4;
            }
            switch (par5) {
                case 0: {
                    structureboundingbox.field_78897_a = par2 - 1;
                    structureboundingbox.field_78893_d = par2 + 3;
                    structureboundingbox.field_78892_f = par4 + 4;
                    break;
                }
                case 1: {
                    structureboundingbox.field_78897_a = par2 - 4;
                    structureboundingbox.field_78896_c = par4 - 1;
                    structureboundingbox.field_78892_f = par4 + 3;
                    break;
                }
                case 2: {
                    structureboundingbox.field_78897_a = par2 - 1;
                    structureboundingbox.field_78893_d = par2 + 3;
                    structureboundingbox.field_78896_c = par4 - 4;
                    break;
                }
                case 3: {
                    structureboundingbox.field_78893_d = par2 + 4;
                    structureboundingbox.field_78896_c = par4 - 1;
                    structureboundingbox.field_78892_f = par4 + 3;
                }
            }
            return StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                case 0: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                    break;
                }
                case 1: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    break;
                }
                case 2: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 1, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                    break;
                }
                case 3: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, 3, i);
                }
            }
            if (this.isMultipleFloors) {
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, 2, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, 1, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, 3, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, 0, i);
                }
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            if (this.isMultipleFloors) {
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            } else {
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a, Blocks.field_150350_a, false);
            }
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
            this.func_151549_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_151548_a(par1World, i, this.field_74887_e.field_78895_b - 1, j, par3StructureBoundingBox).func_149688_o() != Material.field_151579_a) continue;
                    this.func_151550_a(par1World, AbyssalCraft.dreadplanks, 0, i, this.field_74887_e.field_78895_b - 1, j, par3StructureBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends StructureComponent {
        private boolean hasRails;
        private int sectionCount;

        public Corridor() {
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74757_a("hr", this.hasRails);
            par1NBTTagCompound.func_74768_a("Num", this.sectionCount);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound) {
            this.hasRails = par1NBTTagCompound.func_74767_n("hr");
            this.sectionCount = par1NBTTagCompound.func_74762_e("Num");
        }

        public Corridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, int par4) {
            super(par1);
            this.field_74885_f = par4;
            this.field_74887_e = par3StructureBoundingBox;
            this.hasRails = par2Random.nextInt(3) == 0;
            this.sectionCount = this.field_74885_f != 2 && this.field_74885_f != 0 ? par3StructureBoundingBox.func_78883_b() / 5 : par3StructureBoundingBox.func_78880_d() / 5;
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, int par5) {
            int i1;
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3, par4, par2, par3 + 2, par4);
            for (i1 = par1Random.nextInt(3) + 2; i1 > 0; --i1) {
                int j1 = i1 * 5;
                switch (par5) {
                    case 0: {
                        structureboundingbox.field_78893_d = par2 + 2;
                        structureboundingbox.field_78892_f = par4 + j1 - 1;
                        break;
                    }
                    case 1: {
                        structureboundingbox.field_78897_a = par2 - (j1 - 1);
                        structureboundingbox.field_78892_f = par4 + 2;
                        break;
                    }
                    case 2: {
                        structureboundingbox.field_78893_d = par2 + 2;
                        structureboundingbox.field_78896_c = par4 - (j1 - 1);
                        break;
                    }
                    case 3: {
                        structureboundingbox.field_78893_d = par2 + j1 - 1;
                        structureboundingbox.field_78892_f = par4 + 2;
                    }
                }
                if (StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null) break;
            }
            return i1 > 0 ? structureboundingbox : null;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            block24: {
                int i = this.func_74877_c();
                int j = par3Random.nextInt(4);
                switch (this.field_74885_f) {
                    case 0: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f - 3, 1, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f - 3, 3, i);
                        break;
                    }
                    case 1: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, 2, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, 0, i);
                        break;
                    }
                    case 2: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, 1, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, 3, i);
                        break;
                    }
                    case 3: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, this.field_74885_f, i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, 2, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, 0, i);
                    }
                }
                if (i >= 8) break block24;
                if (this.field_74885_f != 2 && this.field_74885_f != 0) {
                    int k = this.field_74887_e.field_78897_a + 3;
                    while (k + 3 <= this.field_74887_e.field_78893_d) {
                        int l = par3Random.nextInt(5);
                        if (l == 0) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, 2, i + 1);
                        } else if (l == 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, 0, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = par3Random.nextInt(5);
                        if (l == 0) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, 1, i + 1);
                        } else if (l == 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, 3, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_74879_a(World par1World, StructureBoundingBox par2StructureBoundingBox, Random par3Random, int par4, int par5, int par6, WeightedRandomChestContent[] par7ArrayOfWeightedRandomChestContent, int par8) {
            int k1;
            int j1;
            int i1 = this.func_74865_a(par4, par6);
            if (par2StructureBoundingBox.func_78890_b(i1, j1 = this.func_74862_a(par5), k1 = this.func_74873_b(par4, par6)) && par1World.func_147439_a(i1, j1, k1).func_149688_o() == Material.field_151579_a) {
                int l1 = par3Random.nextBoolean() ? 1 : 0;
                par1World.func_147465_d(i1, j1, k1, Blocks.field_150448_aq, this.func_151555_a(Blocks.field_150448_aq, l1), 2);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(par1World, (double)((float)i1 + 0.5f), (double)((float)j1 + 0.5f), (double)((float)k1 + 0.5f));
                WeightedRandomChestContent.func_76293_a((Random)par3Random, (WeightedRandomChestContent[])par7ArrayOfWeightedRandomChestContent, (IInventory)entityminecartchest, (int)par8);
                par1World.func_72838_d((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int k;
            int j;
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            int i = this.sectionCount * 5 - 1;
            this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, 0, 2, 1, i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            this.func_151551_a(par1World, par3StructureBoundingBox, par2Random, 0.8f, 0, 2, 0, 2, 2, i, Blocks.field_150350_a, Blocks.field_150350_a, false);
            for (j = 0; j < this.sectionCount; ++j) {
                k = 2 + j * 5;
                this.func_151549_a(par1World, par3StructureBoundingBox, 0, 0, k, 0, 1, k, AbyssalCraft.DrTfence, Blocks.field_150350_a, false);
                this.func_151549_a(par1World, par3StructureBoundingBox, 2, 0, k, 2, 1, k, AbyssalCraft.DrTfence, Blocks.field_150350_a, false);
                if (par2Random.nextInt(4) == 0) {
                    this.func_151549_a(par1World, par3StructureBoundingBox, 0, 2, k, 0, 2, k, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
                    this.func_151549_a(par1World, par3StructureBoundingBox, 2, 2, k, 2, 2, k, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
                } else {
                    this.func_151549_a(par1World, par3StructureBoundingBox, 0, 2, k, 2, 2, k, AbyssalCraft.dreadplanks, Blocks.field_150350_a, false);
                }
                this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, k - 1, Blocks.field_150478_aa, 0);
                this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, k + 1, Blocks.field_150478_aa, 0);
                ChestGenHooks info = ChestGenHooks.getInfo((String)"mineshaftCorridor");
                if (par2Random.nextInt(100) == 0) {
                    this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 2, 0, k - 1, mineshaftChestContents, info.getCount(par2Random));
                }
                if (par2Random.nextInt(100) != 0) continue;
                this.func_74879_a(par1World, par3StructureBoundingBox, par2Random, 0, 0, k + 1, mineshaftChestContents, info.getCount(par2Random));
            }
            for (j = 0; j <= 2; ++j) {
                for (k = 0; k <= i; ++k) {
                    int b0 = -1;
                    Block block1 = this.func_151548_a(par1World, j, b0, k, par3StructureBoundingBox);
                    if (block1.func_149688_o() != Material.field_151579_a) continue;
                    int b1 = -1;
                    this.func_151550_a(par1World, AbyssalCraft.dreadplanks, 0, j, b1, k, par3StructureBoundingBox);
                }
            }
            if (this.hasRails) {
                for (j = 0; j <= i; ++j) {
                    Block block = this.func_151548_a(par1World, 1, -1, j, par3StructureBoundingBox);
                    if (block.func_149688_o() == Material.field_151579_a || !block.func_149730_j()) continue;
                    this.func_151552_a(par1World, par3StructureBoundingBox, par2Random, 0.7f, 1, 0, j, Blocks.field_150448_aq, this.func_151555_a(Blocks.field_150448_aq, 0));
                }
            }
            return true;
        }
    }
}

