/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.core;

import com.google.common.collect.ImmutableList;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.shinoow.abyssalcraft.core.ACCorePlugin;
import com.shinoow.abyssalcraft.core.common.CommonProxy;
import com.shinoow.abyssalcraft.core.handlers.CraftingHandler;
import com.shinoow.abyssalcraft.core.util.CoreLogger;
import cpw.mods.fml.client.FMLFileResourcePack;
import cpw.mods.fml.client.FMLFolderResourcePack;
import cpw.mods.fml.common.DummyModContainer;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.LoadController;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.config.Configuration;

public class Core
extends DummyModContainer {
    public static final String version = "1.1.0";
    public static final String modid = "accore";
    public static final String name = "AbyssalCraft Core";
    public static boolean canRenderStarspawn;
    @SidedProxy(clientSide="com.shinoow.abyssalcraft.core.client.ClientProxy", serverSide="com.shinoow.abyssalcraft.core.common.CommonProxy")
    public static CommonProxy proxy;

    public Core() {
        super(new ModMetadata());
        ModMetadata meta = this.getMetadata();
        meta.modId = modid;
        meta.name = name;
        meta.version = version;
        meta.credits = "shinoow (coding)";
        meta.authorList = Arrays.asList("shinoow");
        meta.description = "Library used by AbyssalCraft mods - contains API as well";
        meta.url = "http://adf.ly/FQarm";
        meta.updateUrl = "http://adf.ly/FQarm";
        meta.screenshots = new String[0];
        meta.logoFile = "assets/abyssalcraft/textures/logo_core.png";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void preInit(FMLPreInitializationEvent event) {
        CoreLogger.info("Pre-initializing Core.", new Object[0]);
        FMLCommonHandler.instance().bus().register((Object)new CraftingHandler());
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            canRenderStarspawn = cfg.getBoolean("RenderPlayer Override", "Render", true, "Whether or not to override the player model(set false for compatibility with other mods that alters the player model)");
        }
        catch (Exception e) {
            CoreLogger.severe("AbyssalCraft Core has problems loading Configs.", new Object[0]);
            e.printStackTrace();
        }
        finally {
            cfg.save();
            if (canRenderStarspawn) {
                CoreLogger.info("RenderPlayer Override enabled, the Coralium Longbow will render twice in your hand now.", new Object[0]);
            } else {
                CoreLogger.info("RenderPlayer Override disabled, Compatibility level +100.", new Object[0]);
            }
        }
        proxy.PreInit();
    }

    @Subscribe
    public void Init(FMLInitializationEvent event) {
        CoreLogger.info("Initializing Core.", new Object[0]);
        proxy.Init();
        proxy.registerRenderThings();
    }

    @Subscribe
    public void postInit(FMLPostInitializationEvent event) {
        CoreLogger.info("Post-initializing Core.", new Object[0]);
        proxy.PostInit();
        CoreLogger.info("Core loaded.", new Object[0]);
    }

    public boolean registerBus(EventBus bus, LoadController controller) {
        bus.register((Object)this);
        return true;
    }

    public File getSource() {
        return ACCorePlugin.coreLocation;
    }

    public Class<?> getCustomResourcePackClass() {
        return this.getSource().isDirectory() ? FMLFolderResourcePack.class : FMLFileResourcePack.class;
    }

    public List<String> getOwnedPackages() {
        return ImmutableList.of((Object)"com.shinoow.abyssalcraft.core", (Object)"com.shinoow.abyssalcraft.core.api", (Object)"com.shinoow.abyssalcraft.core.api.addon", (Object)"com.shinoow.abyssalcraft.core.api.entity", (Object)"com.shinoow.abyssalcraft.core.api.item", (Object)"com.shinoow.abyssalcraft.core.api.render", (Object)"com.shinoow.abyssalcraft.core.client", (Object)"com.shinoow.abyssalcraft.core.client.model", (Object)"com.shinoow.abyssalcraft.core.client.render", (Object)"com.shinoow.abyssalcraft.core.common", (Object)"com.shinoow.abyssalcraft.core.handlers", (Object)"com.shinoow.abyssalcraft.core.util", (Object[])new String[]{"com.shinoow.abyssalcraft.core.util.recipes"});
    }
}

