/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.core.util;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.core.util.recipes.CrystallizerRecipes;
import com.shinoow.abyssalcraft.core.util.recipes.TransmutatorRecipes;
import cpw.mods.fml.common.IFuelHandler;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CoreRegistry {
    private static List<IFuelHandler> crystallizerFuelHandlers = Lists.newArrayList();
    private static List<IFuelHandler> transmutatorFuelHandlers = Lists.newArrayList();

    public static void addCrystallization(Block input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output1, output2, xp);
    }

    public static void addCrystallization(Item input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output1, output2, xp);
    }

    public static void addCrystallization(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output1, output2, xp);
    }

    public static void addSingleCrystallization(Block input, ItemStack output, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output, null, xp);
    }

    public static void addSingleCrystallization(Item input, ItemStack output, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output, null, xp);
    }

    public static void addSingleCrystallization(ItemStack input, ItemStack output, float xp) {
        CrystallizerRecipes.crystallization().crystallize(input, output, null, xp);
    }

    public static void addTransmutation(Block input, ItemStack output, float xp) {
        TransmutatorRecipes.transmutation().transmutate(input, output, xp);
    }

    public static void addTransmutation(Item input, ItemStack output, float xp) {
        TransmutatorRecipes.transmutation().transmutate(input, output, xp);
    }

    public static void addTransmutation(ItemStack input, ItemStack output, float xp) {
        TransmutatorRecipes.transmutation().transmutate(input, output, xp);
    }

    public static void registerFuelHandler(IFuelHandler handler, FuelType type) {
        switch (type) {
            case CRYSTALLIZER: {
                crystallizerFuelHandlers.add(handler);
                break;
            }
            case TRANSMUTATOR: {
                transmutatorFuelHandlers.add(handler);
                break;
            }
            case FURNACE: {
                GameRegistry.registerFuelHandler((IFuelHandler)handler);
            }
        }
    }

    public static int getFuelValue(ItemStack itemStack, FuelType type) {
        int fuelValue = 0;
        switch (type) {
            case CRYSTALLIZER: {
                for (IFuelHandler handler : crystallizerFuelHandlers) {
                    fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
                }
                break;
            }
            case TRANSMUTATOR: {
                for (IFuelHandler handler : transmutatorFuelHandlers) {
                    fuelValue = Math.max(fuelValue, handler.getBurnTime(itemStack));
                }
                break;
            }
            case FURNACE: {
                GameRegistry.getFuelValue((ItemStack)itemStack);
            }
        }
        return fuelValue;
    }

    public static enum FuelType {
        CRYSTALLIZER,
        TRANSMUTATOR,
        FURNACE;

    }
}

