/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.core.util.recipes;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrystallizerRecipes {
    private static final CrystallizerRecipes crystallizationBase = new CrystallizerRecipes();
    private Map<ItemStack, ItemStack[]> crystallizationList = new HashMap<ItemStack, ItemStack[]>();
    private Map<ItemStack, Float> experienceList = new HashMap<ItemStack, Float>();

    public static CrystallizerRecipes crystallization() {
        return crystallizationBase;
    }

    private CrystallizerRecipes() {
    }

    public void crystallize(Block input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(Item.func_150898_a((Block)input), output1, output2, xp);
    }

    public void crystallize(Item input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallize(new ItemStack(input, 1, Short.MAX_VALUE), output1, output2, xp);
    }

    public void crystallize(ItemStack input, ItemStack output1, ItemStack output2, float xp) {
        this.crystallizationList.put(input, new ItemStack[]{output1, output2});
        this.experienceList.put(output1, Float.valueOf(xp));
    }

    public ItemStack[] getCrystallizationResult(ItemStack par1ItemStack) {
        Map.Entry<ItemStack, ItemStack[]> entry;
        Iterator<Map.Entry<ItemStack, ItemStack[]>> iterator = this.crystallizationList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.areStacksEqual(par1ItemStack, (entry = iterator.next()).getKey()));
        return entry.getValue();
    }

    private boolean areStacksEqual(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return par2ItemStack.func_77973_b() == par1ItemStack.func_77973_b() && (par2ItemStack.func_77960_j() == Short.MAX_VALUE || par2ItemStack.func_77960_j() == par1ItemStack.func_77960_j());
    }

    public Map<ItemStack, ItemStack[]> getCrystallizationList() {
        return this.crystallizationList;
    }

    public float getExperience(ItemStack par1ItemStack) {
        Map.Entry<ItemStack, Float> entry;
        float ret = par1ItemStack.func_77973_b().getSmeltingExperience(par1ItemStack);
        if (ret != -1.0f) {
            return ret;
        }
        Iterator<Map.Entry<ItemStack, Float>> iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.areStacksEqual(par1ItemStack, (entry = iterator.next()).getKey()));
        return entry.getValue().floatValue();
    }
}

