/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.nei;

import codechicken.nei.ItemList;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.shinoow.abyssalcraft.client.gui.GuiCrystallizer;
import com.shinoow.abyssalcraft.common.blocks.tile.TileEntityCrystallizer;
import com.shinoow.abyssalcraft.core.util.recipes.CrystallizerRecipes;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class CrystallizerRecipeHandler
extends TemplateRecipeHandler {
    public static ArrayList<FuelPair> afuels;
    public static HashSet<Block> efuels;

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(50, 23, 18, 18), "fuel", new Object[0]));
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(74, 23, 24, 18), "smelting", new Object[0]));
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiCrystallizer.class;
    }

    public String getRecipeName() {
        return "Crystallization";
    }

    public TemplateRecipeHandler newInstance() {
        if (afuels == null) {
            CrystallizerRecipeHandler.findFuels();
        }
        return super.newInstance();
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("smelting") && ((Object)((Object)this)).getClass() == CrystallizerRecipeHandler.class) {
            Map<ItemStack, ItemStack[]> recipes = CrystallizerRecipes.crystallization().getCrystallizationList();
            for (Map.Entry<ItemStack, ItemStack[]> recipe : recipes.entrySet()) {
                this.arecipes.add(new SmeltingPair(recipe.getKey(), new ItemStack[]{recipe.getValue()[0], recipe.getValue()[1]}));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        Map<ItemStack, ItemStack[]> recipes = CrystallizerRecipes.crystallization().getCrystallizationList();
        for (Map.Entry<ItemStack, ItemStack[]> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameType((ItemStack)recipe.getValue()[0], (ItemStack)result)) continue;
            this.arecipes.add(new SmeltingPair(recipe.getKey(), new ItemStack[]{recipe.getValue()[0], recipe.getValue()[1]}));
        }
    }

    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        if (inputId.equals("fuel") && ((Object)((Object)this)).getClass() == CrystallizerRecipeHandler.class) {
            this.loadCraftingRecipes("smelting", new Object[0]);
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Map<ItemStack, ItemStack[]> recipes = CrystallizerRecipes.crystallization().getCrystallizationList();
        for (Map.Entry<ItemStack, ItemStack[]> recipe : recipes.entrySet()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)recipe.getKey(), (ItemStack)ingredient)) continue;
            SmeltingPair arecipe = new SmeltingPair(recipe.getKey(), new ItemStack[]{recipe.getValue()[0], recipe.getValue()[1]});
            arecipe.setIngredientPermutation(Arrays.asList(arecipe.ingred), ingredient);
            this.arecipes.add(arecipe);
        }
    }

    public String getGuiTexture() {
        return "abyssalcraft:textures/gui/container/crystallizer.png";
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(51, 25, 176, 0, 14, 14, 48, 7);
        this.drawProgressBar(74, 23, 176, 14, 24, 16, 48, 0);
    }

    private static Set<Item> excludedFuels() {
        HashSet<Item> efuels = new HashSet<Item>();
        efuels.add(Item.func_150898_a((Block)Blocks.field_150338_P));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150337_Q));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150472_an));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150444_as));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150466_ao));
        efuels.add(Item.func_150898_a((Block)Blocks.field_150447_bR));
        return efuels;
    }

    private static void findFuels() {
        afuels = new ArrayList();
        Set<Item> efuels = CrystallizerRecipeHandler.excludedFuels();
        for (ItemStack item : ItemList.items) {
            int burnTime;
            if (efuels.contains(item.func_77973_b()) || (burnTime = TileEntityCrystallizer.getCrystallizationTime(item)) <= 0) continue;
            afuels.add(new FuelPair(item.func_77946_l(), burnTime));
        }
    }

    public String getOverlayIdentifier() {
        return "smelting";
    }

    public static class FuelPair {
        public PositionedStack stack;
        public int burnTime;

        public FuelPair(ItemStack ingred, int burnTime) {
            this.stack = new PositionedStack((Object)ingred, 51, 42, false);
            this.burnTime = burnTime;
        }
    }

    public class SmeltingPair
    extends TemplateRecipeHandler.CachedRecipe {
        PositionedStack ingred;
        PositionedStack result;
        PositionedStack result2;

        public SmeltingPair(ItemStack ingred, ItemStack[] itemStacks) {
            super((TemplateRecipeHandler)CrystallizerRecipeHandler.this);
            ingred.field_77994_a = 1;
            this.ingred = new PositionedStack((Object)ingred, 51, 6);
            this.result = new PositionedStack((Object)new ItemStack[]{itemStacks[0]}, 111, 24);
            this.result2 = new PositionedStack((Object)new ItemStack[]{itemStacks[1]}, 128, 24);
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(CrystallizerRecipeHandler.this.cycleticks / 48, Arrays.asList(this.ingred));
        }

        public PositionedStack getResult() {
            return this.result;
        }

        public PositionedStack getOtherStack() {
            return CrystallizerRecipeHandler.afuels.get((int)(CrystallizerRecipeHandler.this.cycleticks / 48 % CrystallizerRecipeHandler.afuels.size())).stack;
        }
    }
}

