/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.air;

import java.util.Iterator;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import kieranvs.avatar.bending.Ability;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;

public class AirUnrelentingWind
extends Ability {
    private Vector direction;
    private Location origin;
    private Location location;
    private int range;
    private int strength;
    private long lifetime;
    private long time;
    private long interval = 20L;
    private boolean isSneaking = false;
    private boolean keepMoving = true;
    private ConcurrentHashMap<Location, Long> windBlocks = new ConcurrentHashMap();

    public AirUnrelentingWind(EntityLivingBase user, Location location, Vector direction, int range, int strength, long lifetime) {
        super(user);
        this.direction = direction;
        this.origin = location.clone();
        this.location = location.clone();
        this.range = range;
        this.strength = strength / 5;
        this.lifetime = lifetime + System.currentTimeMillis();
        this.time = System.currentTimeMillis();
        if (!(user instanceof EntityPlayer)) {
            this.isSneaking = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void update() {
        if (this.location.distance(this.origin) > (double)this.range) {
            this.keepMoving = false;
        }
        if (System.currentTimeMillis() > this.lifetime) {
            this.isSneaking = false;
            this.windBlocks.clear();
            this.destroy();
            return;
        }
        if (this.keepMoving) {
            if (System.currentTimeMillis() <= this.time + this.interval) return;
            if (!this.user.func_70093_af() && !this.isSneaking) {
                this.windBlocks.clear();
                this.destroy();
                return;
            }
            Random random = new Random(5L);
            PacketSender.spawnParticle("Avatar_cloud", this.location.getWorld(), this.location.getX() + random.nextGaussian(), this.location.getY() + random.nextGaussian(), this.location.getZ() + random.nextGaussian(), 1, 0.6);
            BendingUtils.repelEntitiesOnYourLevelAndAbove(this.user, this.location, this.range);
            this.windBlocks.put(this.location, System.currentTimeMillis());
            this.location.add(this.direction);
            return;
        }
        if (System.currentTimeMillis() <= this.time + this.interval) return;
        if (!this.user.func_70093_af() && !this.isSneaking) {
            this.windBlocks.clear();
            this.destroy();
            return;
        }
        Random rand = new Random(6L);
        Iterator i$ = this.windBlocks.keySet().iterator();
        while (i$.hasNext()) {
            Location l = (Location)i$.next();
            PacketSender.spawnParticle("Avatar_cloud", l.getWorld(), l.getX() + rand.nextGaussian(), l.getY() + rand.nextGaussian(), l.getZ() + rand.nextGaussian(), 1, 1.0);
            BendingUtils.repelEntitiesOnYourLevelAndAbove(this.user, l, this.range);
        }
    }

    @Override
    public String getName() {
        return "Hold shift to blow an almighty gale, pushing all entities back.";
    }
}

