/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import java.util.ArrayList;
import java.util.Random;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.util.Messaging;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthOreSense
extends AsynchronousAbility {
    private EntityPlayer player;
    private long time;
    private int level;
    private Random r = new Random();

    public EarthOreSense(EntityLivingBase e, int level) {
        super(e, 1000L);
        int ironCount;
        int goldCount;
        int diamondCount;
        if (e instanceof EntityPlayer) {
            this.player = (EntityPlayer)e;
        }
        this.time = System.currentTimeMillis();
        this.level = level;
        int radius = level * 3;
        Location loc = new Location((Entity)e);
        ArrayList<BlockBukkit> loot = new ArrayList<BlockBukkit>();
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                for (int k = -radius; k <= radius; ++k) {
                    BlockBukkit b = loc.getBlock().getRelative(BlockBukkit.DOWN, i).getRelative(BlockBukkit.EAST, j).getRelative(BlockBukkit.NORTH, k);
                    if (b.getType() != Blocks.field_150482_ag && b.getType() != Blocks.field_150366_p && b.getType() != Blocks.field_150450_ax && b.getType() != Blocks.field_150352_o && b.getType() != Blocks.field_150369_x && b.getType() != Blocks.field_150412_bA && b.getType() != Blocks.field_150365_q) continue;
                    loot.add(b);
                }
            }
        }
        if (level == 1) {
            Messaging.avatarMessage(this.player, "Found " + loot.size() + " ores within " + radius + " blocks.");
            this.destroy();
            return;
        }
        if (level == 2) {
            Messaging.avatarMessage(this.player, "Found " + loot.size() + " ores within " + radius + " blocks.");
            diamondCount = 0;
            goldCount = 0;
            ironCount = 0;
            int redstoneCount = 0;
            int lapisCount = 0;
            int emeraldCount = 0;
            int coalCount = 0;
            for (int i = 0; i < loot.size(); ++i) {
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150482_ag) {
                    ++diamondCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150352_o) {
                    ++goldCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150366_p) {
                    ++ironCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150450_ax) {
                    ++redstoneCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150369_x) {
                    ++lapisCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150412_bA) {
                    ++emeraldCount;
                }
                if (((BlockBukkit)loot.get(i)).getType() != Blocks.field_150365_q) continue;
                ++coalCount;
            }
            if (diamondCount > 0) {
                Messaging.avatarMessage(this.player, diamondCount + " diamond ore.");
            }
            if (goldCount > 0) {
                Messaging.avatarMessage(this.player, goldCount + " gold ore.");
            }
            if (ironCount > 0) {
                Messaging.avatarMessage(this.player, ironCount + " iron ore.");
            }
            if (redstoneCount > 0) {
                Messaging.avatarMessage(this.player, redstoneCount + " redstone ore.");
            }
            if (lapisCount > 0) {
                Messaging.avatarMessage(this.player, lapisCount + " lapis lazuli ore.");
            }
            if (emeraldCount > 0) {
                Messaging.avatarMessage(this.player, emeraldCount + " emerald ore.");
            }
            if (coalCount > 0) {
                Messaging.avatarMessage(this.player, coalCount + " coal.");
            }
            this.destroy();
            return;
        }
        if (level == 3) {
            Messaging.avatarMessage(this.player, "Found " + loot.size() + " ores within " + radius + " blocks.");
            diamondCount = 0;
            goldCount = 0;
            ironCount = 0;
            int redstoneCount = 0;
            int lapisCount = 0;
            int emeraldCount = 0;
            int coalCount = 0;
            double diamondDistance = 0.0;
            double goldDistance = 0.0;
            double ironDistance = 0.0;
            double redstoneDistance = 0.0;
            double lapisDistance = 0.0;
            double emeraldDistance = 0.0;
            double coalDistance = 0.0;
            Location playerLoc = new Location((Entity)this.user);
            for (int i = 0; i < loot.size(); ++i) {
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150482_ag) {
                    ++diamondCount;
                    if (diamondDistance == 0.0 || diamondDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        diamondDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150352_o) {
                    ++goldCount;
                    if (goldDistance == 0.0 || goldDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        goldDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150366_p) {
                    ++ironCount;
                    if (ironDistance == 0.0 || ironDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        ironDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150450_ax) {
                    ++redstoneCount;
                    if (redstoneDistance == 0.0 || redstoneDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        redstoneDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150369_x) {
                    ++lapisCount;
                    if (lapisDistance == 0.0 || lapisDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        lapisDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() == Blocks.field_150412_bA) {
                    ++emeraldCount;
                    if (emeraldDistance == 0.0 || emeraldDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation())) {
                        emeraldDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
                    }
                }
                if (((BlockBukkit)loot.get(i)).getType() != Blocks.field_150365_q) continue;
                ++coalCount;
                if (coalDistance != 0.0 && !(coalDistance > playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation()))) continue;
                coalDistance = playerLoc.distance(((BlockBukkit)loot.get(i)).getLocation());
            }
            if (diamondCount > 0) {
                Messaging.avatarMessage(this.player, diamondCount + " diamond ore. You sense one " + (double)Math.round(diamondDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (goldCount > 0) {
                Messaging.avatarMessage(this.player, goldCount + " gold ore. You sense one " + (double)Math.round(goldDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (ironCount > 0) {
                Messaging.avatarMessage(this.player, ironCount + " iron ore. You sense one " + (double)Math.round(ironDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (redstoneCount > 0) {
                Messaging.avatarMessage(this.player, redstoneCount + " redstone ore. You sense one " + (double)Math.round(redstoneDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (lapisCount > 0) {
                Messaging.avatarMessage(this.player, lapisCount + " lapis lazuli ore. You sense one " + (double)Math.round(lapisDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (emeraldCount > 0) {
                Messaging.avatarMessage(this.player, emeraldCount + " emerald ore. You sense one " + (double)Math.round(emeraldDistance * 100.0) / 100.0 + " blocks away.");
            }
            if (coalCount > 0) {
                Messaging.avatarMessage(this.player, coalCount + " coal. You sense one " + (double)Math.round(coalDistance * 100.0) / 100.0 + " blocks away.");
            }
            this.destroy();
            return;
        }
    }

    @Override
    public void update() {
        if (this.player == null) {
            this.destroy();
            return;
        }
    }

    @Override
    public String getName() {
        return "Ore Sense";
    }
}

