/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.earth;

import kieranvs.avatar.Protection;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.entity.EntityBlock;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;

public class EarthRaiseBlock
extends AsynchronousAbility {
    private Location location;
    private EntityLivingBase user;
    private long time = System.currentTimeMillis();
    private long interval = 50L;
    private static int cooldown = 500;
    private int counter = 0;
    private int range = 5;
    private EntityBlock blockEntity;
    private Block blockType;
    private int metadata;

    public EarthRaiseBlock(EntityLivingBase user, Location location, int level) {
        super(user, cooldown + level * 1500);
        this.user = user;
        this.location = location;
        switch (level) {
            case 0: {
                this.range = 3;
                break;
            }
            case 1: {
                this.range = 6;
                break;
            }
            case 2: {
                this.range = 12;
            }
        }
        if (!BendingUtils.isEarthBendable(location.getBlock().getType()) || location.getBlock().getType() == Blocks.field_150350_a) {
            Messaging.avatarMessage((EntityPlayer)user, "Not an Earth bendable block!");
            this.destroy();
            return;
        }
        Block m = location.getBlock().getType();
        if (BendingUtils.isEarthBendable(m)) {
            this.blockType = Blocks.field_150348_b;
        }
        if (m == Blocks.field_150346_d || m == Blocks.field_150349_c) {
            this.blockType = Blocks.field_150346_d;
        }
        if (m == Blocks.field_150354_m || m == Blocks.field_150322_A) {
            this.blockType = Blocks.field_150322_A;
        }
        if (m == Blocks.field_150406_ce || m == Blocks.field_150405_ch || m == Blocks.field_150435_aG || m == Blocks.field_150351_n) {
            this.blockType = m;
            this.metadata = location.getWorld().func_72805_g(location.getBlockX(), location.getBlockY(), location.getBlockZ());
        }
        this.blockEntity = new EntityBlock(user.field_70170_p, (double)location.getBlockX() + 0.5, (double)location.getBlockY() + 0.5, (double)location.getBlockZ() + 0.5, this.blockType);
        user.field_70170_p.func_72838_d((Entity)this.blockEntity);
        this.blockEntity.setOwner((Entity)user);
        Protection.trySetBlock(user.field_70170_p, Blocks.field_150350_a, location.getBlock().getX(), location.getBlock().getY(), location.getBlock().getZ());
    }

    @Override
    public void update() {
        if (this.blockEntity != null) {
            if (this.user.func_70093_af()) {
                Location l = new Location(this.user.field_70170_p, this.user.field_70165_t, this.user.field_70163_u, this.user.field_70161_v);
                Location userL = new Location((Entity)this.user);
                Vector d = userL.getDirection();
                d.normalize();
                d.multiply(3.5);
                l.add(d);
                this.blockEntity.func_70107_b(l.getX(), l.getY(), l.getZ());
            } else {
                this.blockEntity.func_70106_y();
                this.destroy();
            }
        } else {
            this.destroy();
            return;
        }
    }

    @Override
    public String getName() {
        return "Raise Block";
    }
}

