/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.S3FPacketCustomPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.biome.BiomeGenBase;

public class FireFlight
extends AsynchronousAbility {
    private long starttime;
    private int flightTime;
    private double flightSpeed;
    private static int cooldown = 18000;
    long soundTime = 1500L;
    long startTime = System.currentTimeMillis();

    public FireFlight(EntityLivingBase user, int level) {
        super(user, cooldown + level * 5000);
        this.user = user;
        this.starttime = System.currentTimeMillis();
        if (level == 0) {
            this.flightTime = 1700;
            this.flightSpeed = 0.8;
        }
        if (level == 1) {
            this.flightTime = 3000;
            this.flightSpeed = 1.0;
        }
        if (level == 2) {
            this.flightTime = 5000;
            this.flightSpeed = 1.3;
        }
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        try {
            pb.writeInt("ContinueSound".getBytes().length);
            pb.writeBytes("ContinueSound".getBytes());
            pb.writeInt("kieranvs_avatar:fire06looping".getBytes().length);
            pb.writeBytes("kieranvs_avatar:fire06looping".getBytes());
            pb.writeInt(user.func_110124_au().toString().getBytes().length);
            pb.writeBytes(user.func_110124_au().toString().getBytes());
            pb.writeBoolean(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarBend", (ByteBuf)pb);
        MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() - this.starttime > (long)this.flightTime || !this.isOverLand()) {
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt("ContinueSound".getBytes().length);
                pb.writeBytes("ContinueSound".getBytes());
                pb.writeInt("kieranvs_avatar:fire06looping".getBytes().length);
                pb.writeBytes("kieranvs_avatar:fire06looping".getBytes());
                pb.writeInt(this.user.func_110124_au().toString().getBytes().length);
                pb.writeBytes(this.user.func_110124_au().toString().getBytes());
                pb.writeBoolean(false);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarBend", (ByteBuf)pb);
            MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
            this.destroy();
            return;
        }
        Location l = new Location((Entity)this.user);
        if (System.currentTimeMillis() - this.startTime > this.soundTime) {
            this.startTime = System.currentTimeMillis();
            PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
            try {
                pb.writeInt("ContinueSound".getBytes().length);
                pb.writeBytes("ContinueSound".getBytes());
                pb.writeInt("kieranvs_avatar:fire06looping".getBytes().length);
                pb.writeBytes("kieranvs_avatar:fire06looping".getBytes());
                pb.writeInt(this.user.func_110124_au().toString().getBytes().length);
                pb.writeBytes(this.user.func_110124_au().toString().getBytes());
                pb.writeBoolean(true);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            S3FPacketCustomPayload packet = new S3FPacketCustomPayload("AvatarBend", (ByteBuf)pb);
            MinecraftServer.func_71276_C().func_71203_ab().func_148540_a((Packet)packet);
        }
        PacketSender.spawnParticle("Avatar_flamesbig", l.getWorld(), l.getX(), l.getY(), l.getZ());
        Vector v = new Vector(this.user.func_70040_Z().field_72450_a, this.user.func_70040_Z().field_72448_b, this.user.func_70040_Z().field_72449_c);
        v.normalize();
        v.multiply(this.flightSpeed);
        v.setY(v.getY() + (double)0.6f);
        PacketSender.sendVelocity((Entity)this.user, v);
    }

    public boolean isOverLand() {
        if (this.user.field_70170_p.func_72896_J() && this.user.field_70170_p.func_72807_a((int)this.user.field_70165_t, (int)this.user.field_70161_v) != BiomeGenBase.field_76769_d && this.user.field_70170_p.func_72807_a((int)this.user.field_70165_t, (int)this.user.field_70161_v) != BiomeGenBase.field_76786_s && this.user.field_70170_p.func_72807_a((int)this.user.field_70165_t, (int)this.user.field_70161_v) != BiomeGenBase.field_150589_Z && this.user.field_70170_p.func_72807_a((int)this.user.field_70165_t, (int)this.user.field_70161_v) != BiomeGenBase.field_150608_ab && this.user.field_70170_p.func_72807_a((int)this.user.field_70165_t, (int)this.user.field_70161_v) != BiomeGenBase.field_150607_aa) {
            if (this.user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "You can't fly when it's raining!");
            }
            return false;
        }
        boolean isGround = false;
        BlockBukkit b = new Location((Entity)this.user).getBlock();
        while (!isGround) {
            if (b.getType() == Blocks.field_150350_a) {
                b = b.getRelative(BlockBukkit.DOWN);
                continue;
            }
            if (b.getType() == Blocks.field_150355_j || b.getType() == Blocks.field_150432_aD || b.getType() == Blocks.field_150433_aE || b.getType() == Blocks.field_150355_j || b.getType() == Blocks.field_150355_j) {
                if (this.user instanceof EntityPlayer) {
                    Messaging.avatarMessage((EntityPlayer)this.user, "You can't fly over water!");
                }
                return false;
            }
            return true;
        }
        if (this.user instanceof EntityPlayer) {
            Messaging.avatarMessage((EntityPlayer)this.user, "You can't fly over water!");
        }
        return false;
    }

    @Override
    public String getName() {
        return "Flight";
    }
}

