/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.fire;

import java.util.concurrent.ConcurrentHashMap;
import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;

public class FireJet
extends AsynchronousAbility {
    private static float speed = 10.0f;
    private static long interval = (long)(1000.0f / speed);
    private ConcurrentHashMap<BlockBukkit, Long> onFire = new ConcurrentHashMap();
    private Location origin;
    private Location location;
    private Vector direction;
    private float range;
    private long time;
    private BlockBukkit previous;
    private int damage;
    private boolean finished = false;
    private boolean firstblock = true;

    public FireJet(EntityLivingBase user, Location location, Vector direction, int level) {
        super(user, 5000 + level * 4000);
        this.user = user;
        this.time = System.currentTimeMillis();
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.normalize();
        this.location.add(this.direction);
        if (level == 0) {
            this.range = 7.0f;
            this.damage = 1;
        }
        if (level == 1) {
            this.range = 14.0f;
            this.damage = 2;
        }
        if (level == 2) {
            this.range = 20.0f;
            this.damage = 4;
        }
    }

    @Override
    public void update() {
        if (this.firstblock) {
            this.location.add(this.direction);
            this.firstblock = false;
        }
        for (BlockBukkit block : this.onFire.keySet()) {
            PacketSender.spawnParticle("Avatar_flamesjet", this.location.getWorld(), block.getLocation().getX(), block.getLocation().getY(), block.getLocation().getZ());
            long time = this.onFire.get(block);
            if (System.currentTimeMillis() <= time + 400L) continue;
            this.onFire.remove(block);
        }
        if (this.finished) {
            if (this.onFire.isEmpty()) {
                this.destroy();
            } else {
                return;
            }
        }
        if (System.currentTimeMillis() - this.time >= interval) {
            this.time = System.currentTimeMillis();
            this.location.add(this.direction);
            if (this.location.distance(this.origin) > (double)this.range) {
                this.finished = true;
                return;
            }
            BlockBukkit block = this.location.getBlock();
            if (block.getType() != Blocks.field_150350_a) {
                this.finished = true;
                if (this.previous != null) {
                    this.previous.setTypeWithProtection((Block)Blocks.field_150480_ab);
                }
                return;
            }
            PacketSender.spawnParticle("Avatar_flames", this.location.getWorld(), block.getLocation().getX(), block.getLocation().getY(), block.getLocation().getZ());
            this.previous = block;
            this.onFire.put(block, System.currentTimeMillis());
            BendingUtils.damageEntities(this.user, block.getLocation(), 2.0f, AvatarDamageSource.firebending, this.damage);
            return;
        }
    }

    public void damageEntities(Location loc) {
        for (Object o : loc.getWorld().func_72910_y()) {
            EntityLivingBase e;
            if (!(o instanceof EntityLivingBase) || !(loc.distance((Entity)(e = (EntityLivingBase)o)) < 3.5)) continue;
            e.func_70097_a((DamageSource)AvatarDamageSource.firebending, 3.0f);
        }
    }

    @Override
    public String getName() {
        return "FireJet";
    }
}

