/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.bending.water;

import kieranvs.avatar.bending.AsynchronousAbility;
import kieranvs.avatar.bukkit.BlockBukkit;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.AvatarDamageSource;
import kieranvs.avatar.util.BendingUtils;
import kieranvs.avatar.util.Messaging;
import kieranvs.avatar.util.PacketSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.util.DamageSource;

public class WaterIceStream
extends AsynchronousAbility {
    private long interval = 20L;
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time = System.currentTimeMillis();
    private int damage;
    private static int cooldown = 3000;

    public WaterIceStream(EntityLivingBase user, Location location, Vector direction, int range, int damage) {
        super(user, cooldown);
        this.range = range;
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.setY(0);
        this.direction.normalize();
        this.location.add(this.direction);
        this.damage = damage;
        if (!this.isWaterNearby(new Location((Entity)user))) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "No water nearby!");
            }
            this.destroy();
            return;
        }
    }

    public WaterIceStream(EntityLivingBase user, Location location, Vector direction, int level) {
        super(user, cooldown + level * 3000);
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        this.direction.normalize();
        this.location.add(this.direction);
        if (!this.isWaterNearby(new Location((Entity)user))) {
            if (user instanceof EntityPlayer) {
                Messaging.avatarMessage((EntityPlayer)this.user, "No water nearby!");
            }
            this.destroy();
            return;
        }
        if (level == 0) {
            this.damage = 1;
            this.range = 7;
        }
        if (level == 1) {
            this.damage = 2;
            this.range = 15;
        }
        if (level == 2) {
            this.damage = 4;
            this.range = 20;
        }
    }

    @Override
    public void update() {
        if (System.currentTimeMillis() > this.time + this.interval) {
            this.time = System.currentTimeMillis();
            this.location.add(this.direction);
            if (this.location.distance(this.origin) > (double)this.range) {
                this.destroy();
                return;
            }
            if (this.location.getBlock().getType() == Blocks.field_150350_a || this.location.getBlock().getType() == Blocks.field_150432_aD || this.location.getBlock().getType() == Blocks.field_150355_j) {
                this.location.getBlock().setTypeWithProtection(Blocks.field_150432_aD);
                BendingUtils.damageEntities(this.user, this.location, 1.0f, AvatarDamageSource.waterbending, this.damage);
                PacketSender.spawnParticle("Avatar_watersplash", this.location.getWorld(), this.location.getX(), this.location.getY(), this.location.getZ());
                if (this.location.getBlock().getRelative(BlockBukkit.UP).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.UP).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.UP).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.UP).setTypeWithProtection(Blocks.field_150432_aD);
                }
                if (this.location.getBlock().getRelative(BlockBukkit.DOWN).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.DOWN).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.DOWN).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.DOWN).setTypeWithProtection(Blocks.field_150432_aD);
                }
                if (this.location.getBlock().getRelative(BlockBukkit.NORTH).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.NORTH).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.NORTH).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.NORTH).setTypeWithProtection(Blocks.field_150432_aD);
                }
                if (this.location.getBlock().getRelative(BlockBukkit.EAST).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.EAST).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.EAST).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.EAST).setTypeWithProtection(Blocks.field_150432_aD);
                }
                if (this.location.getBlock().getRelative(BlockBukkit.SOUTH).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.SOUTH).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.SOUTH).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.SOUTH).setTypeWithProtection(Blocks.field_150432_aD);
                }
                if (this.location.getBlock().getRelative(BlockBukkit.WEST).getType() == Blocks.field_150350_a || this.location.getBlock().getRelative(BlockBukkit.WEST).getType() == Blocks.field_150355_j || this.location.getBlock().getRelative(BlockBukkit.WEST).getType() == Blocks.field_150358_i) {
                    this.location.getBlock().getRelative(BlockBukkit.WEST).setTypeWithProtection(Blocks.field_150432_aD);
                }
            }
        }
    }

    public boolean isWaterNearby(Location l) {
        for (int i = -2; i < 3; ++i) {
            for (int j = -2; j < 3; ++j) {
                if (!BendingUtils.isWaterBendable(l.getBlock().getRelative(BlockBukkit.DOWN, 2).getRelative(BlockBukkit.EAST, i).getRelative(BlockBukkit.NORTH, j).getType()) && !BendingUtils.isWaterBendable(l.getBlock().getRelative(BlockBukkit.DOWN).getRelative(BlockBukkit.EAST, i).getRelative(BlockBukkit.NORTH, j).getType()) && !BendingUtils.isWaterBendable(l.getBlock().getRelative(BlockBukkit.EAST, i).getRelative(BlockBukkit.NORTH, j).getType())) continue;
                return true;
            }
        }
        return false;
    }

    public void damageEntities(Location loc) {
        for (Object o : loc.getWorld().func_72910_y()) {
            EntityLivingBase e;
            if (!(o instanceof EntityLivingBase) || !(loc.distance((Entity)(e = (EntityLivingBase)o)) < 3.5)) continue;
            e.func_70097_a(DamageSource.field_76369_e, (float)this.damage);
        }
    }

    @Override
    public String getName() {
        return "Ice Stream";
    }
}

