/*
 * Decompiled with CFR 0.152.
 */
package kieranvs.avatar.util;

import kieranvs.avatar.bending.Ability;
import kieranvs.avatar.bukkit.Location;
import kieranvs.avatar.bukkit.Vector;
import kieranvs.avatar.util.BlockActionPerformer;
import net.minecraft.entity.EntityLivingBase;

public class GenericProgressor
extends Ability {
    private int interval = 20;
    private Location origin;
    private Location location;
    private Vector direction;
    private int range;
    private long time = System.currentTimeMillis();
    private BlockActionPerformer action;

    public GenericProgressor(EntityLivingBase entity, Location location, Vector direction, int range, boolean flat, BlockActionPerformer action) {
        super(entity);
        this.range = range;
        this.origin = location.clone();
        this.location = location.clone();
        this.direction = direction.clone();
        if (flat) {
            this.direction.setY(0);
        }
        this.direction.normalize();
        this.location.add(this.direction);
        this.action = action;
    }

    @Override
    public void update() {
        if (this.location.distance(this.origin) > (double)this.range) {
            this.destroy();
            return;
        }
        if (System.currentTimeMillis() > this.time + (long)this.interval) {
            this.time = System.currentTimeMillis();
            this.action.performAction(this.location.getBlock());
            this.location.add(this.direction);
        }
    }

    @Override
    public String getName() {
        return "";
    }
}

