/*
 * Decompiled with CFR 0.152.
 */
package robomuss.rc.network.packets;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import robomuss.rc.block.RCBlocks;
import robomuss.rc.block.te.TileEntityTrackFabricator;
import robomuss.rc.network.AbstractPacket;

public class PacketTrackFabricatorUpdate
extends AbstractPacket {
    private int x;
    private int y;
    private int z;
    private int amount;
    private int current_track;

    public PacketTrackFabricatorUpdate() {
    }

    public PacketTrackFabricatorUpdate(int x, int y, int z, int amount, int current_track) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.amount = amount;
        this.current_track = current_track;
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeInt(this.amount);
        buffer.writeInt(this.current_track);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf buffer) {
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.amount = buffer.readInt();
        this.current_track = buffer.readInt();
    }

    @Override
    public void handleClientSide(EntityPlayer player) {
    }

    @Override
    public void handleServerSide(EntityPlayer player) {
        World world = player.field_70170_p;
        TileEntityTrackFabricator te = (TileEntityTrackFabricator)world.func_147438_o(this.x, this.y, this.z);
        int cost = RCBlocks.tracks.get((int)this.current_track).crafting_cost * this.amount;
        if (te.contents[0] != null && te.contents[0].func_77973_b() == Items.field_151042_j && te.contents[0].field_77994_a >= cost) {
            if (te.contents[1] == null) {
                te.contents[0].field_77994_a -= cost;
                if (te.contents[0].field_77994_a <= 0) {
                    te.contents[0] = null;
                }
                te.contents[1] = new ItemStack(RCBlocks.tracks.get((int)this.current_track).block, this.amount);
            } else if (te.contents[1].func_77973_b() == Item.func_150898_a((Block)RCBlocks.tracks.get((int)this.current_track).block) && te.contents[1].field_77994_a + this.amount <= 64) {
                te.contents[0].field_77994_a -= cost;
                if (te.contents[0].field_77994_a <= 0) {
                    te.contents[0] = null;
                }
                te.contents[1].field_77994_a += this.amount;
            }
        }
    }
}

