/*
 * Decompiled with CFR 0.152.
 */
package ichun.client.model;

import cpw.mods.fml.relauncher.ReflectionHelper;
import ichun.common.core.util.ObfHelper;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelBox;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.entity.RendererLivingEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;

public class ModelHelper {
    public static Random rand = new Random();
    public static HashMap<Class<? extends EntityLivingBase>, ArrayList<ModelRenderer>> classToModelRendererMap = new HashMap();

    public static ArrayList<ModelRenderer> getModelCubesCopy(ArrayList<ModelRenderer> modelList, ModelBase base, EntityLivingBase ent) {
        if (RenderManager.field_78727_a.field_78724_e != null && RenderManager.field_78727_a.field_78734_h != null && ent != null) {
            for (int i = 0; i < modelList.size(); ++i) {
                ModelRenderer cube = modelList.get(i);
                if (!cube.field_78812_q) continue;
                GLAllocation.func_74523_b((int)cube.field_78811_r);
                cube.field_78812_q = false;
            }
            RenderManager.field_78727_a.func_78713_a((Entity)ent).func_76986_a((Entity)ent, 0.0, -500.0, 0.0, 0.0f, 1.0f);
            ArrayList<ModelRenderer> modelListCopy = new ArrayList<ModelRenderer>(modelList);
            ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
            for (int i = modelListCopy.size() - 1; i >= 0; --i) {
                ModelRenderer cube = modelListCopy.get(i);
                try {
                    if (cube.field_78812_q) continue;
                    modelListCopy.remove(i);
                    continue;
                }
                catch (Exception e) {
                    ObfHelper.obfWarning();
                    e.printStackTrace();
                }
            }
            for (ModelRenderer cube : modelListCopy) {
                list.add(ModelHelper.buildCopy(cube, base, 0, true, true));
            }
            return list;
        }
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (int i = 0; i < modelList.size(); ++i) {
            ModelRenderer cube = modelList.get(i);
            list.add(ModelHelper.buildCopy(cube, base, 0, true, true));
        }
        return list;
    }

    public static ModelRenderer buildCopy(ModelRenderer original, ModelBase copyBase, int depth, boolean hasFullModelBox, boolean exactDupe) {
        int txOffsetX = original.field_78803_o;
        int txOffsetY = original.field_78813_p;
        ModelRenderer cubeCopy = new ModelRenderer(copyBase, txOffsetX, txOffsetY);
        cubeCopy.field_78809_i = original.field_78809_i;
        cubeCopy.field_78799_b = original.field_78799_b;
        cubeCopy.field_78801_a = original.field_78801_a;
        for (int j = 0; j < original.field_78804_l.size(); ++j) {
            ModelBox box = (ModelBox)original.field_78804_l.get(j);
            float param7 = 0.0f;
            if (exactDupe) {
                ModelBox boxCopy = new ModelBox(cubeCopy, txOffsetX, txOffsetY, box.field_78252_a, box.field_78250_b, box.field_78251_c, (int)Math.abs(box.field_78248_d - box.field_78252_a), (int)Math.abs(box.field_78249_e - box.field_78250_b), (int)Math.abs(box.field_78246_f - box.field_78251_c), 0.0f);
                boxCopy.field_78254_i = box.field_78254_i;
                cubeCopy.field_78804_l.add(boxCopy);
                continue;
            }
            if (hasFullModelBox) {
                cubeCopy.func_78789_a(box.field_78252_a, box.field_78250_b, box.field_78251_c, (int)Math.abs(box.field_78248_d - box.field_78252_a), (int)Math.abs(box.field_78249_e - box.field_78250_b), (int)Math.abs(box.field_78246_f - box.field_78251_c));
                continue;
            }
            ModelBox randBox = (ModelBox)original.field_78804_l.get(rand.nextInt(original.field_78804_l.size()));
            float x = randBox.field_78252_a + (randBox.field_78248_d - randBox.field_78252_a > 0.0f ? (float)rand.nextInt((int)(randBox.field_78248_d - randBox.field_78252_a) > 0 ? (int)(randBox.field_78248_d - randBox.field_78252_a) : 1) : 0.0f);
            float y = randBox.field_78250_b + (randBox.field_78249_e - randBox.field_78250_b > 0.0f ? (float)rand.nextInt((int)(randBox.field_78249_e - randBox.field_78250_b) > 0 ? (int)(randBox.field_78249_e - randBox.field_78250_b) : 1) : 0.0f);
            float z = randBox.field_78251_c + (randBox.field_78246_f - randBox.field_78251_c > 0.0f ? (float)rand.nextInt((int)(randBox.field_78246_f - randBox.field_78251_c) > 0 ? (int)(randBox.field_78246_f - randBox.field_78251_c) : 1) : 0.0f);
            cubeCopy.func_78789_a(x, y, z, (int)Math.abs(box.field_78248_d - box.field_78252_a), (int)Math.abs(box.field_78249_e - box.field_78250_b), (int)Math.abs(box.field_78246_f - box.field_78251_c));
        }
        if (original.field_78805_m != null && depth < 20) {
            for (int i = 0; i < original.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)original.field_78805_m.get(i);
                cubeCopy.func_78792_a(ModelHelper.buildCopy(child, copyBase, depth + 1, hasFullModelBox, exactDupe));
            }
        }
        cubeCopy.func_78793_a(original.field_78800_c, original.field_78797_d, original.field_78798_e);
        cubeCopy.field_78795_f = original.field_78795_f;
        cubeCopy.field_78796_g = original.field_78796_g;
        cubeCopy.field_78808_h = original.field_78808_h;
        return cubeCopy;
    }

    public static ArrayList<ModelRenderer> getModelCubes(ModelBase parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        ArrayList<ModelRenderer> list1 = new ArrayList<ModelRenderer>();
        if (parent != null) {
            for (Class<?> clz = parent.getClass(); clz != ModelBase.class && ModelBase.class.isAssignableFrom(clz); clz = clz.getSuperclass()) {
                try {
                    Field[] fields;
                    for (Field field : fields = clz.getDeclaredFields()) {
                        ModelRenderer rend;
                        field.setAccessible(true);
                        if (field.getType() == ModelRenderer.class) {
                            if ((clz != ModelBiped.class || field.getName().equalsIgnoreCase("bipedCloak") || field.getName().equalsIgnoreCase("k") || field.getName().equalsIgnoreCase("field_78122_k")) && clz == ModelBiped.class || (rend = (ModelRenderer)field.get(parent)) == null) continue;
                            list.add(rend);
                            continue;
                        }
                        if (field.getType() != ModelRenderer[].class || (rend = (ModelRenderer)field.get(parent)) == null) continue;
                        list1.add(rend);
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
                }
            }
        }
        Iterator i$ = list1.iterator();
        while (i$.hasNext()) {
            ModelRenderer[] cubes;
            for (ModelRenderer modelRenderer : cubes = (ModelRenderer[])i$.next()) {
                if (modelRenderer == null || list.contains(modelRenderer)) continue;
                list.add(modelRenderer);
            }
        }
        ArrayList<ModelRenderer> children = new ArrayList<ModelRenderer>();
        for (ModelRenderer modelRenderer : list) {
            for (ModelRenderer child : ModelHelper.getChildren(modelRenderer, true, 0)) {
                if (children.contains(child)) continue;
                children.add(child);
            }
        }
        for (ModelRenderer modelRenderer : children) {
            list.remove(modelRenderer);
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getMultiModelCubes(ArrayList<ModelBase> parent) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        for (ModelBase base : parent) {
            list.addAll(ModelHelper.getModelCubes(base));
        }
        return list;
    }

    public static ArrayList<ModelRenderer> getChildren(ModelRenderer parent, boolean recursive, int depth) {
        ArrayList<ModelRenderer> list = new ArrayList<ModelRenderer>();
        if (parent.field_78805_m != null && depth < 20) {
            for (int i = 0; i < parent.field_78805_m.size(); ++i) {
                ModelRenderer child = (ModelRenderer)parent.field_78805_m.get(i);
                if (recursive) {
                    ArrayList<ModelRenderer> children = ModelHelper.getChildren(child, recursive, depth + 1);
                    for (ModelRenderer child1 : children) {
                        if (list.contains(child1)) continue;
                        list.add(child1);
                    }
                }
                if (list.contains(child)) continue;
                list.add(child);
            }
        }
        return list;
    }

    public static ModelBase getPossibleModel(Render rend) {
        ArrayList models = new ArrayList();
        if (rend != null) {
            try {
                for (Class<?> clz = rend.getClass(); clz != Render.class; clz = clz.getSuperclass()) {
                    Field[] fields;
                    ArrayList<ModelBase> priorityLevel = new ArrayList<ModelBase>();
                    for (Field f : fields = clz.getDeclaredFields()) {
                        ModelBase[] modelBases;
                        f.setAccessible(true);
                        if (ModelBase.class.isAssignableFrom(f.getType())) {
                            ModelBase base = (ModelBase)f.get(rend);
                            if (base == null) continue;
                            priorityLevel.add(base);
                            continue;
                        }
                        if (!ModelBase[].class.isAssignableFrom(f.getType()) || (modelBases = (ModelBase[])f.get(rend)) == null) continue;
                        for (ModelBase base : modelBases) {
                            priorityLevel.add(base);
                        }
                    }
                    models.add(priorityLevel);
                    if (clz != RendererLivingEntity.class) continue;
                    ArrayList<ModelBase> topPriority = new ArrayList<ModelBase>();
                    for (Field f : fields) {
                        ModelBase base;
                        f.setAccessible(true);
                        if (!ModelBase.class.isAssignableFrom(f.getType()) || !f.getName().equalsIgnoreCase("mainModel") && !f.getName().equalsIgnoreCase("field_77045_g") || (base = (ModelBase)f.get(rend)) == null) continue;
                        topPriority.add(base);
                    }
                    models.add(topPriority);
                }
            }
            catch (Exception e) {
                throw new ReflectionHelper.UnableToAccessFieldException(new String[0], e);
            }
        }
        ModelBase base1 = null;
        int priorityLevel = -1;
        int size = -1;
        int currentPriority = 0;
        for (ArrayList arrayList : models) {
            for (ModelBase base : arrayList) {
                ArrayList<ModelRenderer> mrs = ModelHelper.getModelCubes(base);
                if (mrs.size() <= size && (mrs.size() != size || currentPriority <= priorityLevel)) continue;
                size = mrs.size();
                base1 = base;
                priorityLevel = currentPriority;
            }
            ++currentPriority;
        }
        return base1;
    }

    public static ArrayList<ModelRenderer> getModelCubes(EntityLivingBase living) {
        ArrayList<ModelRenderer> map = classToModelRendererMap.get(living.getClass());
        if (map == null) {
            map = ModelHelper.getModelCubes(ModelHelper.getPossibleModel(RenderManager.field_78727_a.func_78713_a((Entity)living)));
            classToModelRendererMap.put(living.getClass(), map);
        }
        return map;
    }
}

