/*
 * Decompiled with CFR 0.152.
 */
package com.assassincraft.original;

import com.assassincraft.original.ACEntityVillagerTest;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.village.MerchantRecipeList;
import net.minecraft.world.gen.structure.StructureVillagePieces;

public class ACVillagerRegistry {
    private static final ACVillagerRegistry INSTANCE = new ACVillagerRegistry();
    private Multimap<Integer, IVillageTradeHandler> tradeHandlers = ArrayListMultimap.create();
    private Map<Class<?>, IVillageCreationHandler> villageCreationHandlers = Maps.newHashMap();
    private List<Integer> newVillagerIds = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    private Map<Integer, ResourceLocation> newVillagers;

    public static ACVillagerRegistry instance() {
        return INSTANCE;
    }

    public void registerVillagerId(int id) {
        if (this.newVillagerIds.contains(id)) {
            FMLLog.severe((String)"Attempt to register duplicate villager id %d", (Object[])new Object[]{id});
            throw new RuntimeException();
        }
        this.newVillagerIds.add(id);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerVillagerSkin(int villagerId, ResourceLocation villagerSkin) {
        if (this.newVillagers == null) {
            this.newVillagers = Maps.newHashMap();
        }
        this.newVillagers.put(villagerId, villagerSkin);
    }

    public void registerVillageCreationHandler(IVillageCreationHandler handler) {
        this.villageCreationHandlers.put(handler.getComponentClass(), handler);
    }

    public void registerVillageTradeHandler(int villagerId, IVillageTradeHandler handler) {
        this.tradeHandlers.put((Object)villagerId, (Object)handler);
    }

    @SideOnly(value=Side.CLIENT)
    public static ResourceLocation getVillagerSkin(int villagerType, ResourceLocation defaultSkin) {
        if (ACVillagerRegistry.instance().newVillagers != null && ACVillagerRegistry.instance().newVillagers.containsKey(villagerType)) {
            return ACVillagerRegistry.instance().newVillagers.get(villagerType);
        }
        return defaultSkin;
    }

    public static Collection<Integer> getRegisteredVillagers() {
        return Collections.unmodifiableCollection(ACVillagerRegistry.instance().newVillagerIds);
    }

    public static void manageVillagerTrades(MerchantRecipeList recipeList, ACEntityVillagerTest villager, int villagerType, Random random) {
        for (IVillageTradeHandler handler : ACVillagerRegistry.instance().tradeHandlers.get((Object)villagerType)) {
            handler.manipulateTradesForVillager(villager, recipeList, random);
        }
    }

    public static void addExtraVillageComponents(ArrayList components, Random random, int i) {
        ArrayList parts = components;
        for (IVillageCreationHandler handler : ACVillagerRegistry.instance().villageCreationHandlers.values()) {
            parts.add(handler.getVillagePieceWeight(random, i));
        }
    }

    public static Object getVillageComponent(StructureVillagePieces.PieceWeight villagePiece, StructureVillagePieces.Start startPiece, List pieces, Random random, int p1, int p2, int p3, int p4, int p5) {
        return ACVillagerRegistry.instance().villageCreationHandlers.get(villagePiece.field_75090_a).buildComponent(villagePiece, startPiece, pieces, random, p1, p2, p3, p4, p5);
    }

    public static void addEmeraldBuyRecipe(ACEntityVillagerTest villager, MerchantRecipeList list, Random random, Item item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            ACEntityVillagerTest.villagersSellingList.put(item, new Tuple((Object)min, (Object)max));
        }
        ACEntityVillagerTest.func_146091_a(list, item, random, chance);
    }

    public static void addEmeraldSellRecipe(ACEntityVillagerTest villager, MerchantRecipeList list, Random random, Item item, float chance, int min, int max) {
        if (min > 0 && max > 0) {
            ACEntityVillagerTest.blacksmithSellingList.put(item, new Tuple((Object)min, (Object)max));
        }
        ACEntityVillagerTest.func_146089_b(list, item, random, chance);
    }

    public static void applyRandomTrade(ACEntityVillagerTest villager, Random rand) {
        int extra = ACVillagerRegistry.instance().newVillagerIds.size();
        int trade = rand.nextInt(5 + extra);
        villager.setProfession(trade < 5 ? trade : ACVillagerRegistry.instance().newVillagerIds.get(trade - 5));
    }

    public static interface IVillageTradeHandler {
        public void manipulateTradesForVillager(ACEntityVillagerTest var1, MerchantRecipeList var2, Random var3);
    }

    public static interface IVillageCreationHandler {
        public StructureVillagePieces.PieceWeight getVillagePieceWeight(Random var1, int var2);

        public Class<?> getComponentClass();

        public Object buildComponent(StructureVillagePieces.PieceWeight var1, StructureVillagePieces.Start var2, List var3, Random var4, int var5, int var6, int var7, int var8, int var9);
    }
}

