/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.breeds;

import info.ata4.minecraft.dragon.server.entity.EntityTameableDragon;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.util.DamageSource;
import net.minecraft.world.biome.BiomeGenBase;

public class DragonBreed {
    private final String name;
    private final String skin;
    private final int color;
    private Set<String> immunities = new HashSet<String>();
    private Set<Block> breedBlocks = new HashSet<Block>();
    private Set<BiomeGenBase> biomes = new HashSet<BiomeGenBase>();

    public DragonBreed(String name, String skin, int color) {
        this.name = name;
        this.skin = skin;
        this.color = color;
        this.addImmunity(DamageSource.field_76369_e);
        this.addImmunity(DamageSource.field_76368_d);
        this.addImmunity(DamageSource.field_76367_g);
    }

    public String getName() {
        return this.name;
    }

    public String getSkin() {
        return this.skin;
    }

    public String getLivingSound() {
        return null;
    }

    public EnumCreatureAttribute getCreatureAttribute() {
        return EnumCreatureAttribute.UNDEFINED;
    }

    public int getColor() {
        return this.color;
    }

    public float getColorR() {
        return (float)(this.color >> 16 & 0xFF) / 255.0f;
    }

    public float getColorG() {
        return (float)(this.color >> 8 & 0xFF) / 255.0f;
    }

    public float getColorB() {
        return (float)(this.color & 0xFF) / 255.0f;
    }

    protected void addImmunity(DamageSource dmg) {
        this.immunities.add(dmg.field_76373_n);
    }

    public boolean isImmuneToDamage(DamageSource dmg) {
        if (this.immunities.isEmpty()) {
            return false;
        }
        return this.immunities.contains(dmg.field_76373_n);
    }

    public void addHabitatBlock(Block block) {
        this.breedBlocks.add(block);
    }

    public boolean isHabitatBlock(Block block) {
        return this.breedBlocks.contains(block);
    }

    public void addHabitatBiome(BiomeGenBase biome) {
        this.biomes.add(biome);
    }

    public boolean isHabitatBiome(BiomeGenBase biome) {
        return this.biomes.contains(biome);
    }

    public boolean isHabitatEnvironment(EntityTameableDragon dragon) {
        return false;
    }

    public void onEnable(EntityTameableDragon dragon) {
    }

    public void onDisable(EntityTameableDragon dragon) {
    }

    public void onUpdate(EntityTameableDragon dragon) {
    }

    public void onDeath(EntityTameableDragon dragon) {
    }

    public String toString() {
        return this.name;
    }
}

