/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.server.entity.helper;

public enum DragonLifeStage {
    EGG(-72000),
    HATCHLING(-48000),
    JUVENILE(-24000),
    ADULT(0);

    private final int ageLimit;

    public static DragonLifeStage valueOf(int age) {
        if (age >= DragonLifeStage.ADULT.ageLimit) {
            return ADULT;
        }
        if (age >= DragonLifeStage.JUVENILE.ageLimit) {
            return JUVENILE;
        }
        if (age >= DragonLifeStage.HATCHLING.ageLimit) {
            return HATCHLING;
        }
        return EGG;
    }

    private DragonLifeStage(int ageLimit) {
        this.ageLimit = ageLimit;
    }

    public int getAgeLimit() {
        return this.ageLimit;
    }

    public boolean isEgg() {
        return this == EGG;
    }

    public boolean isHatchling() {
        return this == HATCHLING;
    }

    public boolean isJuvenile() {
        return this == JUVENILE;
    }

    public boolean isAdult() {
        return this == ADULT;
    }
}

