/*
 * Decompiled with CFR 0.152.
 */
package info.ata4.minecraft.dragon.util;

import java.io.File;
import net.minecraftforge.common.config.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BasicModConfig {
    private static final Logger L = LogManager.getLogger();
    protected Configuration config;
    private boolean failsafe = false;

    public BasicModConfig(File configFile) {
        try {
            this.config = new Configuration(configFile);
        }
        catch (Throwable t) {
            this.config = new Configuration();
            this.failsafe = true;
            L.warn("Error in configuration file, using defaults", t);
        }
        this.init();
        this.save();
    }

    public void reload() {
        if (this.failsafe) {
            this.config = new Configuration();
            this.init();
        } else {
            try {
                this.config.load();
            }
            catch (Throwable t) {
                L.warn("Error in configuration file", t);
            }
        }
    }

    public void save() {
        if (!this.failsafe && this.config.hasChanged()) {
            this.config.save();
        }
    }

    protected abstract void init();
}

