/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.miccore;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.FMLInjectionData;
import cpw.mods.fml.relauncher.IFMLCallHook;
import cpw.mods.fml.relauncher.IFMLLoadingPlugin;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import micdoodle8.mods.miccore.ConfigManagerMicCore;
import net.minecraft.launchwrapper.LaunchClassLoader;
import net.minecraftforge.common.MinecraftForge;
import org.apache.commons.io.FileUtils;

@IFMLLoadingPlugin.TransformerExclusions(value={"micdoodle8.mods.miccore"})
public class MicdoodlePlugin
implements IFMLLoadingPlugin,
IFMLCallHook {
    public static boolean hasRegistered = false;
    public static final String mcVersion = "[1.7.2],[1.7.10]";
    public static File mcDir;
    public static File canonicalConfigDir;
    private static boolean checkedVersions;
    private static Constructor<?> sleepCancelledConstructor;
    private static Constructor<?> orientCameraConstructor;
    private static String galacticraftCoreClass;

    public static void versionCheck(String reqVersion, String mod) {
        String mcVersion = (String)FMLInjectionData.data()[4];
        if (!VersionParser.parseRange((String)reqVersion).containsVersion((ArtifactVersion)new DefaultArtifactVersion(mcVersion))) {
            String err = "This version of " + mod + " does not support minecraft version " + mcVersion;
            System.err.println(err);
            JEditorPane ep = new JEditorPane("text/html", "<html>" + err + "<br>Remove it from your mods folder and check <a href=\"http://micdoodle8.com\">here</a> for updates" + "</html>");
            ep.setEditable(false);
            ep.setOpaque(false);
            ep.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent event) {
                    try {
                        if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                            Desktop.getDesktop().browse(event.getURL().toURI());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
            JOptionPane.showMessageDialog(null, ep, "Fatal error", 0);
            System.exit(1);
        }
    }

    public String[] getASMTransformerClass() {
        MicdoodlePlugin.versionCheck(mcVersion, "MicdoodleCore");
        String[] asmStrings = new String[]{"micdoodle8.mods.miccore.MicdoodleTransformer"};
        if (!hasRegistered) {
            List<String> asm = Arrays.asList(asmStrings);
            for (String s : asm) {
                try {
                    Class<?> c = Class.forName(s);
                    if (c == null) continue;
                    System.out.println("Successfully Registered Transformer");
                }
                catch (Exception ex) {
                    System.out.println("Error while running transformer " + s);
                    return null;
                }
            }
            hasRegistered = true;
        }
        return asmStrings;
    }

    public String getModContainerClass() {
        return "micdoodle8.mods.miccore.MicdoodleModContainer";
    }

    public String getSetupClass() {
        return "micdoodle8.mods.miccore.MicdoodlePlugin";
    }

    public void injectData(Map<String, Object> data) {
        if (data.containsKey("mcLocation")) {
            String canonicalConfigPath;
            mcDir = (File)data.get("mcLocation");
            File configDir = new File(mcDir, "config");
            File modsDir = new File(mcDir, "mods");
            if (!checkedVersions) {
                checkedVersions = true;
                boolean obfuscated = false;
                try {
                    LaunchClassLoader loader = new LaunchClassLoader(((URLClassLoader)this.getClass().getClassLoader()).getURLs());
                    URL classResource = loader.findResource(String.valueOf("net.minecraft.world.World").replace('.', '/').concat(".class"));
                    obfuscated = classResource == null;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (obfuscated) {
                    Collection fileList = FileUtils.listFiles((File)modsDir, (String[])new String[]{"jar", "zip"}, (boolean)true);
                    String[] micCoreVersion = null;
                    String[] gcVersion = null;
                    if (fileList != null) {
                        for (File file : fileList) {
                            String micVersion;
                            String[] split0;
                            String fileName;
                            if (file.getName().contains("MicdoodleCore")) {
                                fileName = file.getName();
                                split0 = fileName.split("\\-");
                                if (split0.length == 4) {
                                    micVersion = split0[3].replace(".jar", "").replace(".zip", "");
                                    micCoreVersion = micVersion.split("\\.");
                                } else if (split0.length == 3) {
                                    micVersion = split0[2].replace(".jar", "").replace(".zip", "");
                                    micCoreVersion = micVersion.split("\\.");
                                }
                            }
                            if (!file.getName().contains("GalacticraftCore")) continue;
                            fileName = file.getName();
                            split0 = fileName.split("\\-");
                            if (split0.length == 4) {
                                micVersion = split0[3].replace(".jar", "").replace(".zip", "");
                                gcVersion = micVersion.split("\\.");
                                continue;
                            }
                            if (split0.length != 3) continue;
                            micVersion = split0[2].replace(".jar", "").replace(".zip", "");
                            gcVersion = micVersion.split("\\.");
                        }
                    }
                    if (micCoreVersion == null) {
                        this.showErrorDialog(new Object[]{"Install", "Ignore"}, "Failed to find MicdoodleCore file in mods folder!");
                    } else if (gcVersion == null) {
                        this.showErrorDialog(new Object[]{"Install", "Ignore"}, "Failed to find Galacticraft file in mods folder!");
                    } else if (micCoreVersion.length != gcVersion.length) {
                        this.showErrorDialog(new Object[]{"Reinstall", "Ignore"}, "Failed to match Galacticraft version to MicdoodleCore version!");
                    } else {
                        int i;
                        for (i = 0; i < (micCoreVersion.length & gcVersion.length); ++i) {
                            micCoreVersion[i] = this.trimInvalidIntegers((String)micCoreVersion[i]);
                            gcVersion[i] = this.trimInvalidIntegers((String)gcVersion[i]);
                        }
                        for (i = 0; i < micCoreVersion.length; ++i) {
                            int gcVersionI;
                            if (micCoreVersion[i].equals(gcVersion[i])) continue;
                            int micCoreVersionI = Integer.parseInt((String)micCoreVersion[i]);
                            if (micCoreVersionI < (gcVersionI = Integer.parseInt((String)gcVersion[i]))) {
                                this.showErrorDialog(new Object[]{"Update", "Ignore"}, "MicdoodleCore Update Required!", "Galacticraft and MicdoodleCore should always be at the same version", "Severe issues can be caused from not updating");
                                continue;
                            }
                            this.showErrorDialog(new Object[]{"Update", "Ignore"}, "Galacticraft Update Required!", "Galacticraft and MicdoodleCore should always be at the same version", "Severe issues can be caused from not updating");
                        }
                    }
                }
            }
            try {
                canonicalConfigPath = configDir.getCanonicalPath();
                canonicalConfigDir = configDir.getCanonicalFile();
            }
            catch (IOException ioe) {
                throw new LoaderException((Throwable)ioe);
            }
            if (!canonicalConfigDir.exists()) {
                FMLLog.fine((String)"No config directory found, creating one: %s", (Object[])new Object[]{canonicalConfigPath});
                boolean dirMade = canonicalConfigDir.mkdir();
                if (!dirMade) {
                    FMLLog.severe((String)"Unable to create the config directory %s", (Object[])new Object[]{canonicalConfigPath});
                    throw new LoaderException();
                }
                FMLLog.info((String)"Config directory created successfully", (Object[])new Object[0]);
            }
            ConfigManagerMicCore.init();
        }
        System.out.println("[Micdoodle8Core]: Patching game...");
    }

    private void showErrorDialog(Object[] options, String ... messages) {
        String err = "<html>";
        for (String s : messages) {
            System.err.print(s);
            err = err.concat(s + "<br />");
        }
        err = err.concat("</html>");
        JEditorPane ep = new JEditorPane("text/html", err);
        ep.setEditable(false);
        ep.setOpaque(false);
        ep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                try {
                    if (event.getEventType().equals(HyperlinkEvent.EventType.ACTIVATED)) {
                        Desktop.getDesktop().browse(event.getURL().toURI());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        int ret = JOptionPane.showOptionDialog(null, ep, "Fatal error", -1, 0, null, options, options[0]);
        System.err.println(ret);
        switch (ret) {
            case 0: {
                try {
                    Desktop.getDesktop().browse(new URL("http://micdoodle8.com/mods/galacticraft/downloads").toURI());
                }
                catch (Exception e) {
                    // empty catch block
                }
                System.exit(0);
                break;
            }
            case 1: {
                break;
            }
        }
    }

    private String trimInvalidIntegers(String toTrim) {
        String c;
        String newString = "";
        for (int j = 0; j < toTrim.length() && "0123456789".contains(c = toTrim.substring(j, j + 1)); ++j) {
            newString = newString.concat(c);
        }
        return newString;
    }

    public Void call() throws Exception {
        return null;
    }

    public static void onSleepCancelled() {
        try {
            if (sleepCancelledConstructor == null) {
                sleepCancelledConstructor = Class.forName(galacticraftCoreClass + "$SleepCancelledEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)sleepCancelledConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void orientCamera() {
        try {
            if (orientCameraConstructor == null) {
                orientCameraConstructor = Class.forName(galacticraftCoreClass + "$OrientCameraEvent").getConstructor(new Class[0]);
            }
            MinecraftForge.EVENT_BUS.post((Event)orientCameraConstructor.newInstance(new Object[0]));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getAccessTransformerClass() {
        return "micdoodle8.mods.miccore.MicdoodleAccessTransformer";
    }

    static {
        checkedVersions = false;
        galacticraftCoreClass = "micdoodle8.mods.galacticraft.core.event.EventHandlerGC";
    }
}

