/*
 * Decompiled with CFR 0.152.
 */
package invtweaks.forge;

import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.relauncher.Side;
import invtweaks.InvTweaks;
import invtweaks.InvTweaksItemTreeLoader;
import invtweaks.api.IItemTreeListener;
import invtweaks.forge.CommonProxy;
import invtweaks.forge.ForgeClientTick;
import invtweaks.network.packets.ITPacketClick;
import invtweaks.network.packets.ITPacketSortComplete;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerControllerMP;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ClientProxy
extends CommonProxy {
    private InvTweaks instance;
    private ForgeClientTick clientTick;
    public boolean serverSupportEnabled = false;
    public boolean serverSupportDetected = false;

    @Override
    public void preInit(FMLPreInitializationEvent e) {
        super.preInit(e);
        InvTweaks.log = e.getModLog();
    }

    @Override
    public void init(FMLInitializationEvent e) {
        super.init(e);
        Minecraft mc = FMLClientHandler.instance().getClient();
        this.instance = new InvTweaks(mc);
        this.clientTick = new ForgeClientTick(this.instance);
        FMLCommonHandler.instance().bus().register((Object)this.clientTick);
    }

    @SubscribeEvent
    public void notifyPickup(PlayerEvent.ItemPickupEvent e) {
        this.instance.setItemPickupPending(true);
    }

    @Override
    public void setServerAssistEnabled(boolean enabled) {
        this.serverSupportEnabled = this.serverSupportDetected && enabled;
    }

    @Override
    public void setServerHasInvTweaks(boolean hasInvTweaks) {
        this.serverSupportDetected = hasInvTweaks;
        this.serverSupportEnabled = hasInvTweaks && !InvTweaks.getConfigManager().getConfig().getProperty("enableServerItemSwap").equals("false");
    }

    @Override
    public void slotClick(PlayerControllerMP playerController, int windowId, int slot, int data, int action, EntityPlayer player) {
        if (this.serverSupportEnabled) {
            player.field_71070_bA.func_75144_a(slot, data, action, player);
            ((FMLEmbeddedChannel)invtweaksChannel.get(Side.CLIENT)).writeOutbound(new Object[]{new ITPacketClick(slot, data, action)});
        } else {
            playerController.func_78753_a(windowId, slot, data, action, player);
        }
    }

    @Override
    public void sortComplete() {
        if (this.serverSupportEnabled) {
            ((FMLEmbeddedChannel)invtweaksChannel.get(Side.CLIENT)).writeOutbound(new Object[]{new ITPacketSortComplete()});
        }
    }

    @Override
    public void addOnLoadListener(IItemTreeListener listener) {
        InvTweaksItemTreeLoader.addOnLoadListener(listener);
    }

    @Override
    public boolean removeOnLoadListener(IItemTreeListener listener) {
        return InvTweaksItemTreeLoader.removeOnLoadListener(listener);
    }

    @Override
    public void setSortKeyEnabled(boolean enabled) {
        this.instance.setSortKeyEnabled(enabled);
    }

    @Override
    public void setTextboxMode(boolean enabled) {
        this.instance.setTextboxMode(enabled);
    }

    @Override
    public int compareItems(ItemStack i, ItemStack j) {
        return this.instance.compareItems(i, j);
    }
}

