/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.client;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.LayeredTexture;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import shadersmodcore.client.MultiTexID;
import shadersmodcore.client.Shaders;

public class ShadersTex {
    public static final int initialBufferSize = 0x100000;
    public static ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)0x400000);
    public static IntBuffer intBuffer = byteBuffer.asIntBuffer();
    public static int[] intArray = new int[0x100000];
    public static final int defBaseTexColor = 0;
    public static final int defNormTexColor = -8421377;
    public static final int defSpecTexColor = 0;
    public static Map<Integer, MultiTexID> multiTexMap = new HashMap<Integer, MultiTexID>();
    public static TextureMap updatingTextureMap = null;
    public static TextureAtlasSprite updatingSprite = null;
    public static MultiTexID updatingTex = null;
    public static MultiTexID boundTex = null;
    public static int updatingPage = 0;
    public static String iconName = null;
    static IResourceManager resManager = null;
    static ResourceLocation resLocation = null;
    static int imageSize = 0;

    public static IntBuffer getIntBuffer(int size) {
        if (intBuffer.capacity() < size) {
            int bufferSize = ShadersTex.roundUpPOT(size);
            byteBuffer = BufferUtils.createByteBuffer((int)(bufferSize * 4));
            intBuffer = byteBuffer.asIntBuffer();
        }
        return intBuffer;
    }

    public static int[] getIntArray(int size) {
        if (intArray.length < size) {
            intArray = null;
            intArray = new int[ShadersTex.roundUpPOT(size)];
        }
        return intArray;
    }

    public static int roundUpPOT(int x) {
        int i = x - 1;
        i |= i >> 1;
        i |= i >> 2;
        i |= i >> 4;
        i |= i >> 8;
        i |= i >> 16;
        return i + 1;
    }

    public static IntBuffer fillIntBuffer(int size, int value) {
        int[] aint = ShadersTex.getIntArray(size);
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        Arrays.fill(intArray, 0, size, value);
        intBuffer.put(intArray, 0, size);
        return intBuffer;
    }

    public static int[] createAIntImage(int size) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, 0);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static int[] createAIntImage(int size, int color) {
        int[] aint = new int[size * 3];
        Arrays.fill(aint, 0, size, color);
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        return aint;
    }

    public static MultiTexID getMultiTexID(AbstractTexture tex) {
        MultiTexID multiTex = tex.multiTex;
        if (multiTex == null) {
            int baseTex = tex.func_110552_b();
            multiTex = multiTexMap.get(baseTex);
            if (multiTex == null) {
                multiTex = new MultiTexID(baseTex, GL11.glGenTextures(), GL11.glGenTextures());
                multiTexMap.put(baseTex, multiTex);
            }
            tex.multiTex = multiTex;
        }
        return multiTex;
    }

    public static void deleteTextures(AbstractTexture atex) {
        MultiTexID multiTex;
        int texid = atex.field_110553_a;
        if (texid != -1) {
            GL11.glDeleteTextures((int)texid);
            atex.field_110553_a = -1;
        }
        if ((multiTex = atex.multiTex) != null) {
            atex.multiTex = null;
            multiTexMap.remove(multiTex.base);
            GL11.glDeleteTextures((int)multiTex.norm);
            GL11.glDeleteTextures((int)multiTex.spec);
            if (multiTex.base != texid) {
                System.err.println("Error : MultiTexID.base mismatch.");
                GL11.glDeleteTextures((int)multiTex.base);
            }
        }
    }

    public static int deleteMultiTex(ITextureObject tex) {
        if (tex instanceof AbstractTexture) {
            ShadersTex.deleteTextures((AbstractTexture)tex);
        } else {
            GL11.glDeleteTextures((int)tex.func_110552_b());
        }
        return 0;
    }

    public static void bindNSTextures(int normTex, int specTex) {
        if (Shaders.isRenderingWorld && Shaders.activeTexUnit == 33984) {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)normTex);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)specTex);
            GL13.glActiveTexture((int)33984);
        }
    }

    public static void bindNSTextures(MultiTexID multiTex) {
        ShadersTex.bindNSTextures(multiTex.norm, multiTex.spec);
    }

    public static void bindTextures(int baseTex, int normTex, int specTex) {
        if (Shaders.isRenderingWorld && Shaders.activeTexUnit == 33984) {
            GL13.glActiveTexture((int)33986);
            GL11.glBindTexture((int)3553, (int)normTex);
            GL13.glActiveTexture((int)33987);
            GL11.glBindTexture((int)3553, (int)specTex);
            GL13.glActiveTexture((int)33984);
        }
        GL11.glBindTexture((int)3553, (int)baseTex);
    }

    public static void bindTextures(MultiTexID multiTex) {
        boundTex = multiTex;
        if (Shaders.isRenderingWorld && Shaders.activeTexUnit == 33984) {
            if (Shaders.configNormalMap) {
                GL13.glActiveTexture((int)33986);
                GL11.glBindTexture((int)3553, (int)multiTex.norm);
            }
            if (Shaders.configSpecularMap) {
                GL13.glActiveTexture((int)33987);
                GL11.glBindTexture((int)3553, (int)multiTex.spec);
            }
            GL13.glActiveTexture((int)33984);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static void bindTexture(ITextureObject tex) {
        if (tex instanceof TextureMap) {
            Shaders.atlasSizeX = ((TextureMap)tex).atlasWidth;
            Shaders.atlasSizeY = ((TextureMap)tex).atlasHeight;
        } else {
            Shaders.atlasSizeX = 0;
            Shaders.atlasSizeY = 0;
        }
        ShadersTex.bindTextures(tex.getMultiTexID());
    }

    public static void bindTextures(int baseTex) {
        MultiTexID multiTex = multiTexMap.get(baseTex);
        ShadersTex.bindTextures(multiTex);
    }

    public static void allocTexStorage(int width, int height, int maxLevel) {
        Shaders.checkGLError("pre allocTexStorage");
        int level = 0;
        while (width >> level > 0 && height >> level > 0) {
            GL11.glTexImage2D((int)3553, (int)level, (int)6408, (int)(width >> level), (int)(height >> level), (int)0, (int)32993, (int)33639, (IntBuffer)null);
            ++level;
        }
        GL11.glTexParameteri((int)3553, (int)33085, (int)(level - 1));
        Shaders.checkGLError("allocTexStorage");
        GL11.glGetError();
    }

    public static void initDynamicTexture(int texID, int width, int height, DynamicTexture tex) {
        MultiTexID multiTex = tex.getMultiTexID();
        int[] aint = tex.func_110565_c();
        int size = width * height;
        Arrays.fill(aint, size, size * 2, -8421377);
        Arrays.fill(aint, size * 2, size * 3, 0);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        ShadersTex.allocTexStorage(width, height, 0);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        ShadersTex.allocTexStorage(width, height, 0);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        ShadersTex.allocTexStorage(width, height, 0);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexParameteri((int)3553, (int)33085, (int)0);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static ITextureObject createDefaultTexture() {
        DynamicTexture tex = new DynamicTexture(1, 1);
        tex.func_110565_c()[0] = -1;
        tex.func_110564_a();
        return tex;
    }

    public static void allocateTextureMap(int texID, int mipmapLevels, int width, int height, float anisotropy, Stitcher stitcher, TextureMap tex) {
        MultiTexID multiTex;
        System.out.println("allocateTextureMap " + tex.func_130086_a() + " " + mipmapLevels + " " + width + " " + height + " " + anisotropy + " ");
        updatingTextureMap = tex;
        tex.atlasWidth = width;
        tex.atlasHeight = height;
        updatingTex = multiTex = ShadersTex.getMultiTexID((AbstractTexture)tex);
        TextureUtil.func_147946_a((int)multiTex.base, (int)mipmapLevels, (int)width, (int)height, (float)anisotropy);
        if (Shaders.configNormalMap) {
            TextureUtil.func_147946_a((int)multiTex.norm, (int)mipmapLevels, (int)width, (int)height, (float)anisotropy);
        }
        if (Shaders.configSpecularMap) {
            TextureUtil.func_147946_a((int)multiTex.spec, (int)mipmapLevels, (int)width, (int)height, (float)anisotropy);
        }
        GL11.glBindTexture((int)3553, (int)texID);
    }

    public static TextureAtlasSprite setSprite(TextureAtlasSprite tas) {
        updatingSprite = tas;
        return updatingSprite;
    }

    public static String setIconName(String name) {
        iconName = name;
        return iconName;
    }

    public static void uploadTexSubForLoadAtlas(int[][] data, int width, int height, int xoffset, int yoffset, boolean linear, boolean clamp) {
        int[][] aaint;
        TextureUtil.func_147955_a((int[][])data, (int)width, (int)height, (int)xoffset, (int)yoffset, (boolean)linear, (boolean)clamp);
        boolean border = ShadersTex.updatingSprite.field_147966_k;
        if (Shaders.configNormalMap) {
            aaint = ShadersTex.readImageAndMipmaps(iconName + "_n", width, height, data.length, border, -8421377);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.norm);
            TextureUtil.func_147955_a((int[][])aaint, (int)width, (int)height, (int)xoffset, (int)yoffset, (boolean)linear, (boolean)clamp);
        }
        if (Shaders.configSpecularMap) {
            aaint = ShadersTex.readImageAndMipmaps(iconName + "_s", width, height, data.length, border, 0);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.spec);
            TextureUtil.func_147955_a((int[][])aaint, (int)width, (int)height, (int)xoffset, (int)yoffset, (boolean)linear, (boolean)clamp);
        }
        GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.base);
    }

    public static int[][] readImageAndMipmaps(String name, int width, int height, int numLevels, boolean border, int defColor) {
        Object aaint = new int[numLevels][];
        int[] aint = new int[width * height];
        aaint[0] = aint;
        boolean goodImage = false;
        BufferedImage image = ShadersTex.readImage(updatingTextureMap.func_147634_a(new ResourceLocation(name), 0));
        if (image != null) {
            int imageWidth = image.getWidth();
            int imageHeight = image.getHeight();
            if (imageWidth + (border ? 16 : 0) == width) {
                goodImage = true;
                image.getRGB(0, 0, imageWidth, imageWidth, aint, 0, imageWidth);
                if (border) {
                    TextureUtil.func_147948_a((int[])aint, (int)imageWidth, (int)imageWidth, (int)8);
                }
            }
        }
        if (!goodImage) {
            Arrays.fill(aint, defColor);
        }
        GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.spec);
        aaint = ShadersTex.genMipmapsSimple(((int[][])aaint).length - 1, width, aaint);
        return aaint;
    }

    public static BufferedImage readImage(ResourceLocation resLoc) {
        BufferedImage image = null;
        InputStream istr = null;
        try {
            istr = resManager.func_110536_a(resLoc).func_110527_b();
            image = ImageIO.read(istr);
        }
        catch (IOException e) {
            // empty catch block
        }
        if (istr != null) {
            try {
                istr.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            istr = null;
        }
        return image;
    }

    public static int[][] genMipmapsSimple(int maxLevel, int width, int[][] data) {
        for (int level = 1; level <= maxLevel; ++level) {
            if (data[level] != null) continue;
            int cw = width >> level;
            int pw = cw * 2;
            int[] aintp = data[level - 1];
            data[level] = new int[cw * cw];
            int[] aintc = data[level];
            for (int y = 0; y < cw; ++y) {
                for (int x = 0; x < cw; ++x) {
                    int ppos = y * 2 * pw + x * 2;
                    aintc[y * cw + x] = ShadersTex.blend4Simple(aintp[ppos], aintp[ppos + 1], aintp[ppos + pw], aintp[ppos + pw + 1]);
                }
            }
        }
        return data;
    }

    public static void uploadTexSub(int[][] data, int width, int height, int xoffset, int yoffset, boolean linear, boolean clamp) {
        TextureUtil.func_147955_a((int[][])data, (int)width, (int)height, (int)xoffset, (int)yoffset, (boolean)linear, (boolean)clamp);
    }

    public static int blend4Alpha(int c0, int c1, int c2, int c3) {
        int dv;
        int a0 = c0 >>> 24 & 0xFF;
        int a1 = c1 >>> 24 & 0xFF;
        int a2 = c2 >>> 24 & 0xFF;
        int a3 = c3 >>> 24 & 0xFF;
        int as = a0 + a1 + a2 + a3;
        int an = (as + 2) / 4;
        if (as != 0) {
            dv = as;
        } else {
            dv = 4;
            a0 = 1;
            a1 = 1;
            a2 = 1;
            a3 = 1;
        }
        int frac = (dv + 1) / 2;
        int color = an << 24 | ((c0 >>> 16 & 0xFF) * a0 + (c1 >>> 16 & 0xFF) * a1 + (c2 >>> 16 & 0xFF) * a2 + (c3 >>> 16 & 0xFF) * a3 + frac) / dv << 16 | ((c0 >>> 8 & 0xFF) * a0 + (c1 >>> 8 & 0xFF) * a1 + (c2 >>> 8 & 0xFF) * a2 + (c3 >>> 8 & 0xFF) * a3 + frac) / dv << 8 | ((c0 >>> 0 & 0xFF) * a0 + (c1 >>> 0 & 0xFF) * a1 + (c2 >>> 0 & 0xFF) * a2 + (c3 >>> 0 & 0xFF) * a3 + frac) / dv << 0;
        return color;
    }

    public static int blend4Simple(int c0, int c1, int c2, int c3) {
        int color = ((c0 >>> 24 & 0xFF) + (c1 >>> 24 & 0xFF) + (c2 >>> 24 & 0xFF) + (c3 >>> 24 & 0xFF) + 2) / 4 << 24 | ((c0 >>> 16 & 0xFF) + (c1 >>> 16 & 0xFF) + (c2 >>> 16 & 0xFF) + (c3 >>> 16 & 0xFF) + 2) / 4 << 16 | ((c0 >>> 8 & 0xFF) + (c1 >>> 8 & 0xFF) + (c2 >>> 8 & 0xFF) + (c3 >>> 8 & 0xFF) + 2) / 4 << 8 | ((c0 >>> 0 & 0xFF) + (c1 >>> 0 & 0xFF) + (c2 >>> 0 & 0xFF) + (c3 >>> 0 & 0xFF) + 2) / 4 << 0;
        return color;
    }

    public static void genMipmapAlpha(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x = 0; x < w1; ++x) {
                    aint[p1 + x] = ShadersTex.blend4Alpha(aint[p2 + x * 2], aint[p2 + (x * 2 + 1)], aint[p2 + w2 + x * 2], aint[p2 + w2 + (x * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x = 0; x < w2; ++x) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static void genMipmapSimple(int[] aint, int offset, int width, int height) {
        int o2;
        int h2;
        int w2;
        int minwh = Math.min(width, height);
        int w1 = w2 = width;
        int h1 = h2 = height;
        int o1 = o2 = offset;
        o2 = offset;
        w2 = width;
        h2 = height;
        o1 = 0;
        w1 = 0;
        h1 = 0;
        int level = 0;
        while (w2 > 1 && h2 > 1) {
            o1 = o2 + w2 * h2;
            w1 = w2 / 2;
            h1 = h2 / 2;
            for (int y = 0; y < h1; ++y) {
                int p1 = o1 + y * w1;
                int p2 = o2 + y * 2 * w2;
                for (int x = 0; x < w1; ++x) {
                    aint[p1 + x] = ShadersTex.blend4Simple(aint[p2 + x * 2], aint[p2 + (x * 2 + 1)], aint[p2 + w2 + x * 2], aint[p2 + w2 + (x * 2 + 1)]);
                }
            }
            ++level;
            w2 = w1;
            h2 = h1;
            o2 = o1;
        }
        while (level > 0) {
            w2 = width >> --level;
            h2 = height >> level;
            int p2 = o2 = o1 - w2 * h2;
            for (int y = 0; y < h2; ++y) {
                for (int x = 0; x < w2; ++x) {
                    if (aint[p2] == 0) {
                        aint[p2] = aint[o1 + y / 2 * w1 + x / 2] & 0xFFFFFF;
                    }
                    ++p2;
                }
            }
            o1 = o2;
            w1 = w2;
            h1 = h2;
        }
    }

    public static boolean isSemiTransparent(int[] aint, int width, int height) {
        int size = width * height;
        if (aint[0] >>> 24 == 255 && aint[size - 1] == 0) {
            return true;
        }
        for (int i = 0; i < size; ++i) {
            int alpha = aint[i] >>> 24;
            if (alpha == 0 || alpha == 255) continue;
            return true;
        }
        return false;
    }

    public static void updateSubImage1(int[] src, int width, int height, int posX, int posY, int page, int color) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        int[] aint = ShadersTex.getIntArray((size * 4 + 2) / 3);
        if (src.length >= size * (page + 1)) {
            System.arraycopy(src, size * page, aint, 0, size);
        } else {
            Arrays.fill(aint, color);
        }
        ShadersTex.genMipmapAlpha(aint, 0, width, height);
        int level = 0;
        int offset = 0;
        int lw = width;
        int lh = height;
        int px = posX;
        int py = posY;
        while (lw > 0 && lh > 0) {
            int lsize = lw * lh;
            intBuf.clear();
            intBuf.put(aint, offset, lsize).position(0).limit(lsize);
            GL11.glTexSubImage2D((int)3553, (int)level, (int)px, (int)py, (int)lw, (int)lh, (int)32993, (int)33639, (IntBuffer)intBuf);
            offset += lsize;
            lw /= 2;
            lh /= 2;
            px /= 2;
            py /= 2;
            ++level;
        }
        intBuf.clear();
    }

    public static void updateSubTex1(int[] src, int width, int height, int posX, int posY) {
        int level = 0;
        int cw = width;
        int ch = height;
        int cx = posX;
        int cy = posY;
        while (cw > 0 && ch > 0) {
            GL11.glCopyTexSubImage2D((int)3553, (int)level, (int)cx, (int)cy, (int)0, (int)0, (int)cw, (int)ch);
            ++level;
            cw /= 2;
            ch /= 2;
            cx /= 2;
            cy /= 2;
        }
    }

    public static void updateSubImage1(int[][] src, int width, int height, int posX, int posY, int page, int color) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        int numLevel = src.length;
        int level = 0;
        int lw = width;
        int lh = height;
        int px = posX;
        int py = posY;
        while (lw > 0 && lh > 0 && level < numLevel) {
            int lsize = lw * lh;
            intBuf.clear();
            intBuf.put(src[level], 0, lsize).position(0).limit(lsize);
            GL11.glTexSubImage2D((int)3553, (int)level, (int)px, (int)py, (int)lw, (int)lh, (int)32993, (int)33639, (IntBuffer)intBuf);
            lw /= 2;
            lh /= 2;
            px /= 2;
            py /= 2;
            ++level;
        }
        intBuf.clear();
    }

    public static void setupTextureMipmap(TextureMap tex) {
    }

    public static void updateDynamicTexture(int texID, int[] src, int width, int height, DynamicTexture tex) {
        MultiTexID multiTex = tex.getMultiTexID();
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 1, -8421377);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 2, 0);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        ShadersTex.updateSubImage1(src, width, height, 0, 0, 0, 0);
    }

    public static void updateSubImage(int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        if (updatingTex != null) {
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.norm);
            ShadersTex.updateSubImage1(src, width, height, posX, posY, 1, -8421377);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.spec);
            ShadersTex.updateSubImage1(src, width, height, posX, posY, 2, 0);
            GL11.glBindTexture((int)3553, (int)ShadersTex.updatingTex.base);
        }
        ShadersTex.updateSubImage1(src, width, height, posX, posY, 0, 0);
    }

    public static void updateAnimationTextureMap(TextureMap tex, List tasList) {
        MultiTexID multiTex = tex.getMultiTexID();
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (TextureAtlasSprite tas : tasList) {
            tas.func_94219_l();
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (TextureAtlasSprite tas : tasList) {
            tas.func_94219_l();
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        for (TextureAtlasSprite tas : tasList) {
            tas.func_94219_l();
        }
    }

    public static void setupTexture(MultiTexID multiTex, int[] src, int width, int height, boolean linear, boolean clamp) {
        int mmfilter = linear ? 9729 : 9728;
        int wraptype = clamp ? 10496 : 10497;
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        intBuf.clear();
        intBuf.put(src, 0, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuf);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        intBuf.put(src, size, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuf);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        intBuf.put(src, size * 2, size).position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)width, (int)height, (int)0, (int)32993, (int)33639, (IntBuffer)intBuf);
        GL11.glTexParameteri((int)3553, (int)10241, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10240, (int)mmfilter);
        GL11.glTexParameteri((int)3553, (int)10242, (int)wraptype);
        GL11.glTexParameteri((int)3553, (int)10243, (int)wraptype);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
    }

    public static void updateSubImage(MultiTexID multiTex, int[] src, int width, int height, int posX, int posY, boolean linear, boolean clamp) {
        int size = width * height;
        IntBuffer intBuf = ShadersTex.getIntBuffer(size);
        intBuf.clear();
        intBuf.put(src, 0, size);
        intBuf.position(0).limit(size);
        GL11.glBindTexture((int)3553, (int)multiTex.base);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size, size).position(0);
            intBuf.position(0).limit(size);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.norm);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        if (src.length == size * 3) {
            intBuf.clear();
            intBuf.put(src, size * 2, size);
            intBuf.position(0).limit(size);
        }
        GL11.glBindTexture((int)3553, (int)multiTex.spec);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10242, (int)10497);
        GL11.glTexParameteri((int)3553, (int)10243, (int)10497);
        GL11.glTexSubImage2D((int)3553, (int)0, (int)posX, (int)posY, (int)width, (int)height, (int)32993, (int)33639, (IntBuffer)intBuf);
        GL13.glActiveTexture((int)33984);
    }

    public static ResourceLocation getNSMapLocation(ResourceLocation location, String mapName) {
        String basename = location.func_110623_a();
        String[] basenameParts = basename.split(".png");
        String basenameNoFileType = basenameParts[0];
        return new ResourceLocation(location.func_110624_b(), basenameNoFileType + "_" + mapName + ".png");
    }

    public static void loadNSMap(IResourceManager manager, ResourceLocation location, int width, int height, int[] aint) {
        if (Shaders.configNormalMap) {
            ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "n"), width, height, aint, width * height, -8421377);
        }
        if (Shaders.configSpecularMap) {
            ShadersTex.loadNSMap1(manager, ShadersTex.getNSMapLocation(location, "s"), width, height, aint, width * height * 2, 0);
        }
    }

    public static void loadNSMap1(IResourceManager manager, ResourceLocation location, int width, int height, int[] aint, int offset, int defaultColor) {
        boolean good = false;
        try {
            IResource res = manager.func_110536_a(location);
            BufferedImage bufferedimage = ImageIO.read(res.func_110527_b());
            if (bufferedimage.getWidth() == width && bufferedimage.getHeight() == height) {
                bufferedimage.getRGB(0, 0, width, height, aint, offset, width);
                good = true;
            }
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (!good) {
            Arrays.fill(aint, offset, offset + width * height, defaultColor);
        }
    }

    public static int loadSimpleTexture(int textureID, BufferedImage bufferedimage, boolean linear, boolean clamp, IResourceManager resourceManager, ResourceLocation location, MultiTexID multiTex) {
        int width = bufferedimage.getWidth();
        int height = bufferedimage.getHeight();
        int size = width * height;
        int[] aint = ShadersTex.getIntArray(size * 3);
        bufferedimage.getRGB(0, 0, width, height, aint, 0, width);
        ShadersTex.loadNSMap(resourceManager, location, width, height, aint);
        ShadersTex.setupTexture(multiTex, aint, width, height, linear, clamp);
        return textureID;
    }

    public static void mergeImage(int[] aint, int dstoff, int srcoff, int size) {
    }

    public static int blendColor(int color1, int color2, int factor1) {
        int factor2 = 255 - factor1;
        return ((color1 >>> 24 & 0xFF) * factor1 + (color2 >>> 24 & 0xFF) * factor2) / 255 << 24 | ((color1 >>> 16 & 0xFF) * factor1 + (color2 >>> 16 & 0xFF) * factor2) / 255 << 16 | ((color1 >>> 8 & 0xFF) * factor1 + (color2 >>> 8 & 0xFF) * factor2) / 255 << 8 | ((color1 >>> 0 & 0xFF) * factor1 + (color2 >>> 0 & 0xFF) * factor2) / 255 << 0;
    }

    public static void loadLayeredTexture(LayeredTexture tex, IResourceManager manager, List list) {
        int width = 0;
        int height = 0;
        int size = 0;
        int[] image = null;
        for (String s : list) {
            if (s == null) continue;
            try {
                ResourceLocation location = new ResourceLocation(s);
                InputStream inputstream = manager.func_110536_a(location).func_110527_b();
                BufferedImage bufimg = ImageIO.read(inputstream);
                if (size == 0) {
                    width = bufimg.getWidth();
                    height = bufimg.getHeight();
                    size = width * height;
                    image = ShadersTex.createAIntImage(size, 0);
                }
                int[] aint = ShadersTex.getIntArray(size * 3);
                bufimg.getRGB(0, 0, width, height, aint, 0, width);
                ShadersTex.loadNSMap(manager, location, width, height, aint);
                for (int i = 0; i < size; ++i) {
                    int alpha = aint[i] >>> 24 & 0xFF;
                    image[size * 0 + i] = ShadersTex.blendColor(aint[size * 0 + i], image[size * 0 + i], alpha);
                    image[size * 1 + i] = ShadersTex.blendColor(aint[size * 1 + i], image[size * 1 + i], alpha);
                    image[size * 2 + i] = ShadersTex.blendColor(aint[size * 2 + i], image[size * 2 + i], alpha);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        ShadersTex.setupTexture(tex.getMultiTexID(), image, width, height, false, false);
    }

    static void updateTextureMinMagFilter() {
        TextureManager texman = Minecraft.func_71410_x().func_110434_K();
        ITextureObject texObj = texman.func_110581_b(TextureMap.field_110575_b);
        if (texObj != null) {
            MultiTexID multiTex = texObj.getMultiTexID();
            GL11.glBindTexture((int)3553, (int)multiTex.base);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilB]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilB]);
            GL11.glBindTexture((int)3553, (int)multiTex.norm);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilN]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilN]);
            GL11.glBindTexture((int)3553, (int)multiTex.spec);
            GL11.glTexParameteri((int)3553, (int)10241, (int)Shaders.texMinFilValue[Shaders.configTexMinFilS]);
            GL11.glTexParameteri((int)3553, (int)10240, (int)Shaders.texMagFilValue[Shaders.configTexMagFilS]);
            GL11.glBindTexture((int)3553, (int)0);
        }
    }

    public static IResource loadResource(IResourceManager manager, ResourceLocation location) throws IOException {
        resManager = manager;
        resLocation = location;
        return manager.func_110536_a(location);
    }

    public static int[] loadAtlasSprite(BufferedImage bufferedimage, int startX, int startY, int w, int h, int[] aint, int offset, int scansize) {
        imageSize = w * h;
        bufferedimage.getRGB(startX, startY, w, h, aint, offset, scansize);
        ShadersTex.loadNSMap(resManager, resLocation, w, h, aint);
        return aint;
    }

    public static int[] extractFrame(int[] src, int width, int height, int frameIndex) {
        int srcSize = imageSize;
        int frameSize = width * height;
        int[] dst = new int[frameSize * 3];
        int srcPos = frameSize * frameIndex;
        int dstPos = 0;
        System.arraycopy(src, srcPos, dst, dstPos, frameSize);
        System.arraycopy(src, srcPos += srcSize, dst, dstPos += frameSize, frameSize);
        System.arraycopy(src, srcPos += srcSize, dst, dstPos += frameSize, frameSize);
        return dst;
    }

    public static void fixTransparentColor(TextureAtlasSprite tas, int[] aint) {
    }
}

