/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.ClientProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.blocks.BlockLoader;
import jds.bibliocraft.items.ItemDrill;
import jds.bibliocraft.tileentities.TileEntityBookcase;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockBookcase
extends BlockContainer {
    public int bookcaseAngle;
    public int shelfAngle;
    public int slotsTopFilled;
    public int slotsBottomFilled;

    public BlockBookcase() {
        super(Material.field_151575_d);
        this.func_149672_a(Block.field_149766_f);
        this.func_149647_a(BlockLoader.biblioTab);
    }

    public float func_149712_f(World world, int i, int j, int k) {
        TileEntityBookcase tilee = (TileEntityBookcase)world.func_147438_o(i, j, k);
        if (tilee != null && tilee.isLocked()) {
            return -1.0f;
        }
        return 3.0f;
    }

    public float getEnchantPowerBonus(World world, int x, int y, int z) {
        TileEntityBookcase bookcase = (TileEntityBookcase)world.func_147438_o(x, y, z);
        if (bookcase != null) {
            return 0.125f * (float)bookcase.getFilledSlots();
        }
        return 0.0f;
    }

    public void func_149651_a(IIconRegister par1IconRegister) {
        this.field_149761_L = par1IconRegister.func_94245_a("planks_spruce");
    }

    public boolean func_149744_f() {
        return true;
    }

    public int func_149709_b(IBlockAccess blocka, int i, int j, int k, int face) {
        TileEntityBookcase bookcase = (TileEntityBookcase)blocka.func_147438_o(i, j, k);
        int angle = bookcase.getAngle();
        if (bookcase.getredstone()) {
            switch (angle) {
                case 0: {
                    if (face == 5) {
                        return 0;
                    }
                    return bookcase.getRedstoneBookSlot();
                }
                case 1: {
                    if (face == 3) {
                        return 0;
                    }
                    return bookcase.getRedstoneBookSlot();
                }
                case 2: {
                    if (face == 4) {
                        return 0;
                    }
                    return bookcase.getRedstoneBookSlot();
                }
                case 3: {
                    if (face == 2) {
                        return 0;
                    }
                    return bookcase.getRedstoneBookSlot();
                }
            }
            return 0;
        }
        return 0;
    }

    public int func_149748_c(IBlockAccess blocka, int i, int j, int k, int face) {
        return this.func_149709_b(blocka, i, j, k, face);
    }

    public boolean isTopShelf(float hitY) {
        return (double)hitY > 0.5;
    }

    public int isWhatBook(int angle, float hitX, float hitZ) {
        int xt = (int)(hitX * 8.0f);
        int zt = (int)(hitZ * 8.0f);
        switch (angle) {
            case 0: {
                return zt;
            }
            case 1: {
                switch (xt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case 2: {
                switch (zt) {
                    case 0: {
                        return 7;
                    }
                    case 1: {
                        return 6;
                    }
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                    case 6: {
                        return 1;
                    }
                    case 7: {
                        return 0;
                    }
                }
            }
            case 3: {
                return xt;
            }
        }
        return -1;
    }

    public void dropBook(World world, int i, int j, int k, int booknum) {
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        TileEntityBookcase bookTile = (TileEntityBookcase)tileEntity;
        ItemStack book = bookTile.func_70301_a(booknum);
        if (book != null && book.field_77994_a > 0) {
            float adjusti = 0.0f;
            float adjustk = 0.0f;
            switch (bookTile.getAngle()) {
                case 0: {
                    adjusti = -0.2f;
                    adjustk = 0.0f;
                    break;
                }
                case 1: {
                    adjusti = 0.0f;
                    adjustk = -0.2f;
                    break;
                }
                case 2: {
                    adjusti = 0.2f;
                    adjustk = 0.0f;
                    break;
                }
                case 3: {
                    adjusti = 0.0f;
                    adjustk = 0.2f;
                }
            }
            EntityItem entityItem = new EntityItem(world, (double)((float)i + 0.5f + adjusti), (double)((float)j + 0.5f), (double)((float)k + 0.5f + adjustk), new ItemStack(book.func_77973_b(), book.field_77994_a, book.func_77960_j()));
            if (book.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)book.func_77978_p().func_74737_b());
            }
            entityItem.field_70159_w = 0.0;
            entityItem.field_70181_x = 0.0;
            entityItem.field_70179_y = 0.0;
            world.func_72838_d((Entity)entityItem);
            book.field_77994_a = 0;
        }
    }

    public int func_149692_a(int metadata) {
        return metadata;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item par1, CreativeTabs tab, List subItems) {
        for (int x = 0; x <= 5; ++x) {
            subItems.add(new ItemStack(par1, 1, x));
        }
    }

    public void func_149719_a(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntityBookcase bookcaseTile = (TileEntityBookcase)blockAccess.func_147438_o(i, j, k);
        if (bookcaseTile != null) {
            this.shelfAngle = bookcaseTile.getAngle();
            if (bookcaseTile.getShift()) {
                switch (this.shelfAngle) {
                    case 0: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                }
            } else {
                switch (this.shelfAngle) {
                    case 0: {
                        this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 1: {
                        this.func_149676_a(0.0f, 0.0f, 0.5f, 1.0f, 1.0f, 1.0f);
                        break;
                    }
                    case 2: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 0.5f, 1.0f, 1.0f);
                        break;
                    }
                    case 3: {
                        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.5f);
                        break;
                    }
                }
            }
        } else {
            this.func_149676_a(0.5f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149645_b() {
        return ClientProxy.bookrenderID;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean func_149727_a(World world, int i, int j, int k, EntityPlayer player, int face, float hitX, float hitY, float hitZ) {
        TileEntityBookcase tileBookCase = (TileEntityBookcase)world.func_147438_o(i, j, k);
        String playername = player.getDisplayName();
        boolean islocked = false;
        String lockeename = "";
        if (tileBookCase != null) {
            islocked = tileBookCase.isLocked();
            lockeename = tileBookCase.getLockee();
        }
        if (world.field_72995_K) {
            ItemStack playerhand = player.func_70694_bm();
            if (playerhand == null) return true;
            if (!(playerhand.func_77973_b() instanceof ItemDrill)) return true;
            return false;
        }
        ItemStack playerhand = player.func_70694_bm();
        if (playerhand != null && playerhand.func_77977_a().contains("BiblioCreativeLock") && tileBookCase != null) {
            if (!islocked) {
                tileBookCase.setLocked(true);
                tileBookCase.setLockee(playername);
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.locked")));
                return true;
            }
            if (playername.contains(lockeename)) {
                tileBookCase.setLocked(false);
                player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.unlocked")));
                return true;
            }
            player.func_146105_b((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"lock.notowner")));
            return true;
        }
        if (islocked) {
            if (!playername.contains(lockeename)) return true;
        }
        if (tileBookCase == null) {
            return false;
        }
        if (playerhand != null && playerhand.func_77973_b() instanceof ItemDrill) {
            return false;
        }
        if (tileBookCase == null) return true;
        int yCheck = (int)(hitY * 2.0f);
        int angle = tileBookCase.getAngle();
        if (yCheck == 1) {
            int booktest = this.isWhatBook(angle, hitX, hitZ);
            if (player.func_70093_af()) {
                if (booktest < 0) return true;
                if (booktest >= 16) return true;
                this.dropBook(world, i, j, k, booktest);
                tileBookCase.setBook(booktest, null);
                return true;
            }
            if (playerhand != null) {
                if (!Config.isBlock(playerhand) && Config.testBookValidity(playerhand)) {
                    boolean addedBook;
                    if (booktest >= 0 && booktest < 16 && (addedBook = tileBookCase.setBook(booktest, playerhand))) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        return true;
                    }
                } else {
                    player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                    return true;
                }
            }
        } else if (yCheck == 0) {
            int booktest = this.isWhatBook(angle, hitX, hitZ) + 8;
            if (player.func_70093_af()) {
                if (booktest < 0) return true;
                if (booktest >= 16) return true;
                this.dropBook(world, i, j, k, booktest);
                tileBookCase.setBook(booktest, null);
                return true;
            }
            if (playerhand != null) {
                if (!Config.isBlock(playerhand) && Config.testBookValidity(playerhand)) {
                    boolean addedBook;
                    if (booktest >= 0 && booktest < 16 && (addedBook = tileBookCase.setBook(booktest, playerhand))) {
                        player.field_71071_by.field_70462_a[player.field_71071_by.field_70461_c] = null;
                        return true;
                    }
                } else {
                    player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
                    return true;
                }
            }
        }
        player.openGui((Object)BiblioCraft.instance, 0, world, i, j, k);
        return true;
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase player, ItemStack itemStack) {
        int angle = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        ++angle;
        this.bookcaseAngle = angle %= 4;
        TileEntityBookcase tileBookCase = (TileEntityBookcase)world.func_147438_o(i, j, k);
        tileBookCase.setAngle(this.bookcaseAngle);
    }

    public void func_149749_a(World world, int i, int j, int k, Block par5, int par6) {
        this.dropItems(world, i, j, k);
        super.func_149749_a(world, i, j, k, par5, par6);
    }

    private void dropItems(World world, int i, int j, int k) {
        Random rando = new Random();
        TileEntity tileEntity = world.func_147438_o(i, j, k);
        if (!(tileEntity instanceof IInventory)) {
            return;
        }
        IInventory inventory = (IInventory)tileEntity;
        for (int x = 0; x < inventory.func_70302_i_(); ++x) {
            ItemStack item = inventory.func_70301_a(x);
            if (item == null || item.field_77994_a <= 0) continue;
            float ri = rando.nextFloat() * 0.8f + 0.1f;
            float rj = rando.nextFloat() * 0.8f + 0.1f;
            float rk = rando.nextFloat() * 0.8f + 0.1f;
            EntityItem entityItem = new EntityItem(world, (double)((float)i + ri), (double)((float)j + rj), (double)((float)k + rk), new ItemStack(item.func_77973_b(), item.field_77994_a, item.func_77960_j()));
            if (item.func_77942_o()) {
                entityItem.func_92059_d().func_77982_d((NBTTagCompound)item.func_77978_p().func_74737_b());
            }
            float factor = 0.05f;
            entityItem.field_70159_w = rando.nextGaussian() * (double)factor;
            entityItem.field_70181_x = rando.nextGaussian() * (double)factor + (double)0.2f;
            entityItem.field_70179_y = rando.nextGaussian() * (double)factor;
            world.func_72838_d((Entity)entityItem);
            item.field_77994_a = 0;
        }
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public TileEntity func_149915_a(World world, int var2) {
        try {
            return new TileEntityBookcase();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random rando) {
        super.func_149734_b(world, x, y, z, rando);
        TileEntityBookcase bookcase = (TileEntityBookcase)world.func_147438_o(x, y, z);
        if (bookcase != null && bookcase.getFilledSlots() > 0) {
            for (int i = x - 2; i <= x + 2; ++i) {
                block1: for (int j = z - 2; j <= z + 2; ++j) {
                    if (i > x - 2 && i < x + 2 && j == z - 1) {
                        j = z + 2;
                    }
                    if (rando.nextInt(16) != 0) continue;
                    for (int k = y; k <= y + 1; ++k) {
                        if (world.func_147439_a(i, k, j) != Blocks.field_150381_bn) continue;
                        if (!world.func_147437_c((i - x) / 2 + x, k, (j - z) / 2 + z)) continue block1;
                        double px = (double)i + 0.5;
                        double py = (double)k + 2.0;
                        double pz = (double)j + 0.5;
                        double velx = (double)((float)(x - i) + rando.nextFloat()) - 0.5;
                        double vely = (float)(y - k) - rando.nextFloat() - 1.0f;
                        double velz = (double)((float)(z - j) + rando.nextFloat()) - 0.5;
                        world.func_72869_a("enchantmenttable", px, py, pz, velx, vely, velz);
                    }
                }
            }
        }
    }

    public boolean rotateBlock(World world, int x, int y, int z, ForgeDirection axis) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile != null && tile instanceof TileEntityBookcase) {
            TileEntityBookcase te = (TileEntityBookcase)tile;
            int angle = te.getAngle();
            switch (axis) {
                case NORTH: {
                    te.setAngle(1);
                    break;
                }
                case EAST: {
                    te.setAngle(2);
                    break;
                }
                case SOUTH: {
                    te.setAngle(3);
                    break;
                }
                case WEST: {
                    te.setAngle(0);
                    break;
                }
                case UP: {
                    if (angle <= 0) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle - 1);
                    break;
                }
                case DOWN: {
                    if (angle >= 3) {
                        te.setAngle(0);
                        break;
                    }
                    te.setAngle(angle + 1);
                    break;
                }
                case UNKNOWN: {
                    return false;
                }
                default: {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public ForgeDirection[] getValidRotations(World worldObj, int x, int y, int z) {
        ForgeDirection[] axises = new ForgeDirection[]{ForgeDirection.UP, ForgeDirection.DOWN};
        return axises;
    }
}

