/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import jds.bibliocraft.CommonProxy;
import jds.bibliocraft.Config;
import jds.bibliocraft.models.ModelWritingDesk;
import jds.bibliocraft.tileentities.TileEntityWritingDesk;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import org.lwjgl.opengl.GL11;

public class TileEntityWritingDeskRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation mapBackGroundResource = new ResourceLocation("textures/map/map_background.png");
    private ModelWritingDesk deskModel = new ModelWritingDesk();
    private int deskAngle;
    private int degreeAngle;
    private int leftStack;
    private int rightStack;
    private boolean writeBook;
    private boolean hasMap = false;
    private ItemStack bookStack;
    private RenderManager renderManager = RenderManager.field_78727_a;
    private Minecraft mc = Minecraft.func_71410_x();

    public void func_147500_a(TileEntity tileEntity, double i, double j, double k, float tick) {
        ItemStack stack;
        TileEntityWritingDesk deskTile = (TileEntityWritingDesk)tileEntity;
        this.deskAngle = deskTile.getAngle();
        this.leftStack = deskTile.getLeftBookStack();
        this.rightStack = deskTile.getRightBookStack();
        this.writeBook = deskTile.hasWrittenBook();
        this.bookStack = deskTile.func_70301_a(0);
        this.hasMap = deskTile.getHasMap();
        switch (this.deskAngle) {
            case 0: {
                this.degreeAngle = 270;
                break;
            }
            case 1: {
                this.degreeAngle = 180;
                break;
            }
            case 2: {
                this.degreeAngle = 90;
                break;
            }
            case 3: {
                this.degreeAngle = 0;
                break;
            }
        }
        GL11.glPushMatrix();
        GL11.glTranslated((double)(i + 0.5), (double)(j + 1.0), (double)(k + 0.5));
        GL11.glRotatef((float)this.degreeAngle, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        int texNum = tileEntity.func_145832_p();
        this.func_147499_a(this.getModelTexture(texNum));
        this.deskModel.renderDesk();
        this.func_147499_a(CommonProxy.WRITINGDESKBOOKS_PNG);
        if (this.writeBook && !this.hasMap) {
            this.deskModel.renderWrittenBook();
        }
        switch (this.leftStack) {
            case 1: {
                this.deskModel.renderLBook1();
                break;
            }
            case 2: {
                this.deskModel.renderLBook2();
                break;
            }
            case 3: {
                this.deskModel.renderLBook3();
                break;
            }
            case 4: {
                this.deskModel.renderLBook4();
                break;
            }
        }
        switch (this.rightStack) {
            case 1: {
                this.deskModel.renderRBook1();
                break;
            }
            case 2: {
                this.deskModel.renderRBook2();
                break;
            }
            case 3: {
                this.deskModel.renderRBook3();
                break;
            }
            case 4: {
                this.deskModel.renderRBook4();
                break;
            }
        }
        GL11.glEnable((int)2896);
        if (this.writeBook && deskTile.showBookName() && (stack = deskTile.getOpenBook()) != null) {
            String bookname = stack.func_82833_r();
            this.renderText(bookname);
            deskTile.setShowBookName(false);
        }
        GL11.glPopMatrix();
        if (this.hasMap) {
            double mapOffsetx = 0.0;
            double mapOffsetz = 0.0;
            switch (this.degreeAngle) {
                case 0: {
                    this.degreeAngle += 90;
                    mapOffsetx = -0.175;
                    mapOffsetz = 0.18;
                    break;
                }
                case 180: {
                    this.degreeAngle -= 90;
                    mapOffsetx = -0.18;
                    mapOffsetz = -0.16;
                    break;
                }
                case 270: {
                    this.degreeAngle -= 180;
                    mapOffsetx = -0.35;
                    break;
                }
            }
            EntityItem slot1Entity = new EntityItem(tileEntity.func_145831_w(), 0.0, 0.0, 0.0, this.bookStack);
            GL11.glPushMatrix();
            this.renderManager.field_78724_e.func_110577_a(mapBackGroundResource);
            Tessellator tessellator = Tessellator.field_78398_a;
            GL11.glTranslated((double)(i + 0.68 + mapOffsetx), (double)(j + 1.001), (double)(k + 0.67 + mapOffsetz));
            GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)(this.degreeAngle - 90), (float)0.0f, (float)0.0f, (float)1.0f);
            float mapScale = 0.004166667f;
            GL11.glScalef((float)mapScale, (float)mapScale, (float)mapScale);
            GL11.glTranslatef((float)-65.0f, (float)-107.0f, (float)-3.0f);
            GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
            tessellator.func_78382_b();
            int b0 = 7;
            tessellator.func_78374_a((double)(0 - b0), (double)(128 + b0), 0.0, 0.0, 1.0);
            tessellator.func_78374_a((double)(128 + b0), (double)(128 + b0), 0.0, 1.0, 1.0);
            tessellator.func_78374_a((double)(128 + b0), (double)(0 - b0), 0.0, 1.0, 0.0);
            tessellator.func_78374_a((double)(0 - b0), (double)(0 - b0), 0.0, 0.0, 0.0);
            tessellator.func_78381_a();
            MapData mapdata = Items.field_151098_aY.func_77873_a(slot1Entity.func_92059_d(), tileEntity.func_145831_w());
            if (mapdata == null) {
                // empty if block
            }
            if (mapdata != null) {
                this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, true);
            }
            GL11.glPopMatrix();
        }
    }

    public void renderText(String text) {
        FontRenderer fontRender = this.func_147498_b();
        GL11.glDepthMask((boolean)false);
        GL11.glScalef((float)0.005f, (float)0.005f, (float)0.005f);
        GL11.glTranslated((double)0.0, (double)15.0, (double)-100.5);
        int adjust = fontRender.func_78256_a(text) / 2;
        fontRender.func_85187_a(text, -adjust, -8, Config.color, Config.textshadow);
        GL11.glDepthMask((boolean)true);
    }

    public ResourceLocation getModelTexture(int metadata) {
        switch (metadata) {
            case 0: {
                return CommonProxy.WRITINGDESK1_PNG;
            }
            case 1: {
                return CommonProxy.WRITINGDESK2_PNG;
            }
            case 2: {
                return CommonProxy.WRITINGDESK3_PNG;
            }
            case 3: {
                return CommonProxy.WRITINGDESK4_PNG;
            }
            case 4: {
                return CommonProxy.WRITINGDESK5_PNG;
            }
            case 5: {
                return CommonProxy.WRITINGDESK6_PNG;
            }
        }
        return CommonProxy.WRITINGDESK1_PNG;
    }
}

