/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeAcacia
extends WorldGenHighlandsTreeBase {
    public WorldGenTreeAcacia(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreeAcacia(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.acaciaWood, HighlandsBlocks.acaciaLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.leaves = Blocks.field_150362_t;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        this.world = world;
        this.random = random;
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 2, 6)) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        for (int i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
        }
        int h = locY + treeHeight - 1;
        this.generateLeafLayerCircle(world, random, 5.5, locX, locZ, h);
        this.generateLeafLayerCircle(world, random, 4.5, locX, locZ, ++h);
        h = locY + treeHeight - 6;
        int[] xyz = this.generateStraightBranch(world, random, 4, locX, h, locZ, random.nextInt(4));
        this.generateLeafLayerCircle(world, random, 4.5, xyz[0], xyz[2], xyz[1]);
        this.generateLeafLayerCircle(world, random, 3.5, xyz[0], xyz[2], xyz[1] + 1);
        return true;
    }
}

