/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeMangrove
extends WorldGenHighlandsTreeBase {
    public WorldGenTreeMangrove(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreeMangrove(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.mangroveWood, HighlandsBlocks.mangroveLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.woodMeta = 2;
            this.leaves = Blocks.field_150362_t;
            this.leavesMeta = 2;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        int i;
        this.world = world;
        this.random = random;
        if (locY < 62 && !this.notifyFlag) {
            locY = 62;
        }
        if (world.func_147439_a(locX, locY - 1, locZ) != Blocks.field_150349_c && world.func_147439_a(locX, locY - 1, locZ) != Blocks.field_150346_d && world.func_147439_a(locX, locY - 1, locZ) != Blocks.field_150354_m && world.func_147439_a(locX, locY - 1, locZ) != Blocks.field_150355_j) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 2, locZ, 0, 3)) {
            return false;
        }
        int waterH = 0;
        boolean var6 = false;
        while ((world.func_147439_a(locX, locY - waterH, locZ) == Blocks.field_150350_a || world.func_147439_a(locX, locY - waterH, locZ) == Blocks.field_150362_t || world.func_147439_a(locX, locY - waterH, locZ) == Blocks.field_150355_j) && locY - waterH > 0) {
            ++waterH;
        }
        if (waterH > 4) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight) - 2;
        ++locY;
        for (i = 0; i < treeHeight; ++i) {
            this.setBlockInWorld(locX, locY + i, locZ, this.wood, this.woodMeta);
        }
        for (i = -1; i > -7; --i) {
            this.setBlockInWorld(locX + i, locY + i, locZ, this.wood, this.woodMeta);
            this.setBlockInWorld(locX - i, locY + i, locZ, this.wood, this.woodMeta);
            this.setBlockInWorld(locX, locY + i, locZ + i, this.wood, this.woodMeta);
            this.setBlockInWorld(locX, locY + i, locZ - i, this.wood, this.woodMeta);
        }
        int h = locY + treeHeight - 1;
        this.generateLeafLayerCircle(world, random, 3.5, locX, locZ, h);
        this.generateLeafLayerCircle(world, random, 2.5, locX, locZ, ++h);
        this.generateLeafLayerCircle(world, random, 1.0, locX, locZ, ++h);
        return true;
    }
}

