/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen;

import highlands.Highlands;
import highlands.api.HighlandsBlocks;
import highlands.worldgen.WorldGenHighlandsTreeBase;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class WorldGenTreeRedwood
extends WorldGenHighlandsTreeBase {
    public WorldGenTreeRedwood(int lmd, int wmd, Block wb, Block lb, int minH, int maxH, boolean notify) {
        super(lmd, wmd, wb, lb, notify);
        this.minHeight = minH;
        this.maxHeight = maxH;
    }

    public WorldGenTreeRedwood(int minH, int maxH, boolean notify) {
        this(0, 0, HighlandsBlocks.redwoodWood, HighlandsBlocks.redwoodLeaves, minH, maxH, notify);
        if (Highlands.vanillaBlocksFlag) {
            this.wood = Blocks.field_150364_r;
            this.leaves = Blocks.field_150362_t;
            this.leavesMeta = 1;
        }
    }

    @Override
    public boolean func_76484_a(World world, Random random, int locX, int locY, int locZ) {
        double r;
        this.world = world;
        this.random = random;
        if (!this.isLegalTreePosition(world, locX, locY, locZ)) {
            return false;
        }
        if (!this.isCubeClear(locX, locY + 3, locZ, 4, 20)) {
            return false;
        }
        int treeHeight = this.minHeight + random.nextInt(this.maxHeight);
        double theta = Math.atan(2.8 / (double)treeHeight);
        for (int i = -3; i <= treeHeight; ++i) {
            r = (double)(treeHeight - i) * Math.tan(theta);
            this.generateWoodLayerCircle(world, random, r, locX, locZ, locY + i);
        }
        int h = locY + treeHeight - 5;
        r = 2.0;
        for (int i = 0; i < 6; ++i) {
            this.generateSequoiaBranch(world, random, r, locX, locZ, h);
            h -= 3;
            if (!(r < 6.0)) continue;
            r += 1.0;
        }
        h = locY + treeHeight - 2;
        this.generateLeafLayerCircleNoise(world, random, 3.5, locX, locZ, h);
        this.generateLeafLayerCircleNoise(world, random, 2.5, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 2.0, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 1.5, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 1.0, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 0.0, locX, locZ, ++h);
        this.generateLeafLayerCircleNoise(world, random, 0.0, locX, locZ, ++h);
        return true;
    }
}

