/*
 * Decompiled with CFR 0.152.
 */
package highlands.worldgen.layer;

import com.google.common.collect.ObjectArrays;
import highlands.Highlands;
import highlands.Logs;
import highlands.api.HighlandsBiomes;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;
import org.apache.logging.log4j.Level;

public class GenLayerBiomeHL
extends GenLayer {
    private BiomeGenBase[] heatBiomes = new BiomeGenBase[]{BiomeGenBase.field_76769_d, BiomeGenBase.field_76769_d, BiomeGenBase.field_76769_d, BiomeGenBase.field_150588_X, BiomeGenBase.field_150588_X, BiomeGenBase.field_76772_c};
    private BiomeGenBase[] warmBiomes = new BiomeGenBase[]{BiomeGenBase.field_76767_f, BiomeGenBase.field_150585_R, BiomeGenBase.field_76770_e, BiomeGenBase.field_76772_c, BiomeGenBase.field_150583_P, BiomeGenBase.field_76780_h};
    private BiomeGenBase[] coolBiomes = new BiomeGenBase[]{BiomeGenBase.field_76767_f, BiomeGenBase.field_76770_e, BiomeGenBase.field_76768_g, BiomeGenBase.field_76772_c};
    private BiomeGenBase[] iceBiomes = new BiomeGenBase[]{BiomeGenBase.field_76774_n, BiomeGenBase.field_76774_n, BiomeGenBase.field_76774_n, BiomeGenBase.field_150584_S};

    public GenLayerBiomeHL(long par1, GenLayer par3GenLayer, WorldType par4WorldType) {
        super(par1);
        this.field_75909_a = par3GenLayer;
        if (par4WorldType == WorldType.field_77136_e) {
            this.heatBiomes = new BiomeGenBase[]{BiomeGenBase.field_76769_d, BiomeGenBase.field_76767_f, BiomeGenBase.field_76770_e, BiomeGenBase.field_76780_h, BiomeGenBase.field_76772_c, BiomeGenBase.field_76768_g};
        }
        if (HighlandsBiomes.biomesForHighlands.size() == 0) {
            Logs.log(Level.FATAL, "[Highlands] no biomes loaded");
            return;
        }
        this.addBiome(HighlandsBiomes.woodsMountains, Mode.WARM);
        this.addBiome(HighlandsBiomes.highlandsb, Mode.WARM);
        this.addBiome(HighlandsBiomes.tundra, Mode.ICE);
        this.addBiome(HighlandsBiomes.cliffs, Mode.WARM);
        this.addBiome(HighlandsBiomes.pinelands, Mode.WARM);
        this.addBiome(HighlandsBiomes.autumnForest, Mode.WARM);
        this.addBiome(HighlandsBiomes.alps, Mode.ICE);
        this.addBiome(HighlandsBiomes.tallPineForest, Mode.WARM);
        this.addBiome(HighlandsBiomes.meadow, Mode.WARM);
        this.addBiome(HighlandsBiomes.savannah, Mode.HEAT);
        this.addBiome(HighlandsBiomes.tropics, Mode.HEAT);
        this.addBiome(HighlandsBiomes.outback, Mode.HEAT);
        this.addBiome(HighlandsBiomes.woodlands, Mode.WARM);
        this.addBiome(HighlandsBiomes.bog, Mode.COOL);
        this.addBiome(HighlandsBiomes.redwoodForest, Mode.WARM);
        this.addBiome(HighlandsBiomes.dunes, Mode.HEAT);
        this.addBiome(HighlandsBiomes.lowlands, Mode.WARM);
        this.addBiome(HighlandsBiomes.sahel, Mode.WARM);
        this.addBiome(HighlandsBiomes.birchHills, Mode.WARM);
        this.addBiome(HighlandsBiomes.tropicalIslands, Mode.HEAT);
        this.addBiome(HighlandsBiomes.rainforest, Mode.HEAT);
        this.addBiome(HighlandsBiomes.estuary, Mode.WARM);
        this.addBiome(HighlandsBiomes.badlands, Mode.HEAT);
        this.addBiome(HighlandsBiomes.flyingMountains, Mode.WARM);
        this.addBiome(HighlandsBiomes.snowMountains, Mode.ICE);
        this.addBiome(HighlandsBiomes.rockMountains, Mode.WARM);
        this.addBiome(HighlandsBiomes.desertMountains, Mode.WARM);
        this.addBiome(HighlandsBiomes.steppe, Mode.ICE);
        this.addBiome(HighlandsBiomes.glacier, Mode.ICE);
    }

    public int[] func_75904_a(int par1, int par2, int par3, int par4) {
        int[] aint = this.field_75909_a.func_75904_a(par1, par2, par3, par4);
        int[] aint1 = IntCache.func_76445_a((int)(par3 * par4));
        for (int i1 = 0; i1 < par4; ++i1) {
            for (int j1 = 0; j1 < par3; ++j1) {
                this.func_75903_a(j1 + par1, i1 + par2);
                int k1 = aint[j1 + i1 * par3];
                int l1 = (k1 & 0xF00) >> 8;
                if ((k1 &= 0xFFFFF0FF) < 0) {
                    k1 = 0;
                }
                if (GenLayerBiomeHL.isBiomeOceanic(k1)) {
                    if (k1 == 0 && Highlands.improvedOceans) {
                        k1 = HighlandsBiomes.ocean2.field_76756_M;
                    }
                    aint1[j1 + i1 * par3] = k1;
                } else {
                    aint1[j1 + i1 * par3] = k1 == BiomeGenBase.field_76789_p.field_76756_M ? k1 : (k1 == 1 ? (l1 > 0 ? (this.func_75902_a(3) == 0 ? BiomeGenBase.field_150608_ab.field_76756_M : BiomeGenBase.field_150607_aa.field_76756_M) : this.heatBiomes[this.func_75902_a((int)this.heatBiomes.length)].field_76756_M) : (k1 == 2 ? (l1 > 0 ? BiomeGenBase.field_76782_w.field_76756_M : this.warmBiomes[this.func_75902_a((int)this.warmBiomes.length)].field_76756_M) : (k1 == 3 ? (l1 > 0 ? BiomeGenBase.field_150578_U.field_76756_M : this.coolBiomes[this.func_75902_a((int)this.coolBiomes.length)].field_76756_M) : (k1 == 4 ? this.iceBiomes[this.func_75902_a((int)this.iceBiomes.length)].field_76756_M : BiomeGenBase.field_76789_p.field_76756_M))));
                }
                if (k1 >= 0 && aint1[j1 + i1 * par3] >= 0) continue;
                aint1[j1 + i1 * par3] = k1 = 0;
            }
        }
        return aint1;
    }

    public void addBiome(BiomeGenBase biome, Mode mode) {
        switch (mode.ordinal()) {
            case 1: {
                this.heatBiomes = (BiomeGenBase[])ObjectArrays.concat((Object[])this.heatBiomes, (Object)biome);
                return;
            }
            default: {
                this.warmBiomes = (BiomeGenBase[])ObjectArrays.concat((Object[])this.warmBiomes, (Object)biome);
                return;
            }
            case 3: {
                this.coolBiomes = (BiomeGenBase[])ObjectArrays.concat((Object[])this.coolBiomes, (Object)biome);
                return;
            }
            case 4: 
        }
        this.iceBiomes = (BiomeGenBase[])ObjectArrays.concat((Object[])this.iceBiomes, (Object)biome);
    }

    protected static boolean isBiomeOceanic(int biomeID) {
        return biomeID == BiomeGenBase.field_76771_b.field_76756_M || biomeID == BiomeGenBase.field_150575_M.field_76756_M || biomeID == BiomeGenBase.field_76776_l.field_76756_M || biomeID == HighlandsBiomes.ocean2.field_76756_M;
    }

    public static enum Mode {
        HEAT,
        WARM,
        COOL,
        ICE;

    }
}

