/*
 * Decompiled with CFR 0.152.
 */
package fabricator77.multiworld.api.biomeregistry;

import com.google.common.collect.ObjectArrays;
import fabricator77.multiworld.api.biomeregistry.AdvancedBiomeEntry;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenMesa;
import net.minecraftforge.common.BiomeManager;

public class AdvancedBiomeRegistry {
    public static AdvancedBiomeEntry[] biomeEntries = new AdvancedBiomeEntry[BiomeGenBase.func_150565_n().length];

    public static BiomeManager.BiomeEntry[] getBiomesOfType(String type) {
        Object[] biomeList = new BiomeManager.BiomeEntry[]{};
        for (int i = 0; i < biomeEntries.length; ++i) {
            if (biomeEntries[i] == null || AdvancedBiomeRegistry.biomeEntries[i].type != type) continue;
            biomeList = (BiomeManager.BiomeEntry[])ObjectArrays.concat((Object[])biomeList, (Object)((Object)biomeEntries[i]));
        }
        return biomeList;
    }

    public static BiomeManager.BiomeEntry[] getBiomesOfType(String type, String mod) {
        Object[] biomeList = new BiomeManager.BiomeEntry[]{};
        for (int i = 0; i < biomeEntries.length; ++i) {
            if (biomeEntries[i] == null || AdvancedBiomeRegistry.biomeEntries[i].type != type || AdvancedBiomeRegistry.biomeEntries[i].modName != mod) continue;
            biomeList = (BiomeManager.BiomeEntry[])ObjectArrays.concat((Object[])biomeList, (Object)((Object)biomeEntries[i]));
        }
        return biomeList;
    }

    public static void addBiome(AdvancedBiomeEntry advBiome, String type, boolean defaultBeach) {
        advBiome.type = type;
        if (defaultBeach) {
            advBiome.beachBiome = BiomeGenBase.field_76787_r.field_76756_M;
        }
        AdvancedBiomeRegistry.biomeEntries[advBiome.biome.field_76756_M] = advBiome;
    }

    public static void addBiome(BiomeManager.BiomeEntry biome, String type, boolean defaultBeach, String mod) {
        AdvancedBiomeEntry advBiome = new AdvancedBiomeEntry(biome.biome, biome.field_76292_a, mod);
        advBiome.type = type;
        if (defaultBeach) {
            advBiome.beachBiome = BiomeGenBase.field_76787_r.field_76756_M;
        }
        AdvancedBiomeRegistry.biomeEntries[biome.biome.field_76756_M] = advBiome;
    }

    public static void addSubBiomeToBiome(BiomeGenBase subBiome, BiomeGenBase parentBiome) {
        if (subBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.addSubBiomeToBiome(new BiomeManager.BiomeEntry(subBiome, 10), parentBiome);
    }

    public static void addSubBiomeToBiome(BiomeManager.BiomeEntry subBiome, BiomeGenBase parentBiome) {
        if (subBiome == null || parentBiome == null) {
            return;
        }
        if (biomeEntries[parentBiome.field_76756_M] == null) {
            throw new NullPointerException("parent biome " + parentBiome.field_76791_y + " not registered properly");
        }
        if (AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].subBiomes == null) {
            // empty if block
        }
        AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].subBiomes = (BiomeManager.BiomeEntry[])ObjectArrays.concat((Object[])AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].subBiomes, (Object)subBiome);
    }

    public static void addHillsBiomeToBiome(BiomeGenBase hillsBiome, BiomeGenBase parentBiome) {
        if (hillsBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.addHillsBiomeToBiome(new BiomeManager.BiomeEntry(hillsBiome, 10), parentBiome);
    }

    public static void addHillsBiomeToBiome(BiomeManager.BiomeEntry hillsBiome, BiomeGenBase parentBiome) {
        if (hillsBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].hillsBiomes = (BiomeManager.BiomeEntry[])ObjectArrays.concat((Object[])AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].hillsBiomes, (Object)hillsBiome);
    }

    public static void setRiverBiomeToBiome(BiomeGenBase riverBiome, BiomeGenBase parentBiome) {
        if (riverBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].riverBiome = riverBiome.field_76756_M;
    }

    public static void setRiverBiomeToBiome(BiomeManager.BiomeEntry riverBiome, BiomeGenBase parentBiome) {
        AdvancedBiomeRegistry.setRiverBiomeToBiome(riverBiome.biome, parentBiome);
    }

    public static void setEdgeBiomeToBiome(BiomeGenBase edgeBiome, BiomeGenBase parentBiome) {
        if (edgeBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].edgeBiome = edgeBiome.field_76756_M;
    }

    public static void setEdgeBiomeToBiome(BiomeManager.BiomeEntry edgeBiome, BiomeGenBase parentBiome) {
        AdvancedBiomeRegistry.setEdgeBiomeToBiome(edgeBiome.biome, parentBiome);
    }

    public static void setBeachBiomeToBiome(BiomeGenBase beachBiome, BiomeGenBase parentBiome) {
        if (beachBiome == null || parentBiome == null) {
            return;
        }
        AdvancedBiomeRegistry.biomeEntries[parentBiome.field_76756_M].beachBiome = beachBiome.field_76756_M;
    }

    public static void addBeachBiomeToBiome(BiomeManager.BiomeEntry beachBiome, BiomeGenBase parentBiome) {
        AdvancedBiomeRegistry.setBeachBiomeToBiome(beachBiome.biome, parentBiome);
    }

    public static void setBiomeWeight(BiomeManager.BiomeEntry biome, int weight) {
        biome.field_76292_a = weight;
    }

    private static void registerVanillaSubBiome(BiomeGenBase biome) {
        BiomeManager.BiomeEntry subBiome = new BiomeManager.BiomeEntry(BiomeGenBase.func_150568_d((int)(biome.field_76756_M + 128)), 10);
        AdvancedBiomeRegistry.addBiome(subBiome, "sub", true, "Minecraft");
        AdvancedBiomeRegistry.addSubBiomeToBiome(subBiome, biome);
    }

    private static void registerColdBeach() {
        for (int i = 0; i < biomeEntries.length; ++i) {
            if (biomeEntries[i] == null || !AdvancedBiomeRegistry.biomeEntries[i].biome.func_150559_j()) continue;
            AdvancedBiomeRegistry.biomeEntries[i].beachBiome = BiomeGenBase.field_150577_O.field_76756_M;
        }
    }

    private static void registerEdgeForMesa() {
        for (int i = 0; i < biomeEntries.length; ++i) {
            if (biomeEntries[i] == null || !(AdvancedBiomeRegistry.biomeEntries[i].biome instanceof BiomeGenMesa)) continue;
            AdvancedBiomeRegistry.biomeEntries[i].edgeBiome = BiomeGenBase.field_76769_d.field_76756_M;
        }
    }

    static {
        String mod = "Minecraft";
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76771_b, 30), "ocean", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150575_M, 30), "ocean", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76776_l, 30), "ocean", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76769_d, 30), "hot", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150588_X, 20), "hot", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76772_c, 10), "hot", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150607_aa, 3), "hot", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150608_ab, 7), "hot", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76767_f, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150585_R, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76770_e, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76772_c, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150583_P, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76780_h, 10), "warm", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76782_w, 10), "warm", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76767_f, 10), "cool", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76770_e, 10), "cool", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76768_g, 10), "cool", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76772_c, 10), "cool", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150578_U, 10), "cool", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76774_n, 30), "ice", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150584_S, 10), "ice", true, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76792_x, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76792_x, BiomeGenBase.field_76782_w);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150582_Q, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150582_Q, BiomeGenBase.field_150583_P);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150579_T, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150579_T, BiomeGenBase.field_150584_S);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76786_s, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76786_s, BiomeGenBase.field_76769_d);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76785_t, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76785_t, BiomeGenBase.field_76767_f);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76785_t, BiomeGenBase.field_76772_c);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76767_f, 20), BiomeGenBase.field_76772_c);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150581_V, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150581_V, BiomeGenBase.field_150578_U);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76784_u, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76784_u, BiomeGenBase.field_76768_g);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76775_o, 10), "hills", false, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_76775_o, BiomeGenBase.field_76774_n);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150580_W, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150580_W, BiomeGenBase.field_76770_e);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150587_Y, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150587_Y, BiomeGenBase.field_150588_X);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150589_Z, 10), "hills", true, mod);
        AdvancedBiomeRegistry.addHillsBiomeToBiome(BiomeGenBase.field_150589_Z, BiomeGenBase.field_150607_aa);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150574_L, 10), "edge", false, mod);
        AdvancedBiomeRegistry.setEdgeBiomeToBiome(BiomeGenBase.field_150574_L, BiomeGenBase.field_76782_w);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76783_v, 10), "edge", false, mod);
        AdvancedBiomeRegistry.setEdgeBiomeToBiome(BiomeGenBase.field_76783_v, BiomeGenBase.field_76770_e);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76772_c);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76769_d);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76767_f);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76768_g);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76780_h);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76774_n);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76782_w);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150574_L);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150584_S);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150588_X);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150587_Y);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150589_Z);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150607_aa);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150608_ab);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150583_P);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150582_Q);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150585_R);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150578_U);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_76770_e);
        AdvancedBiomeRegistry.registerVanillaSubBiome(BiomeGenBase.field_150580_W);
        AdvancedBiomeRegistry.addSubBiomeToBiome(BiomeGenBase.func_150568_d((int)(BiomeGenBase.field_150578_U.field_76756_M + 128)), BiomeGenBase.field_150581_V);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76787_r, 10), "beach", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150576_N, 10), "beach", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150577_O, 10), "beach", false, mod);
        AdvancedBiomeRegistry.registerColdBeach();
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_150576_N, 10), "beach", false, mod);
        AdvancedBiomeRegistry.setBeachBiomeToBiome(BiomeGenBase.field_150576_N, BiomeGenBase.field_76770_e);
        AdvancedBiomeRegistry.setBeachBiomeToBiome(BiomeGenBase.field_150576_N, BiomeGenBase.field_150580_W);
        AdvancedBiomeRegistry.setBeachBiomeToBiome(BiomeGenBase.field_150576_N, BiomeGenBase.field_76783_v);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76781_i, 10), "river", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76777_m, 10), "river", false, mod);
        AdvancedBiomeRegistry.setRiverBiomeToBiome(BiomeGenBase.field_76777_m, BiomeGenBase.field_76774_n);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76789_p, 10), "mushroomIsland", false, mod);
        AdvancedBiomeRegistry.addBiome(new BiomeManager.BiomeEntry(BiomeGenBase.field_76788_q, 10), "beach", false, mod);
        AdvancedBiomeRegistry.setBeachBiomeToBiome(BiomeGenBase.field_76788_q, BiomeGenBase.field_76789_p);
        AdvancedBiomeRegistry.registerEdgeForMesa();
    }
}

