/*
 * Decompiled with CFR 0.152.
 */
package highlands;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.registry.GameRegistry;
import highlands.Config;
import highlands.Highlands;
import highlands.api.HighlandsBiomes;
import highlands.api.HighlandsBlocks;
import highlands.biome.BiomeGenAlps;
import highlands.biome.BiomeGenAutumnForest;
import highlands.biome.BiomeGenBadlands;
import highlands.biome.BiomeGenBaldHill;
import highlands.biome.BiomeGenBaseHighlands;
import highlands.biome.BiomeGenBirchHills;
import highlands.biome.BiomeGenBog;
import highlands.biome.BiomeGenCliffs;
import highlands.biome.BiomeGenDesertIsland;
import highlands.biome.BiomeGenDesertMountains;
import highlands.biome.BiomeGenDunes;
import highlands.biome.BiomeGenEstuary;
import highlands.biome.BiomeGenFlyingMountains;
import highlands.biome.BiomeGenGlacier;
import highlands.biome.BiomeGenHighlands;
import highlands.biome.BiomeGenLake;
import highlands.biome.BiomeGenLowlands;
import highlands.biome.BiomeGenMeadow;
import highlands.biome.BiomeGenMesa;
import highlands.biome.BiomeGenOasis;
import highlands.biome.BiomeGenOcean2;
import highlands.biome.BiomeGenOutback;
import highlands.biome.BiomeGenPinelands;
import highlands.biome.BiomeGenRainforest;
import highlands.biome.BiomeGenRedwoodForest;
import highlands.biome.BiomeGenRockIsland;
import highlands.biome.BiomeGenRockMountains;
import highlands.biome.BiomeGenSahel;
import highlands.biome.BiomeGenSavannah;
import highlands.biome.BiomeGenShrubland;
import highlands.biome.BiomeGenSnowMountains;
import highlands.biome.BiomeGenSteppe;
import highlands.biome.BiomeGenTallPineForest;
import highlands.biome.BiomeGenTropicalIslands;
import highlands.biome.BiomeGenTropics;
import highlands.biome.BiomeGenTundra;
import highlands.biome.BiomeGenVolcanoIsland;
import highlands.biome.BiomeGenWoodlands;
import highlands.biome.BiomeGenWoodsMountains;
import highlands.block.BlockCocoaPlant2;
import highlands.block.BlockHLPlankSlab;
import highlands.block.BlockHighlandsLeaves;
import highlands.block.BlockHighlandsLeaves2;
import highlands.block.BlockHighlandsLog;
import highlands.block.BlockHighlandsLog2;
import highlands.block.BlockHighlandsPlanks;
import highlands.block.BlockHighlandsSapling;
import highlands.block.BlockHighlandsSapling2;
import highlands.block.BlockHighlandsSmallPlants;
import highlands.block.BlockHighlandsStairs;
import highlands.block.ItemBlockMetadata;
import highlands.block.ItemBlockPlanks;
import highlands.block.ItemHighlandsBerries;
import highlands.block.ItemSlabPlanks;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.BiomeGenForest;
import net.minecraft.world.biome.BiomeGenJungle;
import net.minecraft.world.biome.BiomeGenOcean;
import net.minecraft.world.biome.BiomeGenTaiga;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.oredict.OreDictionary;

public class Initializer {
    private static String biomePrefix = "";
    public static boolean tooManyBiomesInstalled;
    private static boolean railcraftInstalled;
    private static final BiomeGenBase.Height desertIsle;
    private static final BiomeGenBase.Height woodIsle;
    private static final BiomeGenBase.Height windIsle;

    public static void constructSettings() {
        Highlands.HighlandsBiomeSizeDefault = Config.biomeSize.getInt();
        Highlands.HighlandsBiomeSizeLB = Config.LBbiomeSize.getInt();
        Highlands.islandRarity = Config.islandRarity.getInt();
        int a = Config.moreOceans.getInt();
        for (int i = 0; i < a; ++i) {
            if (Highlands.improvedOceans && HighlandsBiomes.ocean2 != null) {
                HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.ocean2);
                continue;
            }
            Highlands.improvedOceans = false;
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76771_b);
        }
        Highlands.mocreaturescomp = Config.mobModCompatibility.getBoolean(false);
        Highlands.skyColorFlag = Config.skyColors.getBoolean(false);
        Highlands.vanillaBlocksFlag = !Config.modWoodAndLeaves.getBoolean(true);
        Highlands.plantsFlag = Config.smallPlants.getBoolean(true);
        Highlands.addBoPbiomes = Config.addBoPbiomes.getBoolean(false);
        Highlands.useOreGens = Config.genOre.getBoolean(true);
        Highlands.useGenLayers = !Config.safeMode.getBoolean(false);
        tooManyBiomesInstalled = Loader.isModLoaded((String)"TooManyBiomes");
        railcraftInstalled = Loader.isModLoaded((String)"Railcraft");
    }

    public static void constructBlocks() {
        HighlandsBlocks.acaciaSapling = new BlockHighlandsSapling(1).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_acaciaSapling");
        HighlandsBlocks.beechSapling = new BlockHighlandsSapling(6).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_beechSapling");
        HighlandsBlocks.canopySapling = new BlockHighlandsSapling(4).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_canopySapling");
        HighlandsBlocks.deadSapling = new BlockHighlandsSapling(7).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_deadSapling");
        HighlandsBlocks.greatOakSapling = new BlockHighlandsSapling(5).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_greatOakSapling");
        HighlandsBlocks.firSapling = new BlockHighlandsSapling(0).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_firSapling");
        HighlandsBlocks.poplarSapling = new BlockHighlandsSapling(2).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_poplarSapling");
        HighlandsBlocks.redwoodSapling = new BlockHighlandsSapling(3).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_redwoodSapling");
        HighlandsBlocks.evergreenBushSapling = new BlockHighlandsSapling(8).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_evgBushSapling");
        HighlandsBlocks.deciduousBushSapling = new BlockHighlandsSapling(9).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_decBushSapling");
        HighlandsBlocks.palmSapling = new BlockHighlandsSapling(10).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_palmSapling");
        HighlandsBlocks.ironwoodSapling = new BlockHighlandsSapling(11).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_ironwoodSapling");
        HighlandsBlocks.mangroveSapling = new BlockHighlandsSapling(12).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_mangroveSapling");
        HighlandsBlocks.ashSapling = new BlockHighlandsSapling(13).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_ashSapling");
        HighlandsBlocks.autumnOrangeSapling = new BlockHighlandsSapling(14).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_autumnOrangeSapling");
        HighlandsBlocks.autumnYellowSapling = new BlockHighlandsSapling(15).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_autumnYellowSapling");
        HighlandsBlocks.japaneseMapleSapling = new BlockHighlandsSapling2(1).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_japaneseMapleSapling");
        HighlandsBlocks.acaciaWood = new BlockHighlandsLog(1).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_acaciaWood");
        HighlandsBlocks.canopyWood = new BlockHighlandsLog(4).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_canopyWood");
        HighlandsBlocks.firWood = new BlockHighlandsLog(0).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_firWood");
        HighlandsBlocks.poplarWood = new BlockHighlandsLog(2).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_poplarWood");
        HighlandsBlocks.redwoodWood = new BlockHighlandsLog(3).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_redwoodWood");
        HighlandsBlocks.palmWood = new BlockHighlandsLog(10).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_palmWood");
        HighlandsBlocks.ironWood = new BlockHighlandsLog(11).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_ironwoodWood");
        HighlandsBlocks.mangroveWood = new BlockHighlandsLog(12).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_mangroveWood");
        HighlandsBlocks.ashWood = new BlockHighlandsLog(13).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_ashWood");
        HighlandsBlocks.japaneseMapleWood = new BlockHighlandsLog2(1).func_149711_c(2.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_japaneseMapleWood");
        HighlandsBlocks.acaciaLeaves = new BlockHighlandsLeaves(1).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_acaciaLeaves");
        HighlandsBlocks.canopyLeaves = new BlockHighlandsLeaves(4).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_canopyLeaves");
        HighlandsBlocks.firLeaves = new BlockHighlandsLeaves(0).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_firLeaves");
        HighlandsBlocks.poplarLeaves = new BlockHighlandsLeaves(2).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_poplarLeaves");
        HighlandsBlocks.redwoodLeaves = new BlockHighlandsLeaves(3).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_redwoodLeaves");
        HighlandsBlocks.palmLeaves = new BlockHighlandsLeaves(10).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_palmLeaves");
        HighlandsBlocks.ironwoodLeaves = new BlockHighlandsLeaves(11).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_ironwoodLeaves");
        HighlandsBlocks.mangroveLeaves = new BlockHighlandsLeaves(12).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_mangroveLeaves");
        HighlandsBlocks.ashLeaves = new BlockHighlandsLeaves(13).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_ashLeaves");
        HighlandsBlocks.autumnYellowLeaves = new BlockHighlandsLeaves(14).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_autumnYellowLeaves");
        HighlandsBlocks.autumnOrangeLeaves = new BlockHighlandsLeaves(15).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_autumnOrangeLeaves");
        HighlandsBlocks.japaneseMapleLeaves = new BlockHighlandsLeaves2(1).func_149711_c(0.2f).func_149713_g(1).func_149672_a(Block.field_149779_h).func_149663_c("hl_japaneseMapleLeaves");
        HighlandsBlocks.blueFlower = new BlockHighlandsSmallPlants(0).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_blueFlower");
        HighlandsBlocks.leafyFern = new BlockHighlandsSmallPlants(1).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_leafyFern");
        HighlandsBlocks.whiteFlower = new BlockHighlandsSmallPlants(2).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_whiteFlower");
        HighlandsBlocks.cattail = new BlockHighlandsSmallPlants(3).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_cattail");
        HighlandsBlocks.lavender = new BlockHighlandsSmallPlants(4).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_lavender");
        HighlandsBlocks.raspberryBush = new BlockHighlandsSmallPlants(5).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_raspberryBush");
        HighlandsBlocks.blueberryBush = new BlockHighlandsSmallPlants(6).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_blueberryBush");
        HighlandsBlocks.thornbush = new BlockHighlandsSmallPlants(7).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_thornbush");
        HighlandsBlocks.cotton = new BlockHighlandsSmallPlants(8).func_149711_c(0.0f).func_149672_a(Block.field_149779_h).func_149663_c("hl_cotton");
        HighlandsBlocks.berries = new ItemHighlandsBerries().func_77655_b("hl_berries");
        GameRegistry.registerItem((Item)HighlandsBlocks.berries, (String)"hl_berries");
        HighlandsBlocks.cocoa2 = new BlockCocoaPlant2().func_149663_c("hl_cocoa");
        GameRegistry.registerBlock((Block)HighlandsBlocks.cocoa2, (String)"hl_cocoa");
        HighlandsBlocks.hlplanks = new BlockHighlandsPlanks().func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodPlanks");
        GameRegistry.registerBlock((Block)HighlandsBlocks.hlplanks, ItemBlockPlanks.class, (String)"hl_woodPlanks");
        HighlandsBlocks.hlplankstairs0 = new BlockHighlandsStairs(HighlandsBlocks.hlplanks, 0).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodStairs0");
        Initializer.registerBlock(HighlandsBlocks.hlplankstairs0, "Yellow Wood Stairs");
        HighlandsBlocks.hlplankstairs1 = new BlockHighlandsStairs(HighlandsBlocks.hlplanks, 1).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodStairs1");
        Initializer.registerBlock(HighlandsBlocks.hlplankstairs1, "White Wood Stairs");
        HighlandsBlocks.hlplankstairs2 = new BlockHighlandsStairs(HighlandsBlocks.hlplanks, 2).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodStairs2");
        Initializer.registerBlock(HighlandsBlocks.hlplankstairs2, "Red Wood Stairs");
        HighlandsBlocks.hlplankstairs3 = new BlockHighlandsStairs(HighlandsBlocks.hlplanks, 3).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodStairs3");
        Initializer.registerBlock(HighlandsBlocks.hlplankstairs3, "Grey Wood Stairs");
        HighlandsBlocks.hlplankhalfdouble = new BlockHLPlankSlab(true, HighlandsBlocks.hlplanks).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodSlabDouble");
        GameRegistry.registerBlock((Block)HighlandsBlocks.hlplankhalfdouble, ItemSlabPlanks.class, (String)"hl_woodDoubleSlab");
        HighlandsBlocks.hlplankhalf = new BlockHLPlankSlab(false, HighlandsBlocks.hlplanks).func_149711_c(2.0f).func_149752_b(5.0f).func_149672_a(Block.field_149766_f).func_149663_c("hl_woodSlab");
        GameRegistry.registerBlock((Block)HighlandsBlocks.hlplankhalf, ItemSlabPlanks.class, (String)"hl_woodSlab");
        HighlandsBlocks.saplings = new Block[]{HighlandsBlocks.firSapling, HighlandsBlocks.acaciaSapling, HighlandsBlocks.redwoodSapling, HighlandsBlocks.poplarSapling, HighlandsBlocks.canopySapling, HighlandsBlocks.greatOakSapling, HighlandsBlocks.beechSapling, HighlandsBlocks.deadSapling, HighlandsBlocks.evergreenBushSapling, HighlandsBlocks.deciduousBushSapling, HighlandsBlocks.palmSapling, HighlandsBlocks.ironwoodSapling, HighlandsBlocks.mangroveSapling, HighlandsBlocks.ashSapling, HighlandsBlocks.autumnYellowSapling, HighlandsBlocks.autumnOrangeSapling, HighlandsBlocks.japaneseMapleSapling};
        HighlandsBlocks.leaves = new Block[]{HighlandsBlocks.firLeaves, HighlandsBlocks.acaciaLeaves, HighlandsBlocks.redwoodLeaves, HighlandsBlocks.poplarLeaves, HighlandsBlocks.canopyLeaves, HighlandsBlocks.palmLeaves, HighlandsBlocks.ironwoodLeaves, HighlandsBlocks.mangroveLeaves, HighlandsBlocks.ashLeaves, HighlandsBlocks.autumnYellowLeaves, HighlandsBlocks.autumnOrangeLeaves, HighlandsBlocks.japaneseMapleLeaves};
        HighlandsBlocks.logs = new Block[]{HighlandsBlocks.firWood, HighlandsBlocks.acaciaWood, HighlandsBlocks.redwoodWood, HighlandsBlocks.poplarWood, HighlandsBlocks.canopyWood, HighlandsBlocks.palmWood, HighlandsBlocks.ironWood, HighlandsBlocks.mangroveWood, HighlandsBlocks.ashWood, HighlandsBlocks.japaneseMapleWood};
        HighlandsBlocks.plants = new Block[]{HighlandsBlocks.blueFlower, HighlandsBlocks.leafyFern, HighlandsBlocks.lavender, HighlandsBlocks.cattail, HighlandsBlocks.whiteFlower, HighlandsBlocks.raspberryBush, HighlandsBlocks.blueberryBush, HighlandsBlocks.cotton, HighlandsBlocks.thornbush};
        HighlandsBlocks.planks = new Block[]{HighlandsBlocks.hlplanks, HighlandsBlocks.hlplankstairs0, HighlandsBlocks.hlplankstairs1, HighlandsBlocks.hlplankstairs2, HighlandsBlocks.hlplankstairs3, HighlandsBlocks.hlplankhalf, HighlandsBlocks.hlplankhalfdouble};
    }

    public static void constructBiomes() {
        String string = biomePrefix = Config.biomePrefix.getBoolean(false) ? "Highlands_" : "";
        if (Config.alpsID > -1) {
            HighlandsBiomes.alps = new BiomeGenAlps(Config.alpsID).func_76735_a(biomePrefix + "Alps");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.alps);
        }
        if (Config.autumnForestID > -1) {
            HighlandsBiomes.autumnForest = new BiomeGenAutumnForest(Config.autumnForestID).func_76735_a(biomePrefix + "Autumn Forest");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.autumnForest);
        }
        if (Config.badlandsID > -1) {
            HighlandsBiomes.badlands = new BiomeGenBadlands(Config.badlandsID).func_76735_a(biomePrefix + "Badlands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.badlands);
        }
        if (Config.birchHillsID > -1) {
            HighlandsBiomes.birchHills = new BiomeGenBirchHills(Config.birchHillsID).func_76735_a(biomePrefix + "Birch Hills");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.birchHills);
        }
        if (Config.bogID > -1) {
            HighlandsBiomes.bog = new BiomeGenBog(Config.bogID).func_76735_a(biomePrefix + "Bog");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.bog);
        }
        if (Config.cliffsID > -1) {
            HighlandsBiomes.cliffs = new BiomeGenCliffs(Config.cliffsID).func_76735_a(biomePrefix + "Cliffs");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.cliffs);
        }
        if (Config.desertMountainsID > -1) {
            HighlandsBiomes.desertMountains = new BiomeGenDesertMountains(Config.desertMountainsID).func_76735_a(biomePrefix + "Desert Mountains");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.desertMountains);
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.desertMountains);
        }
        if (Config.dunesID > -1) {
            HighlandsBiomes.dunes = new BiomeGenDunes(Config.dunesID).func_76735_a(biomePrefix + "Dunes");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.dunes);
        }
        if (Config.estuaryID > -1) {
            HighlandsBiomes.estuary = new BiomeGenEstuary(Config.estuaryID).func_76735_a(biomePrefix + "Estuary");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.estuary);
        }
        if (Config.flyingMountainsID > -1) {
            HighlandsBiomes.flyingMountains = new BiomeGenFlyingMountains(Config.flyingMountainsID).func_76735_a(biomePrefix + "Flying Mountains");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.flyingMountains);
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.flyingMountains);
        }
        if (Config.glacierID > -1) {
            HighlandsBiomes.glacier = new BiomeGenGlacier(Config.glacierID).func_76735_a(biomePrefix + "Glacier");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.glacier);
        }
        if (Config.highlandsbID > -1) {
            HighlandsBiomes.highlandsb = new BiomeGenHighlands(Config.highlandsbID).func_76735_a(biomePrefix + "Highlands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.highlandsb);
        }
        if (Config.lowlandsID > -1) {
            HighlandsBiomes.lowlands = new BiomeGenLowlands(Config.lowlandsID).func_76735_a(biomePrefix + "Lowlands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.lowlands);
        }
        if (Config.meadowID > -1) {
            HighlandsBiomes.meadow = new BiomeGenMeadow(Config.meadowID).func_76735_a(biomePrefix + "Meadow");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.meadow);
        }
        if (Config.outbackID > -1) {
            HighlandsBiomes.outback = new BiomeGenOutback(Config.outbackID).func_76735_a(biomePrefix + "Outback");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.outback);
        }
        if (Config.pinelandsID > -1) {
            HighlandsBiomes.pinelands = new BiomeGenPinelands(Config.pinelandsID).func_76735_a(biomePrefix + "Pinelands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.pinelands);
        }
        if (Config.rainforestID > -1) {
            HighlandsBiomes.rainforest = new BiomeGenRainforest(Config.rainforestID).func_76735_a(biomePrefix + "Rainforest");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.rainforest);
        }
        if (Config.redwoodForestID > -1) {
            HighlandsBiomes.redwoodForest = new BiomeGenRedwoodForest(Config.redwoodForestID).func_76735_a(biomePrefix + "Redwood Forest");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.redwoodForest);
        }
        if (Config.rockMountainsID > -1) {
            HighlandsBiomes.rockMountains = new BiomeGenRockMountains(Config.rockMountainsID).func_76735_a(biomePrefix + "Rock Mountains");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.rockMountains);
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.rockMountains);
        }
        if (Config.sahelID > -1) {
            HighlandsBiomes.sahel = new BiomeGenSahel(Config.sahelID).func_76735_a(biomePrefix + "Sahel");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.sahel);
        }
        if (Config.savannahID > -1) {
            HighlandsBiomes.savannah = new BiomeGenSavannah(Config.savannahID).func_76735_a(biomePrefix + "Savannah");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.savannah);
        }
        if (Config.steppeID > -1) {
            HighlandsBiomes.steppe = new BiomeGenSteppe(Config.steppeID).func_76735_a(biomePrefix + "Steppe");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.steppe);
        }
        if (Config.snowMountainsID > -1) {
            HighlandsBiomes.snowMountains = new BiomeGenSnowMountains(Config.snowMountainsID).func_76735_a(biomePrefix + "Snow Mountains");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.snowMountains);
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.snowMountains);
        }
        if (Config.tallPineForestID > -1) {
            HighlandsBiomes.tallPineForest = new BiomeGenTallPineForest(Config.tallPineForestID).func_76735_a(biomePrefix + "Tall Pine Forest");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.tallPineForest);
        }
        if (Config.tropicsID > -1) {
            HighlandsBiomes.tropics = new BiomeGenTropics(Config.tropicsID).func_76735_a(biomePrefix + "Tropics");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.tropics);
        }
        if (Config.tropicalIslandsID > -1) {
            HighlandsBiomes.tropicalIslands = new BiomeGenTropicalIslands(Config.tropicalIslandsID).func_76735_a(biomePrefix + "Tropical Islands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.tropicalIslands);
        }
        if (Config.tundraID > -1) {
            HighlandsBiomes.tundra = new BiomeGenTundra(Config.tundraID).func_76735_a(biomePrefix + "Tundra");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.tundra);
        }
        if (Config.woodlandsID > -1) {
            HighlandsBiomes.woodlands = new BiomeGenWoodlands(Config.woodlandsID).func_76735_a(biomePrefix + "Woodlands");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.woodlands);
        }
        if (Config.woodlandMountainsID > -1) {
            HighlandsBiomes.woodsMountains = new BiomeGenWoodsMountains(Config.woodlandMountainsID).func_76735_a(biomePrefix + "Woodland Mountains");
            HighlandsBiomes.biomesForHighlands.add(HighlandsBiomes.woodsMountains);
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.woodsMountains);
        }
        if (Config.ocean2ID > -1) {
            HighlandsBiomes.ocean2 = new BiomeGenOcean2(Config.ocean2ID).func_76735_a(biomePrefix + "Ocean");
            Highlands.improvedOceans = true;
            BiomeDictionary.registerBiomeType((BiomeGenBase)HighlandsBiomes.ocean2, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{BiomeDictionary.Type.WATER});
            BiomeManager.removeSpawnBiome((BiomeGenBase)HighlandsBiomes.ocean2);
            if (railcraftInstalled) {
                FMLInterModComms.sendMessage((String)"Railcraft", (String)"geode-biome", (String)("" + Config.ocean2ID));
            }
        }
        if (Config.desertIslandID > -1) {
            HighlandsBiomes.desertIsland = new BiomeGenDesertIsland(Config.desertIslandID).func_76735_a(biomePrefix + "Desert Island").func_150570_a(desertIsle);
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.desertIsland);
        }
        if (Config.forestIslandID > -1) {
            HighlandsBiomes.forestIsland = new BiomeGenWoodlands(Config.forestIslandID).func_76735_a(biomePrefix + "Forest Island").func_150570_a(woodIsle);
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.forestIsland);
        }
        if (Config.jungleIslandID > -1) {
            HighlandsBiomes.jungleIsland = new BiomeGenJungle(Config.jungleIslandID, false).func_76735_a(biomePrefix + "Jungle Island").func_150570_a(woodIsle).func_76732_a(1.0f, 1.2f);
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.jungleIsland);
        }
        if (Config.volcanoIslandID > -1) {
            HighlandsBiomes.volcanoIsland = new BiomeGenVolcanoIsland(Config.volcanoIslandID).func_76735_a(biomePrefix + "Volcano Island");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.volcanoIsland);
        }
        if (Config.snowIslandID > -1) {
            HighlandsBiomes.snowIsland = new BiomeGenTaiga(Config.snowIslandID, 3).func_76735_a(biomePrefix + "Snow Island").func_150570_a(woodIsle).func_76732_a(0.0f, 0.6f);
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.snowIsland);
        }
        if (Config.rockIslandID > -1) {
            HighlandsBiomes.rockIsland = new BiomeGenRockIsland(Config.rockIslandID).func_76735_a(biomePrefix + "Rock Island");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.rockIsland);
        }
        if (Config.windyIslandID > -1) {
            HighlandsBiomes.windyIsland = new BiomeGenOcean(Config.windyIslandID).func_76735_a(biomePrefix + "Windy Island").func_150570_a(windIsle);
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.windyIsland);
        }
        if (Config.lakeID > -1) {
            HighlandsBiomes.lake = new BiomeGenLake(Config.lakeID).func_76735_a(biomePrefix + "Lake");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.lake);
        }
        if (Config.baldHillID > -1) {
            HighlandsBiomes.baldHill = new BiomeGenBaldHill(Config.baldHillID).func_76735_a(biomePrefix + "Bald Hill");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.baldHill);
        }
        if (Config.mesaID > -1) {
            HighlandsBiomes.mesa = new BiomeGenMesa(Config.mesaID).func_76735_a(biomePrefix + "Mesa");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.mesa);
        }
        if (Config.valleyID > -1) {
            HighlandsBiomes.valley = new BiomeGenForest(Config.valleyID, 3).func_76735_a(biomePrefix + "Valley");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.valley);
        }
        if (Config.oasisID > -1) {
            HighlandsBiomes.oasis = new BiomeGenOasis(Config.oasisID).func_76735_a(biomePrefix + "Oasis");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.oasis);
        }
        if (Config.canyonID > -1) {
            HighlandsBiomes.canyon = new BiomeGenOutback(Config.canyonID).func_76735_a(biomePrefix + "Canyon");
            HighlandsBiomes.subBiomes.add(HighlandsBiomes.canyon);
        }
        if (Config.shrublandID > -1) {
            HighlandsBiomes.shrubland = new BiomeGenShrubland(Config.shrublandID).func_76735_a(biomePrefix + "Shrubland");
            Highlands.borderBiomeFlag = true;
        }
        HighlandsBiomes.biomesForDefault = (ArrayList)HighlandsBiomes.biomesForHighlands.clone();
        if (Config.plainsGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76772_c);
        }
        if (Config.desertGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76769_d);
        }
        if (Config.extremeHillsGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76770_e);
        }
        if (Config.forestGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76767_f);
        }
        if (Config.swamplandGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76780_h);
        }
        if (Config.jungleGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76782_w);
        }
        if (Config.icePlainsGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76774_n);
        }
        if (Config.taigaGenerate.getBoolean(true)) {
            HighlandsBiomes.biomesForHighlands.add(BiomeGenBase.field_76768_g);
        }
    }

    public static void initRecipes() {
        if (HighlandsBlocks.firSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.firSapling, ItemBlockMetadata.class, "Fir Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.firSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Blocks.field_150364_r, 1, 1)});
        }
        if (HighlandsBlocks.acaciaSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.acaciaSapling, "Acacia Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.acaciaSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 1, 0)});
        }
        if (HighlandsBlocks.poplarSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.poplarSapling, "Poplar Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.poplarSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 0)});
        }
        if (HighlandsBlocks.redwoodSapling != null && HighlandsBlocks.firSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.redwoodSapling, "Redwood Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.redwoodSapling), (Object[])new Object[]{new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(HighlandsBlocks.firSapling, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 0)});
        }
        if (HighlandsBlocks.canopySapling != null) {
            Initializer.registerBlock(HighlandsBlocks.canopySapling, "Canopy Tree Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.canopySapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 1, 3)});
        }
        if (HighlandsBlocks.greatOakSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.greatOakSapling, "Great Oak Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.greatOakSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 0)});
        }
        if (HighlandsBlocks.beechSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.beechSapling, "Beech Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.beechSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 2)});
        }
        if (HighlandsBlocks.evergreenBushSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.evergreenBushSapling, "Evergreen Bushling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.evergreenBushSapling, 2, 0), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 1), new ItemStack(Items.field_151055_y)});
        }
        if (HighlandsBlocks.deciduousBushSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.deciduousBushSapling, "Deciduous Bushling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.deciduousBushSapling, 2, 0), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Items.field_151055_y)});
        }
        if (HighlandsBlocks.palmSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.palmSapling, "Palm Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.palmSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 3), new ItemStack(Blocks.field_150364_r, 1, 2)});
        }
        if (HighlandsBlocks.deadSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.deadSapling, "Dead Tree Sapling");
        }
        if (HighlandsBlocks.ironwoodSapling != null && HighlandsBlocks.beechSapling != null && HighlandsBlocks.greatOakSapling != null && HighlandsBlocks.redwoodSapling != null && HighlandsBlocks.canopySapling != null) {
            Initializer.registerBlock(HighlandsBlocks.ironwoodSapling, "Ironwood Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.ironwoodSapling), (Object[])new Object[]{new ItemStack(HighlandsBlocks.redwoodSapling, 1, 0), new ItemStack(HighlandsBlocks.greatOakSapling, 1, 0), new ItemStack(HighlandsBlocks.canopySapling, 1, 0), new ItemStack(HighlandsBlocks.beechSapling, 1, 0), new ItemStack(Blocks.field_150339_S)});
        }
        if (HighlandsBlocks.mangroveSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.mangroveSapling, "Mangrove Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.mangroveSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 2), new ItemStack(Blocks.field_150364_r, 1, 3)});
        }
        if (HighlandsBlocks.ashSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.ashSapling, "Ash Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.ashSapling), (Object[])new Object[]{new ItemStack(HighlandsBlocks.greatOakSapling, 1, 0), new ItemStack(Blocks.field_150364_r, 1, 3)});
        }
        if (HighlandsBlocks.autumnOrangeSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.autumnOrangeSapling, "Orange Autumn Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.autumnOrangeSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Items.field_151100_aR, 1, 14)});
        }
        if (HighlandsBlocks.autumnYellowSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.autumnYellowSapling, "Yellow Autumn Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.autumnYellowSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Items.field_151100_aR, 1, 11)});
        }
        if (HighlandsBlocks.japaneseMapleSapling != null) {
            Initializer.registerBlock(HighlandsBlocks.japaneseMapleSapling, "Japanese Maple Sapling");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.japaneseMapleSapling), (Object[])new Object[]{new ItemStack(Blocks.field_150345_g, 1, 0), new ItemStack(Items.field_151100_aR, 1, 15)});
        }
        if (HighlandsBlocks.firWood != null) {
            Initializer.registerBlock(HighlandsBlocks.firWood, "Fir Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.firWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 1), (Object[])new Object[]{new ItemStack(HighlandsBlocks.firWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.firWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.acaciaWood != null) {
            Initializer.registerBlock(HighlandsBlocks.acaciaWood, "Acacia Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.acaciaWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.acaciaWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.acaciaWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.poplarWood != null) {
            Initializer.registerBlock(HighlandsBlocks.poplarWood, "Poplar Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.poplarWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 1), (Object[])new Object[]{new ItemStack(HighlandsBlocks.poplarWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.poplarWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.redwoodWood != null) {
            Initializer.registerBlock(HighlandsBlocks.redwoodWood, "Redwood Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.redwoodWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 2), (Object[])new Object[]{new ItemStack(HighlandsBlocks.redwoodWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.redwoodWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.canopyWood != null) {
            Initializer.registerBlock(HighlandsBlocks.canopyWood, "Canopy Tree Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.canopyWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 2), (Object[])new Object[]{new ItemStack(HighlandsBlocks.canopyWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.canopyWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.mangroveWood != null) {
            Initializer.registerBlock(HighlandsBlocks.mangroveWood, "Mangrove Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.mangroveWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 3), (Object[])new Object[]{new ItemStack(HighlandsBlocks.mangroveWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.mangroveWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.ashWood != null) {
            Initializer.registerBlock(HighlandsBlocks.ashWood, "Ash Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.ashWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.ashWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.ashWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.palmWood != null) {
            Initializer.registerBlock(HighlandsBlocks.palmWood, "Palm Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.palmWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Blocks.field_150344_f, 4, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.palmWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.palmWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.ironWood != null) {
            Initializer.registerBlock(HighlandsBlocks.ironWood, "Ironwood Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.ironWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 3), (Object[])new Object[]{new ItemStack(HighlandsBlocks.ironWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.ironWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.japaneseMapleWood != null) {
            Initializer.registerBlock(HighlandsBlocks.japaneseMapleWood, "Japanese Maple Log");
            OreDictionary.registerOre((String)"logWood", (ItemStack)new ItemStack(HighlandsBlocks.japaneseMapleWood, 1, Short.MAX_VALUE));
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 4, 3), (Object[])new Object[]{new ItemStack(HighlandsBlocks.japaneseMapleWood, 1, 0)});
            GameRegistry.addSmelting((Block)HighlandsBlocks.japaneseMapleWood, (ItemStack)new ItemStack(Items.field_151044_h, 1, 1), (float)0.15f);
        }
        if (HighlandsBlocks.hlplanks != null) {
            OreDictionary.registerOre((String)"plankWood", (ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 1, Short.MAX_VALUE));
        }
        if (HighlandsBlocks.hlplanks != null && HighlandsBlocks.hlplankstairs0 != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs0, 4), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 0)});
        }
        if (HighlandsBlocks.hlplanks != null && HighlandsBlocks.hlplankstairs1 != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs1, 4), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 1)});
        }
        if (HighlandsBlocks.hlplanks != null && HighlandsBlocks.hlplankstairs2 != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs2, 4), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 2)});
        }
        if (HighlandsBlocks.hlplanks != null && HighlandsBlocks.hlplankstairs3 != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankstairs3, 4), (Object[])new Object[]{"B  ", "BB ", "BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 3)});
        }
        if (HighlandsBlocks.hlplanks != null && HighlandsBlocks.hlplankhalf != null) {
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankhalf, 6, 0), (Object[])new Object[]{"BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 0)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankhalf, 6, 1), (Object[])new Object[]{"BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 1)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankhalf, 6, 2), (Object[])new Object[]{"BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 2)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplankhalf, 6, 3), (Object[])new Object[]{"BBB", Character.valueOf('B'), new ItemStack(HighlandsBlocks.hlplanks, 1, 3)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 1, 0), (Object[])new Object[]{"P", "P", Character.valueOf('P'), new ItemStack(HighlandsBlocks.hlplankhalf, 1, 0)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 1, 1), (Object[])new Object[]{"P", "P", Character.valueOf('P'), new ItemStack(HighlandsBlocks.hlplankhalf, 1, 1)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 1, 2), (Object[])new Object[]{"P", "P", Character.valueOf('P'), new ItemStack(HighlandsBlocks.hlplankhalf, 1, 2)});
            GameRegistry.addRecipe((ItemStack)new ItemStack(HighlandsBlocks.hlplanks, 1, 3), (Object[])new Object[]{"P", "P", Character.valueOf('P'), new ItemStack(HighlandsBlocks.hlplankhalf, 1, 3)});
        }
        if (HighlandsBlocks.hlplanks == null || HighlandsBlocks.hlplankhalfdouble != null) {
            // empty if block
        }
        if (HighlandsBlocks.firLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.firLeaves, "Fir Leaves");
        }
        if (HighlandsBlocks.acaciaLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.acaciaLeaves, "Acacia Leaves");
        }
        if (HighlandsBlocks.poplarLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.poplarLeaves, "Poplar Leaves");
        }
        if (HighlandsBlocks.redwoodLeaves != null && HighlandsBlocks.firLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.redwoodLeaves, "Redwood Leaves");
        }
        if (HighlandsBlocks.canopyLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.canopyLeaves, "Canopy Tree Leaves");
        }
        if (HighlandsBlocks.ironwoodLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.ironwoodLeaves, "Ironwood Leaves");
        }
        if (HighlandsBlocks.mangroveLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.mangroveLeaves, "Mangrove Leaves");
        }
        if (HighlandsBlocks.ashLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.ashLeaves, "Ash Leaves");
        }
        if (HighlandsBlocks.palmLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.palmLeaves, "Palm Leaves");
        }
        if (HighlandsBlocks.autumnOrangeLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.autumnOrangeLeaves, "Yellow Autumn Leaves");
        }
        if (HighlandsBlocks.autumnYellowLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.autumnYellowLeaves, "Orange Autumn Leaves");
        }
        if (HighlandsBlocks.japaneseMapleLeaves != null) {
            Initializer.registerBlock(HighlandsBlocks.japaneseMapleLeaves, "Japanese Maple Leaves");
        }
        if (HighlandsBlocks.blueFlower != null) {
            Initializer.registerBlock(HighlandsBlocks.blueFlower, "Blue Flower");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 6), (Object[])new Object[]{new ItemStack(HighlandsBlocks.blueFlower, 1, 0)});
        }
        if (HighlandsBlocks.leafyFern != null) {
            Initializer.registerBlock(HighlandsBlocks.leafyFern, "Leafy Fern");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 10), (Object[])new Object[]{new ItemStack(HighlandsBlocks.leafyFern, 1, 0)});
        }
        if (HighlandsBlocks.whiteFlower != null) {
            Initializer.registerBlock(HighlandsBlocks.whiteFlower, "White Flower");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 7), (Object[])new Object[]{new ItemStack(HighlandsBlocks.whiteFlower, 1, 0)});
        }
        if (HighlandsBlocks.cattail != null) {
            Initializer.registerBlock(HighlandsBlocks.cattail, "Cattail");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151121_aF, 1, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.cattail, 1, 0)});
        }
        if (HighlandsBlocks.lavender != null) {
            Initializer.registerBlock(HighlandsBlocks.lavender, "Lavender");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151100_aR, 1, 5), (Object[])new Object[]{new ItemStack(HighlandsBlocks.lavender, 1, 0)});
        }
        if (HighlandsBlocks.raspberryBush != null) {
            Initializer.registerBlock(HighlandsBlocks.raspberryBush, "Raspberry Bush");
            if (HighlandsBlocks.berries != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.berries, 1, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.raspberryBush, 1, 0)});
            }
        }
        if (HighlandsBlocks.blueberryBush != null) {
            Initializer.registerBlock(HighlandsBlocks.blueberryBush, "Blueberry Bush");
            if (HighlandsBlocks.berries != null) {
                GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(HighlandsBlocks.berries, 1, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.blueberryBush, 1, 0)});
            }
        }
        if (HighlandsBlocks.thornbush != null) {
            Initializer.registerBlock(HighlandsBlocks.thornbush, "Thornbush");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151055_y, 2, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.thornbush, 1, 0)});
        }
        if (HighlandsBlocks.cotton != null) {
            Initializer.registerBlock(HighlandsBlocks.cotton, "Cotton Plant");
            GameRegistry.addShapelessRecipe((ItemStack)new ItemStack(Items.field_151007_F, 1, 0), (Object[])new Object[]{new ItemStack(HighlandsBlocks.cotton, 1, 0)});
        }
    }

    public static void registerBlock(Block b, String name) {
        GameRegistry.registerBlock((Block)b, (String)b.func_149739_a());
    }

    public static void registerBlock(Block block, Class<? extends ItemBlock> itemBlockClass, String name) {
        GameRegistry.registerBlock((Block)block, itemBlockClass, (String)name);
    }

    public static void setUpAllSubBiomes() {
        int i;
        ArrayList<BiomeGenBase> enabledBiomes = new ArrayList<BiomeGenBase>();
        for (BiomeGenBase b : HighlandsBiomes.biomesForHighlands) {
            enabledBiomes.add(b);
        }
        for (BiomeGenBase b : HighlandsBiomes.subBiomes) {
            enabledBiomes.add(b);
        }
        Initializer.addSubBiome(HighlandsBiomes.alps, HighlandsBiomes.tallPineForest, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.alps, HighlandsBiomes.glacier, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.alps, BiomeGenBase.field_76777_m, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tropicalIslands, HighlandsBiomes.volcanoIsland, enabledBiomes);
        for (i = 0; i < 3; ++i) {
            Initializer.addSubBiome(HighlandsBiomes.tropicalIslands, HighlandsBiomes.tropicalIslands, enabledBiomes);
        }
        Initializer.addSubBiome(HighlandsBiomes.autumnForest, HighlandsBiomes.baldHill, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.autumnForest, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.birchHills, HighlandsBiomes.meadow, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.cliffs, HighlandsBiomes.valley, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.dunes, HighlandsBiomes.oasis, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.estuary, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.meadow, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.meadow, HighlandsBiomes.birchHills, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.woodlands, HighlandsBiomes.baldHill, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.woodlands, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.woodlands, BiomeGenBase.field_76772_c, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.highlandsb, HighlandsBiomes.woodlands, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.lowlands, HighlandsBiomes.baldHill, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.lowlands, HighlandsBiomes.lake, enabledBiomes);
        for (i = 0; i < 3; ++i) {
            Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.forestIsland, enabledBiomes);
            Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.jungleIsland, enabledBiomes);
            Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.desertIsland, enabledBiomes);
            Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.windyIsland, enabledBiomes);
        }
        for (i = 0; i < Highlands.islandRarity; ++i) {
            Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.ocean2, enabledBiomes);
        }
        Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.snowIsland, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.ocean2, HighlandsBiomes.volcanoIsland, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.outback, HighlandsBiomes.mesa, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.outback, BiomeGenBase.field_76769_d, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.pinelands, HighlandsBiomes.autumnForest, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.redwoodForest, HighlandsBiomes.highlandsb, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.redwoodForest, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.sahel, HighlandsBiomes.mesa, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.sahel, BiomeGenBase.field_76769_d, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.sahel, HighlandsBiomes.savannah, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.savannah, HighlandsBiomes.mesa, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.steppe, HighlandsBiomes.canyon, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tallPineForest, HighlandsBiomes.alps, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tallPineForest, BiomeGenBase.field_76777_m, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.rainforest, HighlandsBiomes.baldHill, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.rainforest, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tropics, HighlandsBiomes.lake, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tundra, HighlandsBiomes.alps, enabledBiomes);
        Initializer.addSubBiome(HighlandsBiomes.tundra, HighlandsBiomes.tallPineForest, enabledBiomes);
    }

    public static void addSubBiome(BiomeGenBase parent, BiomeGenBase sub, ArrayList<BiomeGenBase> list) {
        if (parent != null && sub != null && list.contains(parent) && list.contains(sub)) {
            ((BiomeGenBaseHighlands)parent).subBiomes.add(sub);
        }
    }

    public static void setFireProperties(Block block, int encouragement, int flammability) {
        if (block != null) {
            Blocks.field_150480_ab.setFireInfo(block, encouragement, flammability);
        }
    }

    static {
        desertIsle = new BiomeGenBase.Height(0.1f, 0.1f);
        woodIsle = new BiomeGenBase.Height(0.2f, 0.4f);
        windIsle = new BiomeGenBase.Height(0.1f, 0.2f);
    }
}

